/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qmatrix.qualification.checks;

import eu.europa.esig.dss.QCStatementOids;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.reports.wrapper.CertificateWrapper;
import java.util.Collection;
import java.util.List;

public final class QCTypeIdentifiers {
    private QCTypeIdentifiers() {
    }

    public static boolean isQCTypeEsign(CertificateWrapper certificate) {
        return QCTypeIdentifiers.hasQCTypeOID(certificate, QCStatementOids.QTC_ESIGN);
    }

    public static boolean isQCTypeEseal(CertificateWrapper certificate) {
        return QCTypeIdentifiers.hasQCTypeOID(certificate, QCStatementOids.QTC_ESEAL);
    }

    public static boolean isQCTypeWeb(CertificateWrapper certificate) {
        return QCTypeIdentifiers.hasQCTypeOID(certificate, QCStatementOids.QTC_WEB);
    }

    private static boolean hasQCTypeOID(CertificateWrapper certificate, QCStatementOids ... qcStatements) {
        List qcTypes = certificate.getQCTypes();
        if (Utils.isCollectionNotEmpty((Collection)qcTypes)) {
            for (QCStatementOids qcStatement : qcStatements) {
                if (!qcTypes.contains(qcStatement.getOid())) continue;
                return true;
            }
        }
        return false;
    }
}

