/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qmatrix.qualification;

import eu.europa.esig.dss.jaxb.detailedreport.XmlConclusion;
import eu.europa.esig.dss.jaxb.detailedreport.XmlTLAnalysis;
import eu.europa.esig.dss.jaxb.detailedreport.XmlValidationSignatureQualification;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.SignatureQualification;
import eu.europa.esig.dss.validation.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.policy.rules.Indication;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.Condition;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.QualificationMatrix;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.AcceptableTrustedListCheck;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.AdESAcceptableCheck;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.CertificateAndServiceConsistencyCheck;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.CertificatePathTrustedCheck;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.ForeSignatureAtSigningTimeCheck;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.QSCDCertificateAtSigningTimeCheck;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.QualifiedCertificateAtCertificateIssuanceCheck;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.QualifiedCertificateAtSigningTimeCheck;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.ServiceConsistencyCheck;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.filter.TrustedServiceFilter;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.filter.TrustedServicesFilterFactory;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.qualified.QualifiedStatus;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.type.Type;
import eu.europa.esig.dss.validation.reports.wrapper.CertificateWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.DiagnosticData;
import eu.europa.esig.dss.validation.reports.wrapper.SignatureWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.TrustedServiceWrapper;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SignatureQualificationBlock
extends Chain<XmlValidationSignatureQualification> {
    private final XmlConclusion etsi319102Conclusion;
    private final Map<String, XmlTLAnalysis> tlAnalysisResults;
    private final SignatureWrapper signature;
    private final DiagnosticData diagnosticData;
    private final ValidationPolicy policy;
    private QualifiedCertificateAtSigningTimeCheck qualifiedAtSigningTime;
    private ForeSignatureAtSigningTimeCheck foreSignatureAtSigningTime;
    private QSCDCertificateAtSigningTimeCheck qscdAtSigningTime;

    public SignatureQualificationBlock(XmlConclusion etsi319102Conclusion, Map<String, XmlTLAnalysis> tlAnalysisResults, SignatureWrapper signature, DiagnosticData diagnosticData, ValidationPolicy policy) {
        super(new XmlValidationSignatureQualification());
        ((XmlValidationSignatureQualification)this.result).setId(signature.getId());
        this.etsi319102Conclusion = etsi319102Conclusion;
        this.tlAnalysisResults = tlAnalysisResults;
        this.signature = signature;
        this.diagnosticData = diagnosticData;
        this.policy = policy;
    }

    @Override
    protected void initChain() {
        String signingCertificateId = this.signature.getSigningCertificateId();
        CertificateWrapper signingCertificate = this.diagnosticData.getUsedCertificateById(signingCertificateId);
        ChainItem<XmlValidationSignatureQualification> item = this.firstItem = this.isAdES(this.etsi319102Conclusion);
        item = item.setNextItem(this.certificatePathTrusted(signingCertificate));
        if (signingCertificate != null && signingCertificate.hasTrustedServices()) {
            XmlTLAnalysis lotlAnalysis = this.tlAnalysisResults.get(this.diagnosticData.getLOTLCountryCode());
            if (lotlAnalysis != null) {
                item = item.setNextItem(this.isAcceptableTL(lotlAnalysis));
            }
            Set trustedListCountryCodes = signingCertificate.getTrustedListCountryCodes();
            for (String countryCode : trustedListCountryCodes) {
                XmlTLAnalysis currentTL = this.tlAnalysisResults.get(countryCode);
                if (currentTL == null) continue;
                item = item.setNextItem(this.isAcceptableTL(currentTL));
            }
            List originalTSPs = signingCertificate.getTrustedServices();
            TrustedServiceFilter filter = TrustedServicesFilterFactory.createFilterForAcceptableCAQC();
            List<TrustedServiceWrapper> caqcServices = filter.filter(originalTSPs);
            item = item.setNextItem(this.servicesConsistency(caqcServices));
            item = item.setNextItem(this.serviceAndCertificateConsistency(caqcServices, signingCertificate));
            Date bestSigningTime = this.signature.getDateTime();
            this.qualifiedAtSigningTime = (QualifiedCertificateAtSigningTimeCheck)this.qualifiedCertificateAtSigningTime(signingCertificate, bestSigningTime, caqcServices);
            item = item.setNextItem(this.qualifiedAtSigningTime);
            this.foreSignatureAtSigningTime = (ForeSignatureAtSigningTimeCheck)this.foreSignatureAtSigningTime(signingCertificate, bestSigningTime, caqcServices);
            item = item.setNextItem(this.foreSignatureAtSigningTime);
            item = item.setNextItem(this.qualifiedCertificateAtIssuance(signingCertificate, caqcServices));
            this.qscdAtSigningTime = (QSCDCertificateAtSigningTimeCheck)this.qscdAtSigningTime(signingCertificate, bestSigningTime, caqcServices, this.qualifiedAtSigningTime);
            item = item.setNextItem(this.qscdAtSigningTime);
        }
    }

    @Override
    protected void addAdditionalInfo() {
        this.collectErrorsWarnsInfos();
        this.setIndication();
        this.determineFinalQualification();
    }

    private void determineFinalQualification() {
        SignatureQualification sigQualif = SignatureQualification.NA;
        if (this.isAcceptableConclusion() && this.qualifiedAtSigningTime != null && this.foreSignatureAtSigningTime != null && this.qscdAtSigningTime != null) {
            QualifiedStatus qualifiedStatus = this.qualifiedAtSigningTime.getQualifiedStatus();
            boolean qc = QualifiedStatus.isQC(qualifiedStatus);
            Type type = this.foreSignatureAtSigningTime.getType();
            boolean qscd = this.qscdAtSigningTime.check();
            sigQualif = QualificationMatrix.getSignatureQualification(this.etsi319102Conclusion.getIndication(), qc, type, qscd);
        }
        ((XmlValidationSignatureQualification)this.result).setSignatureQualification(sigQualif);
    }

    private boolean isAcceptableConclusion() {
        XmlConclusion conclusion = ((XmlValidationSignatureQualification)this.result).getConclusion();
        return conclusion != null && Indication.FAILED != conclusion.getIndication();
    }

    private void setIndication() {
        XmlConclusion conclusion = ((XmlValidationSignatureQualification)this.result).getConclusion();
        if (conclusion != null) {
            if (Utils.isCollectionNotEmpty((Collection)conclusion.getErrors())) {
                conclusion.setIndication(Indication.FAILED);
            } else if (Utils.isCollectionNotEmpty((Collection)conclusion.getWarnings())) {
                conclusion.setIndication(Indication.INDETERMINATE);
            } else {
                conclusion.setIndication(Indication.PASSED);
            }
        }
    }

    private ChainItem<XmlValidationSignatureQualification> certificatePathTrusted(CertificateWrapper signingCertificate) {
        return new CertificatePathTrustedCheck((XmlValidationSignatureQualification)this.result, signingCertificate, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationSignatureQualification> isAcceptableTL(XmlTLAnalysis xmlTLAnalysis) {
        return new AcceptableTrustedListCheck((XmlValidationSignatureQualification)this.result, xmlTLAnalysis, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationSignatureQualification> servicesConsistency(List<TrustedServiceWrapper> caqcServices) {
        return new ServiceConsistencyCheck((XmlValidationSignatureQualification)this.result, caqcServices, this.policy.getTLConsistencyConstraint());
    }

    private ChainItem<XmlValidationSignatureQualification> serviceAndCertificateConsistency(List<TrustedServiceWrapper> caqcServices, CertificateWrapper signingCertificate) {
        return new CertificateAndServiceConsistencyCheck((XmlValidationSignatureQualification)this.result, signingCertificate, caqcServices, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationSignatureQualification> isAdES(XmlConclusion etsi319102Conclusion) {
        return new AdESAcceptableCheck((XmlValidationSignatureQualification)this.result, etsi319102Conclusion, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationSignatureQualification> qualifiedCertificateAtSigningTime(CertificateWrapper signingCertificate, Date signingTime, List<TrustedServiceWrapper> caqcServices) {
        return new QualifiedCertificateAtSigningTimeCheck((XmlValidationSignatureQualification)this.result, signingCertificate, signingTime, caqcServices, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationSignatureQualification> foreSignatureAtSigningTime(CertificateWrapper signingCertificate, Date signingTime, List<TrustedServiceWrapper> caqcServices) {
        return new ForeSignatureAtSigningTimeCheck((XmlValidationSignatureQualification)this.result, signingCertificate, signingTime, caqcServices, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationSignatureQualification> qualifiedCertificateAtIssuance(CertificateWrapper signingCertificate, List<TrustedServiceWrapper> caqcServices) {
        return new QualifiedCertificateAtCertificateIssuanceCheck((XmlValidationSignatureQualification)this.result, signingCertificate, caqcServices, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationSignatureQualification> qscdAtSigningTime(CertificateWrapper signingCertificate, Date signingTime, List<TrustedServiceWrapper> caqcServices, Condition qualifiedStatusAtSigningTime) {
        return new QSCDCertificateAtSigningTimeCheck((XmlValidationSignatureQualification)this.result, signingCertificate, signingTime, caqcServices, qualifiedStatusAtSigningTime, this.getWarnLevelConstraint());
    }
}

