/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qmatrix.qualification;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.validation.SignatureQualification;
import eu.europa.esig.dss.validation.policy.rules.Indication;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.type.Type;

public final class QualificationMatrix {
    private static final int NOT_ADES = 0;
    private static final int ADES = 1;
    private static final int INDETERMINATE_ADES = 2;
    private static final int NOT_QC = 0;
    private static final int QC = 1;
    private static final int ESIG = 0;
    private static final int ESEAL = 1;
    private static final int UNKNOWN = 2;
    private static final int NOT_QSCD = 0;
    private static final int QSCD = 1;
    private static final SignatureQualification[][][][] QUALIFS = new SignatureQualification[3][2][3][2];

    private QualificationMatrix() {
    }

    public static SignatureQualification getSignatureQualification(Indication ades, boolean qc, Type type, boolean qscd) {
        return QUALIFS[QualificationMatrix.getInt(ades)][QualificationMatrix.getInt(qc)][QualificationMatrix.getInt(type)][QualificationMatrix.getInt(qscd)];
    }

    private static int getInt(Type type) {
        switch (type) {
            case ESIGN: {
                return 0;
            }
            case ESEAL: 
            case WSA: {
                return 1;
            }
        }
        return 2;
    }

    private static int getInt(boolean bool) {
        return bool ? 1 : 0;
    }

    private static int getInt(Indication indication) {
        switch (indication) {
            case FAILED: 
            case TOTAL_FAILED: {
                return 0;
            }
            case PASSED: 
            case TOTAL_PASSED: {
                return 1;
            }
            case INDETERMINATE: {
                return 2;
            }
        }
        throw new DSSException("Unsupported indication " + indication);
    }

    static {
        QualificationMatrix.QUALIFS[1][1][0][1] = SignatureQualification.QESIG;
        QualificationMatrix.QUALIFS[1][1][1][1] = SignatureQualification.QESEAL;
        QualificationMatrix.QUALIFS[1][1][2][1] = SignatureQualification.QES;
        QualificationMatrix.QUALIFS[1][1][0][0] = SignatureQualification.ADESIG_QC;
        QualificationMatrix.QUALIFS[1][1][1][0] = SignatureQualification.ADESEAL_QC;
        QualificationMatrix.QUALIFS[1][1][2][0] = SignatureQualification.ADES_QC;
        QualificationMatrix.QUALIFS[1][0][0][0] = SignatureQualification.ADESIG;
        QualificationMatrix.QUALIFS[1][0][1][0] = SignatureQualification.ADESEAL;
        QualificationMatrix.QUALIFS[1][0][2][0] = SignatureQualification.ADES;
        QualificationMatrix.QUALIFS[1][0][0][1] = SignatureQualification.ADESIG;
        QualificationMatrix.QUALIFS[1][0][1][1] = SignatureQualification.ADESEAL;
        QualificationMatrix.QUALIFS[1][0][2][1] = SignatureQualification.ADES;
        QualificationMatrix.QUALIFS[2][1][0][1] = SignatureQualification.INDETERMINATE_QESIG;
        QualificationMatrix.QUALIFS[2][1][1][1] = SignatureQualification.INDETERMINATE_QESEAL;
        QualificationMatrix.QUALIFS[2][1][2][1] = SignatureQualification.INDETERMINATE_QES;
        QualificationMatrix.QUALIFS[2][1][0][0] = SignatureQualification.INDETERMINATE_ADESIG_QC;
        QualificationMatrix.QUALIFS[2][1][1][0] = SignatureQualification.INDETERMINATE_ADESEAL_QC;
        QualificationMatrix.QUALIFS[2][1][2][0] = SignatureQualification.INDETERMINATE_ADES_QC;
        QualificationMatrix.QUALIFS[2][0][0][0] = SignatureQualification.INDETERMINATE_ADESIG;
        QualificationMatrix.QUALIFS[2][0][1][0] = SignatureQualification.INDETERMINATE_ADESEAL;
        QualificationMatrix.QUALIFS[2][0][2][0] = SignatureQualification.INDETERMINATE_ADES;
        QualificationMatrix.QUALIFS[2][0][0][1] = SignatureQualification.INDETERMINATE_ADESIG;
        QualificationMatrix.QUALIFS[2][0][1][1] = SignatureQualification.INDETERMINATE_ADESEAL;
        QualificationMatrix.QUALIFS[2][0][2][1] = SignatureQualification.INDETERMINATE_ADES;
        QualificationMatrix.QUALIFS[0][1][0][1] = SignatureQualification.NOT_ADES_QC_QSCD;
        QualificationMatrix.QUALIFS[0][1][1][1] = SignatureQualification.NOT_ADES_QC_QSCD;
        QualificationMatrix.QUALIFS[0][1][2][1] = SignatureQualification.NOT_ADES_QC_QSCD;
        QualificationMatrix.QUALIFS[0][1][0][0] = SignatureQualification.NOT_ADES_QC;
        QualificationMatrix.QUALIFS[0][1][1][0] = SignatureQualification.NOT_ADES_QC;
        QualificationMatrix.QUALIFS[0][1][2][0] = SignatureQualification.NOT_ADES_QC;
        QualificationMatrix.QUALIFS[0][0][0][0] = SignatureQualification.NOT_ADES;
        QualificationMatrix.QUALIFS[0][0][1][0] = SignatureQualification.NOT_ADES;
        QualificationMatrix.QUALIFS[0][0][2][0] = SignatureQualification.NOT_ADES;
        QualificationMatrix.QUALIFS[0][0][0][1] = SignatureQualification.NOT_ADES;
        QualificationMatrix.QUALIFS[0][0][1][1] = SignatureQualification.NOT_ADES;
        QualificationMatrix.QUALIFS[0][0][2][1] = SignatureQualification.NOT_ADES;
    }
}

