/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub;

import eu.europa.esig.dss.jaxb.detailedreport.XmlConstraintsConclusion;
import eu.europa.esig.dss.jaxb.detailedreport.XmlRFC;
import eu.europa.esig.dss.jaxb.detailedreport.XmlSubXCV;
import eu.europa.esig.dss.validation.policy.Context;
import eu.europa.esig.dss.validation.policy.SubContext;
import eu.europa.esig.dss.validation.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.RevocationFreshnessChecker;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.AuthorityInfoAccessPresentCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateCryptographicCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateExpirationCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateIssuedToLegalPersonCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateIssuedToNaturalPersonCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateOnHoldCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificatePolicyIdsCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateQCStatementIdsCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateQualifiedCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateRevokedCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateSignatureValidCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateSupportedByQSCDCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CommonNameCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CountryCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.GivenNameCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.IdPkixOcspNoCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.KeyUsageCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.OrganizationNameCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.OrganizationUnitCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.PseudoUsageCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.PseudonymCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.RevocationFreshnessCheckerResult;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.RevocationInfoAccessPresentCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.SerialNumberCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.SurnameCheck;
import eu.europa.esig.dss.validation.reports.wrapper.CertificateWrapper;
import eu.europa.esig.jaxb.policy.CryptographicConstraint;
import eu.europa.esig.jaxb.policy.LevelConstraint;
import eu.europa.esig.jaxb.policy.MultiValuesConstraint;
import java.util.Date;

public class SubX509CertificateValidation
extends Chain<XmlSubXCV> {
    private final CertificateWrapper currentCertificate;
    private final Date currentTime;
    private final Context context;
    private final SubContext subContext;
    private final ValidationPolicy validationPolicy;

    public SubX509CertificateValidation(CertificateWrapper currentCertificate, Date currentTime, Context context, SubContext subContext, ValidationPolicy validationPolicy) {
        super(new XmlSubXCV());
        ((XmlSubXCV)this.result).setId(currentCertificate.getId());
        ((XmlSubXCV)this.result).setTrustAnchor(Boolean.valueOf(currentCertificate.isTrusted()));
        this.currentCertificate = currentCertificate;
        this.currentTime = currentTime;
        this.context = context;
        this.subContext = subContext;
        this.validationPolicy = validationPolicy;
    }

    @Override
    protected void initChain() {
        if (this.currentCertificate.isTrusted()) {
            return;
        }
        ChainItem<XmlSubXCV> item = this.firstItem = this.serialNumber(this.currentCertificate, this.subContext);
        item = item.setNextItem(this.surname(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.givenName(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.commonName(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.pseudonym(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.country(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.organizationUnit(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.organizationName(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateSignatureValid(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateCryptographic(this.currentCertificate, this.context, this.subContext));
        item = item.setNextItem(this.keyUsage(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.aiaPresent(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.revocationInfoAccessPresent(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateRevoked(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateOnHold(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateExpiration(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificatePolicyIds(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateQCStatementIds(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateQualified(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateSupportedByQSCD(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.pseudoUsage(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateIssuedToLegalPerson(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateIssuedToNaturalPerson(this.currentCertificate, this.subContext));
        if (!this.isRevocationNoNeedCheck(this.currentCertificate)) {
            RevocationFreshnessChecker rfc = new RevocationFreshnessChecker(this.currentCertificate.getLatestRevocationData(), this.currentTime, this.context, this.subContext, this.validationPolicy);
            XmlRFC rfcResult = (XmlRFC)rfc.execute();
            ((XmlSubXCV)this.result).setRFC(rfcResult);
            item = item.setNextItem(this.checkRevocationFreshnessCheckerResult(rfcResult));
        } else {
            item = item.setNextItem(this.idPkixOcspNoCheck());
        }
    }

    private boolean isRevocationNoNeedCheck(CertificateWrapper certificate) {
        if (certificate.isIdPkixOcspNoCheck()) {
            return this.currentTime.compareTo(certificate.getNotBefore()) >= 0 && this.currentTime.compareTo(certificate.getNotAfter()) <= 0;
        }
        return false;
    }

    private ChainItem<XmlSubXCV> certificateExpiration(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateNotExpiredConstraint(this.context, subContext);
        return new CertificateExpirationCheck((XmlSubXCV)this.result, certificate, this.currentTime, constraint);
    }

    private ChainItem<XmlSubXCV> keyUsage(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateKeyUsageConstraint(this.context, subContext);
        return new KeyUsageCheck((XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> aiaPresent(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateAuthorityInfoAccessPresentConstraint(this.context, subContext);
        return new AuthorityInfoAccessPresentCheck((XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> revocationInfoAccessPresent(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateRevocationInfoAccessPresentConstraint(this.context, subContext);
        return new RevocationInfoAccessPresentCheck((XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> surname(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateSurnameConstraint(this.context, subContext);
        return new SurnameCheck((XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> givenName(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateGivenNameConstraint(this.context, subContext);
        return new GivenNameCheck((XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> commonName(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateCommonNameConstraint(this.context, subContext);
        return new CommonNameCheck((XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> pseudonym(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificatePseudonymConstraint(this.context, subContext);
        return new PseudonymCheck((XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> country(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateCountryConstraint(this.context, subContext);
        return new CountryCheck((XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> organizationName(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateOrganizationNameConstraint(this.context, subContext);
        return new OrganizationNameCheck((XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> organizationUnit(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateOrganizationUnitConstraint(this.context, subContext);
        return new OrganizationUnitCheck((XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> serialNumber(CertificateWrapper signingCertificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateSerialNumberConstraint(this.context, subContext);
        return new SerialNumberCheck((XmlSubXCV)this.result, signingCertificate, constraint);
    }

    private ChainItem<XmlSubXCV> pseudoUsage(CertificateWrapper signingCertificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificatePseudoUsageConstraint(this.context, subContext);
        return new PseudoUsageCheck((XmlSubXCV)this.result, signingCertificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateSignatureValid(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateSignatureConstraint(this.context, subContext);
        return new CertificateSignatureValidCheck<XmlConstraintsConclusion>(this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateRevoked(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateNotRevokedConstraint(this.context, subContext);
        return new CertificateRevokedCheck((XmlSubXCV)this.result, certificate, constraint, subContext);
    }

    private ChainItem<XmlSubXCV> certificateOnHold(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateNotOnHoldConstraint(this.context, subContext);
        return new CertificateOnHoldCheck((XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificatePolicyIds(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificatePolicyIdsConstraint(this.context, subContext);
        return new CertificatePolicyIdsCheck((XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateQCStatementIds(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateQCStatementIdsConstraint(this.context, subContext);
        return new CertificateQCStatementIdsCheck((XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateCryptographic(CertificateWrapper certificate, Context context, SubContext subcontext) {
        CryptographicConstraint cryptographicConstraint = this.validationPolicy.getCertificateCryptographicConstraint(context, subcontext);
        return new CertificateCryptographicCheck((XmlSubXCV)this.result, certificate, this.currentTime, cryptographicConstraint);
    }

    private ChainItem<XmlSubXCV> certificateQualified(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateQualificationConstraint(this.context, subContext);
        return new CertificateQualifiedCheck((XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateSupportedByQSCD(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateSupportedByQSCDConstraint(this.context, subContext);
        return new CertificateSupportedByQSCDCheck((XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateIssuedToLegalPerson(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateIssuedToLegalPersonConstraint(this.context, subContext);
        return new CertificateIssuedToLegalPersonCheck((XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateIssuedToNaturalPerson(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateIssuedToNaturalPersonConstraint(this.context, subContext);
        return new CertificateIssuedToNaturalPersonCheck((XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> checkRevocationFreshnessCheckerResult(XmlRFC rfcResult) {
        return new RevocationFreshnessCheckerResult((XmlSubXCV)this.result, rfcResult, this.getFailLevelConstraint());
    }

    private ChainItem<XmlSubXCV> idPkixOcspNoCheck() {
        return new IdPkixOcspNoCheck((XmlSubXCV)this.result, this.getFailLevelConstraint());
    }
}

