/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.rfc;

import eu.europa.esig.dss.jaxb.detailedreport.XmlConstraintsConclusion;
import eu.europa.esig.dss.jaxb.detailedreport.XmlRFC;
import eu.europa.esig.dss.validation.policy.Context;
import eu.europa.esig.dss.validation.policy.SubContext;
import eu.europa.esig.dss.validation.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.checks.NextUpdateCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.checks.RevocationDataAvailableCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.checks.RevocationDataFreshCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.checks.RevocationDataFreshCheckWithNullConstraint;
import eu.europa.esig.dss.validation.reports.wrapper.RevocationWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.TokenProxy;
import eu.europa.esig.jaxb.policy.CryptographicConstraint;
import eu.europa.esig.jaxb.policy.LevelConstraint;
import eu.europa.esig.jaxb.policy.TimeConstraint;
import java.util.Date;

public class RevocationFreshnessChecker
extends Chain<XmlRFC> {
    private final RevocationWrapper revocationData;
    private final Date validationDate;
    private final ValidationPolicy policy;
    private final Context context;
    private final SubContext subContext;

    public RevocationFreshnessChecker(RevocationWrapper revocationData, Date validationDate, Context context, SubContext subContext, ValidationPolicy policy) {
        super(new XmlRFC());
        this.revocationData = revocationData;
        this.validationDate = validationDate;
        this.policy = policy;
        this.context = context;
        this.subContext = subContext;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlRFC> item = this.firstItem = this.revocationDataAvailable(this.revocationData);
        if (this.revocationData != null) {
            item = item.setNextItem(this.nextUpdateCheck(this.revocationData));
            item = item.setNextItem(this.revocationDataFreshCheck(this.revocationData));
            item = item.setNextItem(this.revocationCryptographic(this.revocationData));
        }
    }

    private ChainItem<XmlRFC> revocationDataAvailable(RevocationWrapper revocationData) {
        LevelConstraint constraint = this.policy.getRevocationDataAvailableConstraint(this.context, this.subContext);
        return new RevocationDataAvailableCheck((XmlRFC)this.result, revocationData, constraint);
    }

    private ChainItem<XmlRFC> nextUpdateCheck(RevocationWrapper revocationData) {
        LevelConstraint constraint = this.policy.getRevocationDataNextUpdatePresentConstraint(this.context, this.subContext);
        return new NextUpdateCheck((XmlRFC)this.result, revocationData, constraint);
    }

    private ChainItem<XmlRFC> revocationDataFreshCheck(RevocationWrapper revocationData) {
        TimeConstraint timeConstraint = this.policy.getRevocationFreshnessConstraint();
        if (timeConstraint != null) {
            return new RevocationDataFreshCheck((XmlRFC)this.result, revocationData, this.validationDate, timeConstraint);
        }
        return new RevocationDataFreshCheckWithNullConstraint((XmlRFC)this.result, revocationData, this.validationDate, this.getFailLevelConstraint());
    }

    private ChainItem<XmlRFC> revocationCryptographic(RevocationWrapper revocationData) {
        CryptographicConstraint cryptographicConstraint = this.policy.getCertificateCryptographicConstraint(this.context, this.subContext);
        return new CryptographicCheck<XmlConstraintsConclusion>(this.result, (TokenProxy)revocationData, this.validationDate, cryptographicConstraint);
    }
}

