/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.cv;

import eu.europa.esig.dss.jaxb.detailedreport.XmlCV;
import eu.europa.esig.dss.validation.policy.Context;
import eu.europa.esig.dss.validation.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.cv.checks.AllFilesSignedCheck;
import eu.europa.esig.dss.validation.process.bbb.cv.checks.ReferenceDataExistenceCheck;
import eu.europa.esig.dss.validation.process.bbb.cv.checks.ReferenceDataIntactCheck;
import eu.europa.esig.dss.validation.process.bbb.cv.checks.SignatureIntactCheck;
import eu.europa.esig.dss.validation.reports.wrapper.DiagnosticData;
import eu.europa.esig.dss.validation.reports.wrapper.SignatureWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.TokenProxy;
import eu.europa.esig.jaxb.policy.LevelConstraint;

public class CryptographicVerification
extends Chain<XmlCV> {
    private final DiagnosticData diagnosticData;
    private final TokenProxy token;
    private final ValidationPolicy validationPolicy;
    private final Context context;

    public CryptographicVerification(DiagnosticData diagnosticData, TokenProxy token, Context context, ValidationPolicy validationPolicy) {
        super(new XmlCV());
        this.diagnosticData = diagnosticData;
        this.token = token;
        this.context = context;
        this.validationPolicy = validationPolicy;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlCV> item = this.firstItem = this.referenceDataFound();
        item = item.setNextItem(this.referenceDataIntact());
        item = item.setNextItem(this.signatureIntact());
        if (this.diagnosticData.isContainerInfoPresent() && Context.SIGNATURE == this.context) {
            item = item.setNextItem(this.allFilesSignedCheck());
        }
    }

    private ChainItem<XmlCV> referenceDataFound() {
        LevelConstraint constraint = this.validationPolicy.getReferenceDataExistenceConstraint(this.context);
        return new ReferenceDataExistenceCheck((XmlCV)this.result, this.token, constraint);
    }

    private ChainItem<XmlCV> referenceDataIntact() {
        LevelConstraint constraint = this.validationPolicy.getReferenceDataIntactConstraint(this.context);
        return new ReferenceDataIntactCheck((XmlCV)this.result, this.token, constraint);
    }

    private ChainItem<XmlCV> signatureIntact() {
        LevelConstraint constraint = this.validationPolicy.getSignatureIntactConstraint(this.context);
        return new SignatureIntactCheck((XmlCV)this.result, this.token, constraint);
    }

    private ChainItem<XmlCV> allFilesSignedCheck() {
        LevelConstraint constraint = this.validationPolicy.getAllFilesSignedConstraint();
        return new AllFilesSignedCheck((XmlCV)this.result, (SignatureWrapper)this.token, this.diagnosticData.getContainerInfo(), constraint);
    }
}

