/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.policy;

import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.policy.Context;
import eu.europa.esig.dss.validation.policy.DateUtils;
import eu.europa.esig.dss.validation.policy.SubContext;
import eu.europa.esig.dss.validation.policy.ValidationPolicy;
import eu.europa.esig.jaxb.policy.Algo;
import eu.europa.esig.jaxb.policy.AlgoExpirationDate;
import eu.europa.esig.jaxb.policy.BasicSignatureConstraints;
import eu.europa.esig.jaxb.policy.CertificateConstraints;
import eu.europa.esig.jaxb.policy.ConstraintsParameters;
import eu.europa.esig.jaxb.policy.ContainerConstraints;
import eu.europa.esig.jaxb.policy.CryptographicConstraint;
import eu.europa.esig.jaxb.policy.EIDAS;
import eu.europa.esig.jaxb.policy.LevelConstraint;
import eu.europa.esig.jaxb.policy.MultiValuesConstraint;
import eu.europa.esig.jaxb.policy.RevocationConstraints;
import eu.europa.esig.jaxb.policy.SignatureConstraints;
import eu.europa.esig.jaxb.policy.SignedAttributesConstraints;
import eu.europa.esig.jaxb.policy.TimeConstraint;
import eu.europa.esig.jaxb.policy.TimestampConstraints;
import eu.europa.esig.jaxb.policy.UnsignedAttributesConstraints;
import eu.europa.esig.jaxb.policy.ValueConstraint;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtsiValidationPolicy
implements ValidationPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(EtsiValidationPolicy.class);
    private ConstraintsParameters policy;

    public EtsiValidationPolicy(ConstraintsParameters policy) {
        this.policy = policy;
    }

    @Override
    public Date getAlgorithmExpirationDate(String algorithm, Context context, SubContext subContext) {
        CryptographicConstraint signatureCryptographicConstraint = this.getCertificateCryptographicConstraint(context, subContext);
        if (signatureCryptographicConstraint != null) {
            return this.extractExpirationDate(algorithm, signatureCryptographicConstraint);
        }
        signatureCryptographicConstraint = this.getCertificateCryptographicConstraint(Context.SIGNATURE, SubContext.SIGNING_CERT);
        if (signatureCryptographicConstraint != null) {
            return this.extractExpirationDate(algorithm, signatureCryptographicConstraint);
        }
        return null;
    }

    private Date extractExpirationDate(String algorithm, CryptographicConstraint signatureCryptographicConstraint) {
        AlgoExpirationDate algoExpirationDate = signatureCryptographicConstraint.getAlgoExpirationDate();
        String dateFormat = "yyyy-MM-dd";
        if (algoExpirationDate != null) {
            if (Utils.isStringNotEmpty((String)algoExpirationDate.getFormat())) {
                dateFormat = algoExpirationDate.getFormat();
            }
            List algos = algoExpirationDate.getAlgo();
            String foundExpirationDate = null;
            for (Algo algo : algos) {
                if (!Utils.areStringsEqualIgnoreCase((String)algo.getValue(), (String)algorithm)) continue;
                foundExpirationDate = algo.getDate();
            }
            if (Utils.isStringNotEmpty(foundExpirationDate)) {
                return DateUtils.parseDate(dateFormat, foundExpirationDate);
            }
        }
        return null;
    }

    @Override
    public MultiValuesConstraint getSignaturePolicyConstraint(Context context) {
        SignatureConstraints signatureConstraints = this.getSignatureConstraintsByContext(context);
        if (signatureConstraints != null) {
            return signatureConstraints.getAcceptablePolicies();
        }
        return null;
    }

    @Override
    public LevelConstraint getSignaturePolicyIdentifiedConstraint(Context context) {
        SignatureConstraints signatureConstraints = this.getSignatureConstraintsByContext(context);
        if (signatureConstraints != null) {
            return signatureConstraints.getPolicyAvailable();
        }
        return null;
    }

    @Override
    public LevelConstraint getSignaturePolicyPolicyHashValid(Context context) {
        SignatureConstraints signatureConstraints = this.getSignatureConstraintsByContext(context);
        if (signatureConstraints != null) {
            return signatureConstraints.getPolicyHashMatch();
        }
        return null;
    }

    @Override
    public MultiValuesConstraint getSignatureFormatConstraint(Context context) {
        SignatureConstraints signatureConstraints = this.getSignatureConstraintsByContext(context);
        if (signatureConstraints != null) {
            return signatureConstraints.getAcceptableFormats();
        }
        return null;
    }

    @Override
    public LevelConstraint getStructuralValidationConstraint(Context context) {
        SignatureConstraints signatureConstraints = this.getSignatureConstraintsByContext(context);
        if (signatureConstraints != null) {
            return signatureConstraints.getStructuralValidation();
        }
        return null;
    }

    @Override
    public LevelConstraint getSigningTimeConstraint() {
        SignedAttributesConstraints signedAttributeConstraints;
        SignatureConstraints mainSignature = this.policy.getSignatureConstraints();
        if (mainSignature != null && (signedAttributeConstraints = mainSignature.getSignedAttributes()) != null) {
            return signedAttributeConstraints.getSigningTime();
        }
        return null;
    }

    @Override
    public ValueConstraint getContentTypeConstraint() {
        SignedAttributesConstraints signedAttributeConstraints;
        SignatureConstraints mainSignature = this.policy.getSignatureConstraints();
        if (mainSignature != null && (signedAttributeConstraints = mainSignature.getSignedAttributes()) != null) {
            return signedAttributeConstraints.getContentType();
        }
        return null;
    }

    @Override
    public LevelConstraint getCounterSignatureConstraint() {
        UnsignedAttributesConstraints unsignedAttributeConstraints;
        SignatureConstraints mainSignature = this.policy.getSignatureConstraints();
        if (mainSignature != null && (unsignedAttributeConstraints = mainSignature.getUnsignedAttributes()) != null) {
            return unsignedAttributeConstraints.getCounterSignature();
        }
        return null;
    }

    @Override
    public ValueConstraint getContentHintsConstraint() {
        SignedAttributesConstraints signedAttributeConstraints;
        SignatureConstraints mainSignature = this.policy.getSignatureConstraints();
        if (mainSignature != null && (signedAttributeConstraints = mainSignature.getSignedAttributes()) != null) {
            return signedAttributeConstraints.getContentHints();
        }
        return null;
    }

    @Override
    public ValueConstraint getContentIdentifierConstraint() {
        SignedAttributesConstraints signedAttributeConstraints;
        SignatureConstraints mainSignature = this.policy.getSignatureConstraints();
        if (mainSignature != null && (signedAttributeConstraints = mainSignature.getSignedAttributes()) != null) {
            return signedAttributeConstraints.getContentIdentifier();
        }
        return null;
    }

    @Override
    public MultiValuesConstraint getCommitmentTypeIndicationConstraint() {
        SignedAttributesConstraints signedAttributeConstraints;
        SignatureConstraints mainSignature = this.policy.getSignatureConstraints();
        if (mainSignature != null && (signedAttributeConstraints = mainSignature.getSignedAttributes()) != null) {
            return signedAttributeConstraints.getCommitmentTypeIndication();
        }
        return null;
    }

    @Override
    public LevelConstraint getSignerLocationConstraint() {
        SignedAttributesConstraints signedAttributeConstraints;
        SignatureConstraints mainSignature = this.policy.getSignatureConstraints();
        if (mainSignature != null && (signedAttributeConstraints = mainSignature.getSignedAttributes()) != null) {
            return signedAttributeConstraints.getSignerLocation();
        }
        return null;
    }

    @Override
    public MultiValuesConstraint getClaimedRoleConstraint() {
        SignedAttributesConstraints signedAttributes;
        SignatureConstraints mainSignature = this.policy.getSignatureConstraints();
        if (mainSignature != null && (signedAttributes = mainSignature.getSignedAttributes()) != null) {
            return signedAttributes.getClaimedRoles();
        }
        return null;
    }

    @Override
    public MultiValuesConstraint getCertifiedRolesConstraint() {
        SignedAttributesConstraints signedAttributes;
        SignatureConstraints mainSignature = this.policy.getSignatureConstraints();
        if (mainSignature != null && (signedAttributes = mainSignature.getSignedAttributes()) != null) {
            return signedAttributes.getCertifiedRoles();
        }
        return null;
    }

    @Override
    public String getPolicyName() {
        return this.policy.getName();
    }

    @Override
    public String getPolicyDescription() {
        return this.policy.getDescription();
    }

    @Override
    public CryptographicConstraint getSignatureCryptographicConstraint(Context context) {
        BasicSignatureConstraints basicSignature = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignature != null) {
            return basicSignature.getCryptographic();
        }
        return null;
    }

    @Override
    public CryptographicConstraint getCertificateCryptographicConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return certificateConstraints.getCryptographic();
        }
        return null;
    }

    @Override
    public MultiValuesConstraint getCertificateKeyUsageConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return certificateConstraints.getKeyUsage();
        }
        return null;
    }

    @Override
    public MultiValuesConstraint getCertificateSurnameConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return certificateConstraints.getSurname();
        }
        return null;
    }

    @Override
    public MultiValuesConstraint getCertificateGivenNameConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return certificateConstraints.getGivenName();
        }
        return null;
    }

    @Override
    public MultiValuesConstraint getCertificateCommonNameConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return certificateConstraints.getCommonName();
        }
        return null;
    }

    @Override
    public MultiValuesConstraint getCertificatePseudonymConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return certificateConstraints.getPseudonym();
        }
        return null;
    }

    @Override
    public MultiValuesConstraint getCertificateCountryConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return certificateConstraints.getCountry();
        }
        return null;
    }

    @Override
    public MultiValuesConstraint getCertificateOrganizationNameConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return certificateConstraints.getOrganizationName();
        }
        return null;
    }

    @Override
    public MultiValuesConstraint getCertificateOrganizationUnitConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return certificateConstraints.getOrganizationUnit();
        }
        return null;
    }

    @Override
    public LevelConstraint getCertificatePseudoUsageConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return certificateConstraints.getUsePseudonym();
        }
        return null;
    }

    @Override
    public LevelConstraint getCertificateSerialNumberConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return certificateConstraints.getSerialNumberPresent();
        }
        return null;
    }

    @Override
    public LevelConstraint getCertificateNotExpiredConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return certificateConstraints.getNotExpired();
        }
        return null;
    }

    @Override
    public LevelConstraint getProspectiveCertificateChainConstraint(Context context) {
        BasicSignatureConstraints basicSignatureConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignatureConstraints != null) {
            return basicSignatureConstraints.getProspectiveCertificateChain();
        }
        return null;
    }

    @Override
    public LevelConstraint getCertificateAuthorityInfoAccessPresentConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return certificateConstraints.getAuthorityInfoAccessPresent();
        }
        return null;
    }

    @Override
    public LevelConstraint getCertificateRevocationInfoAccessPresentConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return certificateConstraints.getRevocationInfoAccessPresent();
        }
        return null;
    }

    @Override
    public LevelConstraint getCertificateSignatureConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return certificateConstraints.getSignature();
        }
        return null;
    }

    @Override
    public LevelConstraint getRevocationDataAvailableConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return certificateConstraints.getRevocationDataAvailable();
        }
        return null;
    }

    @Override
    public LevelConstraint getRevocationDataNextUpdatePresentConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return certificateConstraints.getRevocationDataNextUpdatePresent();
        }
        return null;
    }

    @Override
    public LevelConstraint getCertificateNotRevokedConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return certificateConstraints.getNotRevoked();
        }
        return null;
    }

    @Override
    public LevelConstraint getCertificateNotOnHoldConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return certificateConstraints.getNotOnHold();
        }
        return null;
    }

    @Override
    public MultiValuesConstraint getTrustedServiceStatusConstraint(Context context) {
        BasicSignatureConstraints sigConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (sigConstraints != null) {
            return sigConstraints.getTrustedServiceStatus();
        }
        return null;
    }

    @Override
    public MultiValuesConstraint getTrustedServiceTypeIdentifierConstraint(Context context) {
        BasicSignatureConstraints sigConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (sigConstraints != null) {
            return sigConstraints.getTrustedServiceTypeIdentifier();
        }
        return null;
    }

    @Override
    public MultiValuesConstraint getCertificatePolicyIdsConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return certificateConstraints.getPolicyIds();
        }
        return null;
    }

    @Override
    public MultiValuesConstraint getCertificateQCStatementIdsConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return certificateConstraints.getQCStatementIds();
        }
        return null;
    }

    @Override
    public LevelConstraint getCertificateIssuedToNaturalPersonConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return certificateConstraints.getIssuedToNaturalPerson();
        }
        return null;
    }

    @Override
    public LevelConstraint getCertificateQualificationConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return certificateConstraints.getQualification();
        }
        return null;
    }

    @Override
    public LevelConstraint getCertificateSupportedByQSCDConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return certificateConstraints.getSupportedByQSCD();
        }
        return null;
    }

    @Override
    public LevelConstraint getCertificateIssuedToLegalPersonConstraint(Context context, SubContext subContext) {
        CertificateConstraints certificateConstraints = this.getCertificateConstraints(context, subContext);
        if (certificateConstraints != null) {
            return certificateConstraints.getIssuedToLegalPerson();
        }
        return null;
    }

    @Override
    public LevelConstraint getSigningCertificateRecognitionConstraint(Context context) {
        CertificateConstraints certificateConstraints = this.getSigningCertificateByContext(context);
        if (certificateConstraints != null) {
            return certificateConstraints.getRecognition();
        }
        return null;
    }

    @Override
    public LevelConstraint getSigningCertificateSignedConstraint(Context context) {
        SignedAttributesConstraints signedAttributeConstraints;
        SignatureConstraints mainSignature = this.getSignatureConstraintsByContext(context);
        if (mainSignature != null && (signedAttributeConstraints = mainSignature.getSignedAttributes()) != null) {
            return signedAttributeConstraints.getSigningCertificateSigned();
        }
        return null;
    }

    @Override
    public LevelConstraint getSigningCertificateAttributePresentConstraint(Context context) {
        SignedAttributesConstraints signedAttributeConstraints;
        SignatureConstraints mainSignature = this.getSignatureConstraintsByContext(context);
        if (mainSignature != null && (signedAttributeConstraints = mainSignature.getSignedAttributes()) != null) {
            return signedAttributeConstraints.getSigningCertificatePresent();
        }
        return null;
    }

    @Override
    public LevelConstraint getSigningCertificateDigestValuePresentConstraint(Context context) {
        SignedAttributesConstraints signedAttributeConstraints;
        SignatureConstraints mainSignature = this.getSignatureConstraintsByContext(context);
        if (mainSignature != null && (signedAttributeConstraints = mainSignature.getSignedAttributes()) != null) {
            return signedAttributeConstraints.getCertDigestPresent();
        }
        return null;
    }

    @Override
    public LevelConstraint getSigningCertificateDigestValueMatchConstraint(Context context) {
        SignedAttributesConstraints signedAttributeConstraints;
        SignatureConstraints mainSignature = this.getSignatureConstraintsByContext(context);
        if (mainSignature != null && (signedAttributeConstraints = mainSignature.getSignedAttributes()) != null) {
            return signedAttributeConstraints.getCertDigestMatch();
        }
        return null;
    }

    @Override
    public LevelConstraint getSigningCertificateIssuerSerialMatchConstraint(Context context) {
        SignedAttributesConstraints signedAttributeConstraints;
        SignatureConstraints mainSignature = this.getSignatureConstraintsByContext(context);
        if (mainSignature != null && (signedAttributeConstraints = mainSignature.getSignedAttributes()) != null) {
            return signedAttributeConstraints.getIssuerSerialMatch();
        }
        return null;
    }

    @Override
    public LevelConstraint getReferenceDataExistenceConstraint(Context context) {
        BasicSignatureConstraints basicSignatureConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignatureConstraints != null) {
            return basicSignatureConstraints.getReferenceDataExistence();
        }
        return null;
    }

    @Override
    public LevelConstraint getReferenceDataIntactConstraint(Context context) {
        BasicSignatureConstraints basicSignatureConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignatureConstraints != null) {
            return basicSignatureConstraints.getReferenceDataIntact();
        }
        return null;
    }

    @Override
    public LevelConstraint getSignatureIntactConstraint(Context context) {
        BasicSignatureConstraints basicSignatureConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignatureConstraints != null) {
            return basicSignatureConstraints.getSignatureIntact();
        }
        return null;
    }

    @Override
    public LevelConstraint getMessageImprintDataFoundConstraint() {
        TimestampConstraints timestamp = this.policy.getTimestamp();
        if (timestamp != null) {
            return timestamp.getMessageImprintDataFound();
        }
        return null;
    }

    @Override
    public LevelConstraint getMessageImprintDataIntactConstraint() {
        TimestampConstraints timestamp = this.policy.getTimestamp();
        if (timestamp != null) {
            return timestamp.getMessageImprintDataIntact();
        }
        return null;
    }

    @Override
    public LevelConstraint getBestSignatureTimeBeforeIssuanceDateOfSigningCertificateConstraint() {
        TimestampConstraints timestamp = this.policy.getTimestamp();
        if (timestamp != null) {
            return timestamp.getBestSignatureTimeBeforeIssuanceDateOfSigningCertificate();
        }
        return null;
    }

    @Override
    public LevelConstraint getSigningCertificateValidityAtBestSignatureTimeConstraint() {
        TimestampConstraints timestamp = this.policy.getTimestamp();
        if (timestamp != null) {
            return timestamp.getSigningCertificateValidityAtBestSignatureTime();
        }
        return null;
    }

    @Override
    public LevelConstraint getAlgorithmReliableAtBestSignatureTimeConstraint() {
        TimestampConstraints timestamp = this.policy.getTimestamp();
        if (timestamp != null) {
            return timestamp.getAlgorithmReliableAtBestSignatureTime();
        }
        return null;
    }

    @Override
    public LevelConstraint getTimestampCoherenceConstraint() {
        TimestampConstraints timestampConstraints = this.policy.getTimestamp();
        if (timestampConstraints != null) {
            return timestampConstraints.getCoherence();
        }
        return null;
    }

    @Override
    public TimeConstraint getTimestampDelaySigningTimePropertyConstraint() {
        TimestampConstraints timestampConstraints = this.policy.getTimestamp();
        if (timestampConstraints != null) {
            return timestampConstraints.getTimestampDelay();
        }
        return null;
    }

    @Override
    public TimeConstraint getRevocationFreshnessConstraint() {
        RevocationConstraints revocationConstraints = this.policy.getRevocation();
        if (revocationConstraints != null) {
            return revocationConstraints.getRevocationFreshness();
        }
        return null;
    }

    @Override
    public LevelConstraint getContentTimestampConstraint() {
        SignedAttributesConstraints signedAttributeConstraints;
        SignatureConstraints mainSignature = this.policy.getSignatureConstraints();
        if (mainSignature != null && (signedAttributeConstraints = mainSignature.getSignedAttributes()) != null) {
            return signedAttributeConstraints.getContentTimeStamp();
        }
        return null;
    }

    private CertificateConstraints getSigningCertificateByContext(Context context) {
        return this.getCertificateConstraints(context, SubContext.SIGNING_CERT);
    }

    private CertificateConstraints getCertificateConstraints(Context context, SubContext subContext) {
        BasicSignatureConstraints basicSignatureConstraints = this.getBasicSignatureConstraintsByContext(context);
        if (basicSignatureConstraints != null) {
            if (SubContext.SIGNING_CERT.equals((Object)subContext)) {
                return basicSignatureConstraints.getSigningCertificate();
            }
            if (SubContext.CA_CERTIFICATE.equals((Object)subContext)) {
                return basicSignatureConstraints.getCACertificate();
            }
        }
        return null;
    }

    private BasicSignatureConstraints getBasicSignatureConstraintsByContext(Context context) {
        switch (context) {
            case SIGNATURE: {
                SignatureConstraints mainSignature = this.policy.getSignatureConstraints();
                if (mainSignature == null) break;
                return mainSignature.getBasicSignatureConstraints();
            }
            case COUNTER_SIGNATURE: {
                SignatureConstraints counterSignature = this.policy.getCounterSignatureConstraints();
                if (counterSignature == null) break;
                return counterSignature.getBasicSignatureConstraints();
            }
            case TIMESTAMP: {
                TimestampConstraints timestampConstraints = this.policy.getTimestamp();
                if (timestampConstraints == null) break;
                return timestampConstraints.getBasicSignatureConstraints();
            }
            case REVOCATION: {
                RevocationConstraints revocationConstraints = this.policy.getRevocation();
                if (revocationConstraints != null) {
                    return revocationConstraints.getBasicSignatureConstraints();
                }
            }
            default: {
                LOG.warn("Unsupported context " + context);
            }
        }
        return null;
    }

    private SignatureConstraints getSignatureConstraintsByContext(Context context) {
        switch (context) {
            case SIGNATURE: {
                return this.policy.getSignatureConstraints();
            }
            case COUNTER_SIGNATURE: {
                return this.policy.getCounterSignatureConstraints();
            }
        }
        LOG.warn("Unsupported context " + context);
        return null;
    }

    @Override
    public MultiValuesConstraint getAcceptedContainerTypesConstraint() {
        ContainerConstraints containerConstraints = this.policy.getContainerConstraints();
        if (containerConstraints != null) {
            return containerConstraints.getAcceptableContainerTypes();
        }
        return null;
    }

    @Override
    public LevelConstraint getZipCommentPresentConstraint() {
        ContainerConstraints containerConstraints = this.policy.getContainerConstraints();
        if (containerConstraints != null) {
            return containerConstraints.getZipCommentPresent();
        }
        return null;
    }

    @Override
    public MultiValuesConstraint getAcceptedZipCommentsConstraint() {
        ContainerConstraints containerConstraints = this.policy.getContainerConstraints();
        if (containerConstraints != null) {
            return containerConstraints.getAcceptableZipComment();
        }
        return null;
    }

    @Override
    public LevelConstraint getMimeTypeFilePresentConstraint() {
        ContainerConstraints containerConstraints = this.policy.getContainerConstraints();
        if (containerConstraints != null) {
            return containerConstraints.getMimeTypeFilePresent();
        }
        return null;
    }

    @Override
    public MultiValuesConstraint getAcceptedMimeTypeContentsConstraint() {
        ContainerConstraints containerConstraints = this.policy.getContainerConstraints();
        if (containerConstraints != null) {
            return containerConstraints.getAcceptableMimeTypeFileContent();
        }
        return null;
    }

    @Override
    public LevelConstraint getAllFilesSignedConstraint() {
        ContainerConstraints containerConstraints = this.policy.getContainerConstraints();
        if (containerConstraints != null) {
            return containerConstraints.getAllFilesSigned();
        }
        return null;
    }

    @Override
    public LevelConstraint getManifestFilePresentConstraint() {
        ContainerConstraints containerConstraints = this.policy.getContainerConstraints();
        if (containerConstraints != null) {
            return containerConstraints.getManifestFilePresent();
        }
        return null;
    }

    @Override
    public boolean isEIDASConstraintPresent() {
        return this.policy.getEIDAS() != null;
    }

    @Override
    public TimeConstraint getTLFreshnessConstraint() {
        EIDAS eIDASConstraints = this.policy.getEIDAS();
        if (eIDASConstraints != null) {
            return eIDASConstraints.getTLFreshness();
        }
        return null;
    }

    @Override
    public LevelConstraint getTLWellSignedConstraint() {
        EIDAS eIDASConstraints = this.policy.getEIDAS();
        if (eIDASConstraints != null) {
            return eIDASConstraints.getTLWellSigned();
        }
        return null;
    }

    @Override
    public LevelConstraint getTLNotExpiredConstraint() {
        EIDAS eIDASConstraints = this.policy.getEIDAS();
        if (eIDASConstraints != null) {
            return eIDASConstraints.getTLNotExpired();
        }
        return null;
    }

    @Override
    public ValueConstraint getTLVersionConstraint() {
        EIDAS eIDASConstraints = this.policy.getEIDAS();
        if (eIDASConstraints != null) {
            return eIDASConstraints.getTLVersion();
        }
        return null;
    }

    @Override
    public LevelConstraint getTLConsistencyConstraint() {
        EIDAS eIDASConstraints = this.policy.getEIDAS();
        if (eIDASConstraints != null) {
            return eIDASConstraints.getTLConsistency();
        }
        return null;
    }
}

