/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.policy.jaxb.MultiValuesConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.Collection;
import java.util.List;

public abstract class AbstractMultiValuesCheckItem<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private static final String ALL_VALUE = "*";
    private final MultiValuesConstraint constraint;

    protected AbstractMultiValuesCheckItem(I18nProvider i18nProvider, T result, MultiValuesConstraint constraint) {
        super(i18nProvider, result, (LevelConstraint)constraint);
        this.constraint = constraint;
    }

    protected boolean processValueCheck(String value) {
        List expectedValues = this.constraint.getId();
        if (Utils.isStringNotEmpty((String)value) && Utils.isCollectionNotEmpty((Collection)expectedValues)) {
            return expectedValues.contains(ALL_VALUE) || expectedValues.contains(value);
        }
        return false;
    }

    protected boolean processValuesCheck(List<String> values) {
        if (Utils.isCollectionNotEmpty(values)) {
            for (String value : values) {
                if (!this.processValueCheck(value)) continue;
                return true;
            }
            return false;
        }
        return Utils.isCollectionEmpty((Collection)this.constraint.getId());
    }
}

