/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.executor.certificate;

import eu.europa.esig.dss.detailedreport.DetailedReport;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.TrustedServiceWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlLangAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOID;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedService;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedServiceProvider;
import eu.europa.esig.dss.simplecertificatereport.jaxb.XmlChainItem;
import eu.europa.esig.dss.simplecertificatereport.jaxb.XmlRevocation;
import eu.europa.esig.dss.simplecertificatereport.jaxb.XmlSimpleCertificateReport;
import eu.europa.esig.dss.simplecertificatereport.jaxb.XmlSubject;
import eu.europa.esig.dss.simplecertificatereport.jaxb.XmlTrustAnchor;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SimpleReportForCertificateBuilder {
    private final DiagnosticData diagnosticData;
    private final DetailedReport detailedReport;
    private final Date currentTime;
    private final String certificateId;

    public SimpleReportForCertificateBuilder(DiagnosticData diagnosticData, DetailedReport detailedReport, Date currentTime, String certificateId) {
        this.diagnosticData = diagnosticData;
        this.detailedReport = detailedReport;
        this.currentTime = currentTime;
        this.certificateId = certificateId;
    }

    public XmlSimpleCertificateReport build() {
        XmlSimpleCertificateReport simpleReport = new XmlSimpleCertificateReport();
        simpleReport.setValidationTime(this.currentTime);
        ArrayList<XmlChainItem> chain = new ArrayList<XmlChainItem>();
        CertificateWrapper certificate = this.diagnosticData.getUsedCertificateById(this.certificateId);
        XmlChainItem firstChainItem = this.getChainItem(certificate);
        this.addQualifications(firstChainItem, certificate);
        chain.add(firstChainItem);
        List certificateChain = certificate.getCertificateChain();
        for (CertificateWrapper cert : certificateChain) {
            chain.add(this.getChainItem(cert));
        }
        simpleReport.setChain(chain);
        return simpleReport;
    }

    private XmlChainItem getChainItem(CertificateWrapper certificate) {
        XmlChainItem item = new XmlChainItem();
        item.setId(certificate.getId());
        item.setSubject(this.getSubject(certificate));
        CertificateWrapper signingCertificate = certificate.getSigningCertificate();
        if (signingCertificate != null) {
            item.setIssuerId(signingCertificate.getId());
        }
        item.setNotBefore(certificate.getNotBefore());
        item.setNotAfter(certificate.getNotAfter());
        item.setKeyUsages(certificate.getKeyUsages());
        item.setExtendedKeyUsages(this.getReadable(certificate.getExtendedKeyUsages()));
        item.setAiaUrls(this.emptyToNull(certificate.getAuthorityInformationAccessUrls()));
        item.setOcspUrls(this.emptyToNull(certificate.getOCSPAccessUrls()));
        item.setCrlUrls(this.emptyToNull(certificate.getCRLDistributionPoints()));
        item.setCpsUrls(this.emptyToNull(certificate.getCpsUrls()));
        item.setPdsUrls(null);
        XmlRevocation revocation = new XmlRevocation();
        CertificateRevocationWrapper revocationData = this.diagnosticData.getLatestRevocationDataForCertificate(certificate);
        if (revocationData != null) {
            revocation.setThisUpdate(revocationData.getThisUpdate());
            revocation.setRevocationDate(revocationData.getRevocationDate());
            revocation.setRevocationReason(revocationData.getReason());
        }
        item.setRevocation(revocation);
        if (certificate.isTrusted()) {
            List<XmlTrustedServiceProvider> trustServiceProviders = this.filterByCertificateId(certificate.getTrustServiceProviders(), certificate.getId());
            ArrayList<XmlTrustAnchor> trustAnchors = new ArrayList<XmlTrustAnchor>();
            for (XmlTrustedServiceProvider xmlTrustedServiceProvider : trustServiceProviders) {
                List trustedServices = xmlTrustedServiceProvider.getTrustedServices();
                Set<String> uniqueServiceNames = this.getUniqueServiceNames(trustedServices);
                for (String serviceName : uniqueServiceNames) {
                    XmlTrustAnchor trustAnchor = new XmlTrustAnchor();
                    trustAnchor.setCountryCode(xmlTrustedServiceProvider.getTL().getCountryCode());
                    trustAnchor.setTrustServiceProvider(this.getFirst(xmlTrustedServiceProvider.getTSPNames()));
                    List tspRegistrationIdentifiers = xmlTrustedServiceProvider.getTSPRegistrationIdentifiers();
                    if (Utils.isCollectionNotEmpty((Collection)tspRegistrationIdentifiers)) {
                        trustAnchor.setTrustServiceProviderRegistrationId((String)tspRegistrationIdentifiers.get(0));
                    }
                    trustAnchor.setTrustServiceName(serviceName);
                    trustAnchors.add(trustAnchor);
                }
            }
            item.setTrustAnchors(trustAnchors);
        } else {
            item.setTrustAnchors(null);
        }
        XmlConclusion conclusion = this.detailedReport.getCertificateXCVConclusion(certificate.getId());
        item.setIndication(conclusion.getIndication());
        item.setSubIndication(conclusion.getSubIndication());
        return item;
    }

    private String getFirst(List<XmlLangAndValue> langAndValues) {
        if (Utils.isCollectionNotEmpty(langAndValues)) {
            return langAndValues.get(0).getValue();
        }
        return null;
    }

    private List<XmlTrustedServiceProvider> filterByCertificateId(List<XmlTrustedServiceProvider> trustServiceProviders, String certificateId) {
        ArrayList<XmlTrustedServiceProvider> result = new ArrayList<XmlTrustedServiceProvider>();
        for (XmlTrustedServiceProvider xmlTrustedServiceProvider : trustServiceProviders) {
            List trustedServices = xmlTrustedServiceProvider.getTrustedServices();
            boolean foundCertId = false;
            for (XmlTrustedService xmlTrustedService : trustedServices) {
                if (!Utils.areStringsEqual((String)certificateId, (String)xmlTrustedService.getServiceDigitalIdentifier().getId())) continue;
                foundCertId = true;
                break;
            }
            if (!foundCertId) continue;
            result.add(xmlTrustedServiceProvider);
        }
        return result;
    }

    private List<String> getReadable(List<XmlOID> oids) {
        if (Utils.isCollectionNotEmpty(oids)) {
            ArrayList<String> result = new ArrayList<String>();
            for (XmlOID xmlOID : oids) {
                if (Utils.isStringNotEmpty((String)xmlOID.getDescription())) {
                    result.add(xmlOID.getDescription());
                    continue;
                }
                result.add(xmlOID.getValue());
            }
            return result;
        }
        return null;
    }

    private Set<String> getUniqueServiceNames(List<XmlTrustedService> trustedServices) {
        HashSet<String> result = new HashSet<String>();
        for (XmlTrustedService xmlTrustedService : trustedServices) {
            result.add(this.getFirst(xmlTrustedService.getServiceNames()));
        }
        return result;
    }

    private XmlSubject getSubject(CertificateWrapper certificate) {
        XmlSubject subject = new XmlSubject();
        subject.setCommonName(certificate.getCommonName());
        subject.setPseudonym(certificate.getPseudo());
        subject.setSurname(certificate.getSurname());
        subject.setGivenName(certificate.getGivenName());
        subject.setOrganizationName(certificate.getOrganizationName());
        subject.setOrganizationUnit(certificate.getOrganizationalUnit());
        subject.setEmail(certificate.getEmail());
        subject.setLocality(certificate.getLocality());
        subject.setState(certificate.getState());
        subject.setCountry(certificate.getCountryName());
        return subject;
    }

    private List<String> emptyToNull(List<String> listUrls) {
        if (Utils.isCollectionEmpty(listUrls)) {
            return null;
        }
        return listUrls;
    }

    private void addQualifications(XmlChainItem firstChainItem, CertificateWrapper certificate) {
        firstChainItem.setQualificationAtIssuance(this.detailedReport.getCertificateQualificationAtIssuance(this.certificateId));
        firstChainItem.setQualificationAtValidation(this.detailedReport.getCertificateQualificationAtValidation(this.certificateId));
        Boolean enactedMRA = null;
        List trustedServices = certificate.getTrustedServices();
        for (TrustedServiceWrapper trustedServiceWrapper : trustedServices) {
            if (!trustedServiceWrapper.isEnactedMRA()) continue;
            enactedMRA = true;
            break;
        }
        firstChainItem.setEnactedMRA(enactedMRA);
    }
}

