/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.xmldsig;

import eu.europa.esig.dss.jaxb.XmlDefinerUtils;
import eu.europa.esig.dss.jaxb.exception.XSDValidationException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class XSDAbstractUtils {
    private static final Logger LOG = LoggerFactory.getLogger(XSDAbstractUtils.class);
    private Schema schema;

    public abstract JAXBContext getJAXBContext() throws JAXBException;

    public abstract List<Source> getXSDSources();

    public Schema getSchema() throws SAXException {
        if (this.schema == null) {
            this.schema = XmlDefinerUtils.getInstance().getSchema(this.getXSDSources());
        }
        return this.schema;
    }

    public Schema getSchema(Source ... sources) throws SAXException {
        List<Source> xsdSources = this.getXSDSources();
        if (sources != null) {
            xsdSources.addAll(Arrays.asList(sources));
        }
        return XmlDefinerUtils.getInstance().getSchema(xsdSources);
    }

    public List<String> validateAgainstXSD(Source xmlSource) {
        try {
            this.validate(xmlSource, this.getSchema(), true);
            return Collections.emptyList();
        }
        catch (XSDValidationException e) {
            return e.getAllMessages();
        }
        catch (Exception e) {
            LOG.warn("An exception occurred : {}", (Object)e.getMessage(), (Object)e);
            return Arrays.asList(e.getMessage());
        }
    }

    public List<String> validateAgainstXSD(Source xmlSource, Source ... schemaSources) {
        try {
            this.validate(xmlSource, this.getSchema(schemaSources), true);
            return Collections.emptyList();
        }
        catch (XSDValidationException e) {
            return e.getAllMessages();
        }
        catch (Exception e) {
            LOG.warn("An exception occurred : {}", (Object)e.getMessage(), (Object)e);
            return Arrays.asList(e.getMessage());
        }
    }

    public void validate(Source xmlSource, Schema schema, boolean secureValidation) throws IOException {
        Validator validator = schema.newValidator();
        try {
            if (secureValidation) {
                XmlDefinerUtils.getInstance().configure(validator);
            }
            validator.validate(xmlSource);
        }
        catch (SAXException e) {
            throw new XSDValidationException(Arrays.asList(e.getMessage()));
        }
        finally {
            XmlDefinerUtils.getInstance().postProcess(validator);
        }
    }
}

