/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.EndorsementType;
import eu.europa.esig.dss.enumerations.MaskGenerationFunction;
import eu.europa.esig.dss.enumerations.ObjectIdentifierQualifier;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.ReferenceValidation;
import eu.europa.esig.dss.model.SignaturePolicyStore;
import eu.europa.esig.dss.model.SpDocSpecification;
import eu.europa.esig.dss.model.UserNotice;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.spi.DSSSecurityProvider;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.SignatureCertificateSource;
import eu.europa.esig.dss.spi.x509.CandidatesForSigningCertificate;
import eu.europa.esig.dss.spi.x509.CertificateValidity;
import eu.europa.esig.dss.spi.x509.revocation.crl.OfflineCRLSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OfflineOCSPSource;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CommitmentTypeIndication;
import eu.europa.esig.dss.validation.DefaultAdvancedSignature;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.validation.SignatureDigestReference;
import eu.europa.esig.dss.validation.SignatureIdentifierBuilder;
import eu.europa.esig.dss.validation.SignatureProductionPlace;
import eu.europa.esig.dss.validation.SignerRole;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.EnforcedResolverFragment;
import eu.europa.esig.dss.xades.reference.XAdESReferenceValidation;
import eu.europa.esig.dss.xades.validation.CounterSignatureResolver;
import eu.europa.esig.dss.xades.validation.DetachedSignatureResolver;
import eu.europa.esig.dss.xades.validation.ManifestValidator;
import eu.europa.esig.dss.xades.validation.SignatureRSARIPEMD160AT;
import eu.europa.esig.dss.xades.validation.XAdESBaselineRequirementsChecker;
import eu.europa.esig.dss.xades.validation.XAdESCRLSource;
import eu.europa.esig.dss.xades.validation.XAdESCertificateSource;
import eu.europa.esig.dss.xades.validation.XAdESOCSPSource;
import eu.europa.esig.dss.xades.validation.XAdESSignatureIdentifierBuilder;
import eu.europa.esig.dss.xades.validation.XAdESSignatureIntegrityValidator;
import eu.europa.esig.dss.xades.validation.XAdESSignaturePolicy;
import eu.europa.esig.dss.xades.validation.scope.XAdESSignatureScopeFinder;
import eu.europa.esig.dss.xades.validation.timestamp.XAdESTimestampSource;
import eu.europa.esig.dss.xml.common.definition.DSSNamespace;
import eu.europa.esig.dss.xml.utils.DomUtils;
import eu.europa.esig.dss.xml.utils.SantuarioInitializer;
import eu.europa.esig.dss.xml.utils.XMLCanonicalizer;
import eu.europa.esig.xades.definition.XAdESNamespace;
import eu.europa.esig.xades.definition.XAdESPath;
import eu.europa.esig.xades.definition.xades132.XAdES132Attribute;
import eu.europa.esig.xades.definition.xades132.XAdES132Element;
import eu.europa.esig.xades.definition.xades132.XAdES132Path;
import eu.europa.esig.xades.definition.xades141.XAdES141Element;
import eu.europa.esig.xmldsig.definition.XMLDSigAttribute;
import eu.europa.esig.xmldsig.definition.XMLDSigElement;
import eu.europa.esig.xmldsig.definition.XMLDSigPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.xml.transform.dom.DOMSource;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Manifest;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xml.security.utils.resolver.implementations.ResolverXPointer;
import org.digidoc4j.dss.xades.BDocTmSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESSignature
extends DefaultAdvancedSignature {
    private static final long serialVersionUID = -2639858392612722185L;
    private static final Logger LOG = LoggerFactory.getLogger(XAdESSignature.class);
    private static final String DEFAULT_CANONICALIZATION_METHOD = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private final List<XAdESPath> xadesPathHolders;
    private final Element signatureElement;
    private DSSNamespace xmldSigNamespace;
    private DSSNamespace xadesNamespace;
    private XAdESPath xadesPath;
    private boolean disableXSWProtection = false;
    private transient XMLSignature santuarioSignature;
    private String daIdentifier;
    private transient List<Reference> references;

    public XAdESSignature(Element signatureElement) {
        this(signatureElement, Arrays.asList(new XAdES132Path()));
    }

    public XAdESSignature(Element signatureElement, List<XAdESPath> xadesPathHolders) {
        Objects.requireNonNull(signatureElement, "Signature Element cannot be null");
        this.signatureElement = signatureElement;
        this.xadesPathHolders = xadesPathHolders;
        this.initialiseSettings();
    }

    public void setDisableXSWProtection(boolean disableXSWProtection) {
        this.disableXSWProtection = disableXSWProtection;
    }

    private void initialiseSettings() {
        this.recursiveNamespaceBrowser(this.signatureElement);
        if (this.xadesPath == null) {
            LOG.warn("There is no suitable XAdESPaths / XAdESNamespace to manage the signature. The default ones will be used.");
            this.xadesPath = new XAdES132Path();
            this.xadesNamespace = XAdESNamespace.XADES_132;
        }
    }

    public void recursiveNamespaceBrowser(Element element) {
        for (int ii = 0; ii < element.getChildNodes().getLength(); ++ii) {
            Node node = element.getChildNodes().item(ii);
            if (node.getNodeType() != 1) continue;
            String prefix = node.getPrefix();
            Element childElement = (Element)node;
            String namespaceURI = childElement.getNamespaceURI();
            String localName = childElement.getLocalName();
            if (XMLDSigElement.TRANSFORM.isSameTagName(localName) && XMLDSigElement.TRANSFORM.getURI().equals(namespaceURI)) {
                this.xmldSigNamespace = new DSSNamespace(namespaceURI, prefix);
                continue;
            }
            if (XAdES132Element.QUALIFYING_PROPERTIES.isSameTagName(localName)) {
                this.setXAdESPathAndNamespace(prefix, namespaceURI);
                return;
            }
            this.recursiveNamespaceBrowser(childElement);
        }
    }

    private void setXAdESPathAndNamespace(String prefix, String namespaceURI) {
        for (XAdESPath currentXAdESPaths : this.xadesPathHolders) {
            if (!currentXAdESPaths.getNamespace().isSameUri(namespaceURI)) continue;
            this.xadesPath = currentXAdESPaths;
            this.xadesNamespace = new DSSNamespace(namespaceURI, prefix);
        }
    }

    public List<XAdESPath> getXAdESPathsHolders() {
        return this.xadesPathHolders;
    }

    public XAdESPath getXAdESPaths() {
        return this.xadesPath;
    }

    public DSSNamespace getXmldSigNamespace() {
        return this.xmldSigNamespace;
    }

    public DSSNamespace getXadesNamespace() {
        return this.xadesNamespace;
    }

    public Element getSignatureElement() {
        return this.signatureElement;
    }

    public SignatureForm getSignatureForm() {
        return SignatureForm.XAdES;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        SignatureAlgorithm signatureAlgorithm = this.getSignatureAlgorithm();
        if (signatureAlgorithm == null) {
            return null;
        }
        return signatureAlgorithm.getEncryptionAlgorithm();
    }

    public DigestAlgorithm getDigestAlgorithm() {
        SignatureAlgorithm signatureAlgorithm = this.getSignatureAlgorithm();
        if (signatureAlgorithm == null) {
            return null;
        }
        return signatureAlgorithm.getDigestAlgorithm();
    }

    public MaskGenerationFunction getMaskGenerationFunction() {
        SignatureAlgorithm signatureAlgorithm = this.getSignatureAlgorithm();
        if (signatureAlgorithm == null) {
            return null;
        }
        return signatureAlgorithm.getMaskGenerationFunction();
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        String xmlName = DomUtils.getElement((Node)this.signatureElement, (String)XMLDSigPath.SIGNATURE_METHOD_PATH).getAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName());
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.forXML((String)xmlName, null);
        if (signatureAlgorithm == null) {
            LOG.error("SignatureAlgorithm '{}' is not supported!", (Object)xmlName);
        }
        return signatureAlgorithm;
    }

    public SignatureCertificateSource getCertificateSource() {
        if (this.offlineCertificateSource == null) {
            this.offlineCertificateSource = new XAdESCertificateSource(this.signatureElement, this.xadesPath);
        }
        return this.offlineCertificateSource;
    }

    public OfflineCRLSource getCRLSource() {
        if (this.signatureCRLSource == null) {
            this.signatureCRLSource = new XAdESCRLSource(this.signatureElement, this.xadesPath);
        }
        return this.signatureCRLSource;
    }

    public OfflineOCSPSource getOCSPSource() {
        if (this.signatureOCSPSource == null) {
            this.signatureOCSPSource = new XAdESOCSPSource(this.signatureElement, this.xadesPath);
        }
        return this.signatureOCSPSource;
    }

    public XAdESTimestampSource getTimestampSource() {
        if (this.signatureTimestampSource == null) {
            this.signatureTimestampSource = new XAdESTimestampSource(this);
        }
        return (XAdESTimestampSource)this.signatureTimestampSource;
    }

    public Date getSigningTime() {
        Element signingTimeEl = DomUtils.getElement((Node)this.signatureElement, (String)this.xadesPath.getSigningTimePath());
        if (signingTimeEl == null) {
            return null;
        }
        String text = signingTimeEl.getTextContent();
        return DomUtils.getDate((String)text);
    }

    public XAdESSignaturePolicy getSignaturePolicy() {
        return (XAdESSignaturePolicy)super.getSignaturePolicy();
    }

    protected XAdESSignaturePolicy buildSignaturePolicy() {
        XAdESSignaturePolicy xadesSignaturePolicy = null;
        Element policyIdentifier = DomUtils.getElement((Node)this.signatureElement, (String)this.xadesPath.getSignaturePolicyIdentifierPath());
        if (policyIdentifier != null) {
            Element policyId = DomUtils.getElement((Node)policyIdentifier, (String)this.xadesPath.getCurrentSignaturePolicyId());
            if (policyId != null) {
                Element transformsNode;
                Element docRefsNode;
                Element policyDescription;
                Element spDocSpecification;
                String currentSignaturePolicySPDocSpecificationPath;
                String policyUrlString = null;
                String policyIdString = policyId.getTextContent();
                if (Utils.isStringNotBlank((String)policyIdString) && !DSSUtils.isUrnOid((String)policyIdString) && !DSSUtils.isOidCode((String)policyIdString)) {
                    policyUrlString = policyIdString;
                }
                ObjectIdentifierQualifier qualifier = null;
                String qualifierString = policyId.getAttribute(XAdES132Attribute.QUALIFIER.getAttributeName());
                if (Utils.isStringNotBlank((String)qualifierString)) {
                    qualifier = ObjectIdentifierQualifier.fromValue((String)qualifierString);
                }
                policyIdString = DSSUtils.getObjectIdentifierValue((String)policyIdString, (ObjectIdentifierQualifier)qualifier);
                xadesSignaturePolicy = new XAdESSignaturePolicy(policyIdString);
                Digest digest = DSSXMLUtils.getDigestAndValue(DomUtils.getElement((Node)policyIdentifier, (String)this.xadesPath.getCurrentSignaturePolicyDigestAlgAndValue()));
                xadesSignaturePolicy.setDigest(digest);
                Element policyUrl = DomUtils.getElement((Node)policyIdentifier, (String)this.xadesPath.getCurrentSignaturePolicySPURI());
                if (policyUrl != null) {
                    policyUrlString = policyUrl.getTextContent();
                    policyUrlString = Utils.trim((String)policyUrlString);
                }
                xadesSignaturePolicy.setUri(policyUrlString);
                Element spUserNotice = DomUtils.getElement((Node)policyIdentifier, (String)this.xadesPath.getCurrentSignaturePolicySPUserNotice());
                if (spUserNotice != null) {
                    xadesSignaturePolicy.setUserNotice(this.buildSPUserNotice(spUserNotice));
                }
                if (Utils.isStringNotEmpty((String)(currentSignaturePolicySPDocSpecificationPath = this.xadesPath.getCurrentSignaturePolicySPDocSpecification())) && (spDocSpecification = DomUtils.getElement((Node)policyIdentifier, (String)currentSignaturePolicySPDocSpecificationPath)) != null) {
                    xadesSignaturePolicy.setDocSpecification(this.buildSpDocSpecification(spDocSpecification));
                }
                if ((policyDescription = DomUtils.getElement((Node)policyIdentifier, (String)this.xadesPath.getCurrentSignaturePolicyDescription())) != null && Utils.isStringNotEmpty((String)policyDescription.getTextContent())) {
                    xadesSignaturePolicy.setDescription(policyDescription.getTextContent());
                }
                if ((docRefsNode = DomUtils.getElement((Node)policyIdentifier, (String)this.xadesPath.getCurrentSignaturePolicyDocumentationReferences())) != null) {
                    xadesSignaturePolicy.setDocumentationReferences(this.getDocumentationReferences(docRefsNode));
                }
                if ((transformsNode = DomUtils.getElement((Node)policyIdentifier, (String)this.xadesPath.getCurrentSignaturePolicyTransforms())) != null) {
                    xadesSignaturePolicy.setTransforms(transformsNode);
                    xadesSignaturePolicy.setHashAsInTechnicalSpecification(this.isHashComputationAsInPolicySpecification(transformsNode));
                }
            } else {
                Element signaturePolicyImplied = DomUtils.getElement((Node)policyIdentifier, (String)this.xadesPath.getCurrentSignaturePolicyImplied());
                if (signaturePolicyImplied != null) {
                    xadesSignaturePolicy = new XAdESSignaturePolicy();
                }
            }
        }
        return xadesSignaturePolicy;
    }

    private UserNotice buildSPUserNotice(Element spUserNoticeElement) {
        try {
            Element explicitText;
            Element noticeNumbers;
            UserNotice userNotice = new UserNotice();
            Element organization = DomUtils.getElement((Node)spUserNoticeElement, (String)this.xadesPath.getCurrentSPUserNoticeNoticeRefOrganization());
            if (organization != null) {
                userNotice.setOrganization(organization.getTextContent());
            }
            if ((noticeNumbers = DomUtils.getElement((Node)spUserNoticeElement, (String)this.xadesPath.getCurrentSPUserNoticeNoticeRefNoticeNumbers())) != null && noticeNumbers.hasChildNodes()) {
                ArrayList<Integer> noticeNumbersList = new ArrayList<Integer>();
                NodeList childNodes = noticeNumbers.getChildNodes();
                for (int ii = 0; ii < childNodes.getLength(); ++ii) {
                    Node child = childNodes.item(ii);
                    if (1 != child.getNodeType() || !XAdES132Element.INT.isSameTagName(child.getLocalName())) continue;
                    noticeNumbersList.add(Integer.valueOf(child.getTextContent()));
                }
                userNotice.setNoticeNumbers(noticeNumbersList.stream().mapToInt(i -> i).toArray());
            }
            if ((explicitText = DomUtils.getElement((Node)spUserNoticeElement, (String)this.xadesPath.getCurrentSPUserNoticeExplicitText())) != null) {
                userNotice.setExplicitText(explicitText.getTextContent());
            }
            return userNotice;
        }
        catch (Exception e) {
            LOG.error("Unable to build SPUserNotice qualifier. Reason : {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private boolean isHashComputationAsInPolicySpecification(Element transforms) {
        Node transform;
        String algorithm;
        NodeList transformList;
        return transforms != null && transforms.hasChildNodes() && (transformList = DomUtils.getNodeList((Node)transforms, (String)XMLDSigPath.TRANSFORM_PATH)).getLength() == 1 && "http://uri.etsi.org/01903/v1.3.2/SignaturePolicy/SPDocDigestAsInSpecification".equals(algorithm = DomUtils.getValue((Node)(transform = transformList.item(0)), (String)"@Algorithm"));
    }

    public SignatureProductionPlace getSignatureProductionPlace() {
        String signatureProductionPlaceV2Path;
        NodeList nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)this.xadesPath.getSignatureProductionPlacePath());
        if ((nodeList.getLength() == 0 || nodeList.item(0) == null) && (signatureProductionPlaceV2Path = this.xadesPath.getSignatureProductionPlaceV2Path()) != null) {
            nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)signatureProductionPlaceV2Path);
        }
        if (nodeList.getLength() == 0 || nodeList.item(0) == null) {
            return null;
        }
        SignatureProductionPlace signatureProductionPlace = new SignatureProductionPlace();
        NodeList list = nodeList.item(0).getChildNodes();
        for (int ii = 0; ii < list.getLength(); ++ii) {
            Node item = list.item(ii);
            String name = item.getLocalName();
            String nodeValue = item.getTextContent();
            if (XAdES132Element.CITY.isSameTagName(name)) {
                signatureProductionPlace.setCity(nodeValue);
                continue;
            }
            if (XAdES132Element.STATE_OR_PROVINCE.isSameTagName(name)) {
                signatureProductionPlace.setStateOrProvince(nodeValue);
                continue;
            }
            if (XAdES132Element.POSTAL_CODE.isSameTagName(name)) {
                signatureProductionPlace.setPostalCode(nodeValue);
                continue;
            }
            if (XAdES132Element.COUNTRY_NAME.isSameTagName(name)) {
                signatureProductionPlace.setCountryName(nodeValue);
                continue;
            }
            if (!XAdES132Element.STREET_ADDRESS.isSameTagName(name)) continue;
            signatureProductionPlace.setStreetAddress(nodeValue);
        }
        return signatureProductionPlace;
    }

    public SignaturePolicyStore getSignaturePolicyStore() {
        NodeList nodeList;
        String signaturePolicyStorePath = this.xadesPath.getSignaturePolicyStorePath();
        if (Utils.isStringNotEmpty((String)signaturePolicyStorePath) && (nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)signaturePolicyStorePath)).getLength() > 0) {
            String sigPolDocLocalURI;
            String currentSigPolDocLocalURI;
            String spDocB64;
            Element spDocSpecificationElement;
            SignaturePolicyStore sps = new SignaturePolicyStore();
            Element signaturePolicyStoreElement = (Element)nodeList.item(0);
            String id = signaturePolicyStoreElement.getAttribute(XMLDSigAttribute.ID.getAttributeName());
            if (Utils.isStringNotEmpty((String)id)) {
                sps.setId(id);
            }
            SpDocSpecification spDocSpec = null;
            String currentSPDocSpecificationPath = this.xadesPath.getCurrentSPDocSpecification();
            if (Utils.isStringNotEmpty((String)currentSPDocSpecificationPath) && (spDocSpecificationElement = DomUtils.getElement((Node)signaturePolicyStoreElement, (String)currentSPDocSpecificationPath)) != null) {
                spDocSpec = this.buildSpDocSpecification(spDocSpecificationElement);
            }
            sps.setSpDocSpecification(spDocSpec);
            String currentSignaturePolicyDocumentPath = this.xadesPath.getCurrentSignaturePolicyDocument();
            if (Utils.isStringNotEmpty((String)currentSignaturePolicyDocumentPath) && Utils.isStringNotEmpty((String)(spDocB64 = DomUtils.getValue((Node)signaturePolicyStoreElement, (String)currentSignaturePolicyDocumentPath))) && Utils.isBase64Encoded((String)spDocB64)) {
                sps.setSignaturePolicyContent((DSSDocument)new InMemoryDocument(Utils.fromBase64((String)spDocB64)));
            }
            if (Utils.isStringNotEmpty((String)(currentSigPolDocLocalURI = this.xadesPath.getCurrentSigPolDocLocalURI())) && Utils.isStringNotEmpty((String)(sigPolDocLocalURI = DomUtils.getValue((Node)signaturePolicyStoreElement, (String)currentSigPolDocLocalURI)))) {
                sps.setSigPolDocLocalURI(sigPolDocLocalURI);
            }
            return sps;
        }
        return null;
    }

    private SpDocSpecification buildSpDocSpecification(Element spDocSpecificationElement) {
        String currentDocumentationReferenceElementsPath;
        String description;
        SpDocSpecification spDocSpec = new SpDocSpecification();
        Element identifierElement = DomUtils.getElement((Node)spDocSpecificationElement, (String)this.xadesPath.getCurrentIdentifier());
        if (identifierElement != null) {
            String spDocSpecId = identifierElement.getTextContent();
            ObjectIdentifierQualifier qualifier = null;
            String qualifierString = identifierElement.getAttribute(XAdES132Attribute.QUALIFIER.getAttributeName());
            if (Utils.isStringNotBlank((String)qualifierString)) {
                qualifier = ObjectIdentifierQualifier.fromValue((String)qualifierString);
                spDocSpec.setQualifier(qualifier);
            }
            spDocSpec.setId(DSSUtils.getObjectIdentifierValue((String)spDocSpecId, (ObjectIdentifierQualifier)qualifier));
        }
        if (Utils.isStringNotBlank((String)(description = DomUtils.getValue((Node)spDocSpecificationElement, (String)this.xadesPath.getCurrentDescription())))) {
            spDocSpec.setDescription(description);
        }
        if (Utils.isStringNotEmpty((String)(currentDocumentationReferenceElementsPath = this.xadesPath.getCurrentDocumentationReferenceElements()))) {
            String[] documentationReferences = null;
            NodeList documentReferenceList = DomUtils.getNodeList((Node)spDocSpecificationElement, (String)currentDocumentationReferenceElementsPath);
            if (documentReferenceList != null && documentReferenceList.getLength() > 0) {
                documentationReferences = new String[documentReferenceList.getLength()];
                for (int i = 0; i < documentReferenceList.getLength(); ++i) {
                    documentationReferences[i] = documentReferenceList.item(i).getTextContent();
                }
            }
            spDocSpec.setDocumentationReferences(documentationReferences);
        }
        return spDocSpec;
    }

    public List<SignerRole> getSignedAssertions() {
        ArrayList<SignerRole> result = new ArrayList<SignerRole>();
        String signedAssertionPath = this.xadesPath.getSignedAssertionPath();
        if (signedAssertionPath != null) {
            NodeList nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)signedAssertionPath);
            for (int ii = 0; ii < nodeList.getLength(); ++ii) {
                result.add(new SignerRole(DomUtils.xmlToString((Node)nodeList.item(ii).getFirstChild()), EndorsementType.SIGNED));
            }
        }
        return result;
    }

    public List<SignerRole> getClaimedSignerRoles() {
        String claimedRoleV2Path;
        NodeList nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)this.xadesPath.getClaimedRolePath());
        if (nodeList.getLength() == 0 && (claimedRoleV2Path = this.xadesPath.getClaimedRoleV2Path()) != null && (nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)claimedRoleV2Path)).getLength() == 0) {
            return Collections.emptyList();
        }
        ArrayList<SignerRole> claimedRoles = new ArrayList<SignerRole>();
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            claimedRoles.add(new SignerRole(nodeList.item(ii).getTextContent(), EndorsementType.CLAIMED));
        }
        return claimedRoles;
    }

    public List<SignerRole> getCertifiedSignerRoles() {
        String certifiedRoleV2Path;
        NodeList nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)this.xadesPath.getCertifiedRolePath());
        if (nodeList.getLength() == 0 && (certifiedRoleV2Path = this.xadesPath.getCertifiedRoleV2Path()) != null && (nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)certifiedRoleV2Path)).getLength() == 0) {
            return Collections.emptyList();
        }
        ArrayList<SignerRole> certifiedRoles = new ArrayList<SignerRole>();
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            Element certEl = (Element)nodeList.item(ii);
            String textContent = certEl.getTextContent();
            certifiedRoles.add(new SignerRole(textContent, EndorsementType.CERTIFIED));
        }
        return certifiedRoles;
    }

    public String getContentType() {
        String contentType = null;
        NodeList allContentTypes = DomUtils.getNodeList((Node)this.signatureElement, (String)this.xadesPath.getDataObjectFormatObjectIdentifier());
        if (allContentTypes != null && allContentTypes.getLength() > 0) {
            for (int i = 0; i < allContentTypes.getLength(); ++i) {
                Node node = allContentTypes.item(i);
                if (!(node instanceof Element)) continue;
                Element element = (Element)node;
                contentType = element.getTextContent();
                break;
            }
        }
        return contentType;
    }

    public String getMimeType() {
        String mimeType = null;
        NodeList allMimeTypes = DomUtils.getNodeList((Node)this.signatureElement, (String)this.xadesPath.getDataObjectFormatMimeType());
        if (allMimeTypes != null && allMimeTypes.getLength() > 0) {
            for (int i = 0; i < allMimeTypes.getLength(); ++i) {
                Node node = allMimeTypes.item(i);
                if (!(node instanceof Element)) continue;
                Element element = (Element)node;
                mimeType = element.getTextContent();
                break;
            }
        }
        return mimeType;
    }

    public String getSignatureValueBase64() {
        Element signatureValueElement = DomUtils.getElement((Node)this.signatureElement, (String)XMLDSigPath.SIGNATURE_VALUE_PATH);
        if (signatureValueElement != null) {
            return signatureValueElement.getTextContent();
        }
        return null;
    }

    public byte[] getSignatureValue() {
        String signatureValueBase64 = this.getSignatureValueBase64();
        if (signatureValueBase64 != null && Utils.isBase64Encoded((String)signatureValueBase64)) {
            return Utils.fromBase64((String)signatureValueBase64);
        }
        if (LOG.isDebugEnabled()) {
            LOG.warn("The signature value is not represented by a base64-encoded string! Found value : '{}'", (Object)signatureValueBase64);
        } else {
            LOG.warn("The signature value is not represented by a base64-encoded string!");
        }
        return null;
    }

    public String getSignatureValueId() {
        return DomUtils.getValue((Node)this.signatureElement, (String)XMLDSigPath.SIGNATURE_VALUE_ID_PATH);
    }

    public NodeList getObjects() {
        return DomUtils.getNodeList((Node)this.signatureElement, (String)XMLDSigPath.OBJECT_PATH);
    }

    public Element getCompleteCertificateRefs() {
        Element element = null;
        String completeCertificateRefsPath = this.xadesPath.getCompleteCertificateRefsPath();
        if (Utils.isStringNotEmpty((String)completeCertificateRefsPath)) {
            element = DomUtils.getElement((Node)this.signatureElement, (String)completeCertificateRefsPath);
        }
        String completeCertificateRefsV2Path = this.xadesPath.getCompleteCertificateRefsV2Path();
        if (element == null && Utils.isStringNotEmpty((String)completeCertificateRefsV2Path)) {
            element = DomUtils.getElement((Node)this.signatureElement, (String)completeCertificateRefsV2Path);
        }
        return element;
    }

    public Element getCompleteRevocationRefs() {
        return DomUtils.getElement((Node)this.signatureElement, (String)this.xadesPath.getCompleteRevocationRefsPath());
    }

    public NodeList getSigAndRefsTimeStamp() {
        NodeList nodeList = null;
        String sigAndRefsTimestampPath = this.xadesPath.getSigAndRefsTimestampPath();
        if (Utils.isStringNotEmpty((String)sigAndRefsTimestampPath)) {
            nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)sigAndRefsTimestampPath);
        }
        String sigAndRefsTimestampV2Path = this.xadesPath.getSigAndRefsTimestampV2Path();
        if ((nodeList == null || nodeList.getLength() == 0) && Utils.isStringNotEmpty((String)sigAndRefsTimestampV2Path)) {
            nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)sigAndRefsTimestampV2Path);
        }
        return nodeList;
    }

    public NodeList getRefsOnlyTimestampTimeStamp() {
        NodeList nodeList = null;
        String refsOnlyTimestampPath = this.xadesPath.getRefsOnlyTimestampPath();
        if (Utils.isStringNotEmpty((String)refsOnlyTimestampPath)) {
            nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)refsOnlyTimestampPath);
        }
        String refsOnlyTimestampV2Path = this.xadesPath.getRefsOnlyTimestampV2Path();
        if ((nodeList == null || nodeList.getLength() == 0) && Utils.isStringNotEmpty((String)refsOnlyTimestampV2Path)) {
            nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)refsOnlyTimestampV2Path);
        }
        return nodeList;
    }

    public Element getCertificateValues() {
        return DomUtils.getElement((Node)this.signatureElement, (String)this.xadesPath.getCertificateValuesPath());
    }

    public Element getRevocationValues() {
        return DomUtils.getElement((Node)this.signatureElement, (String)this.xadesPath.getRevocationValuesPath());
    }

    public void addExternalTimestamp(TimestampToken timestamp) {
        throw new UnsupportedOperationException("The action is not supported for XAdES!");
    }

    protected XAdESBaselineRequirementsChecker getBaselineRequirementsChecker() {
        return (XAdESBaselineRequirementsChecker)super.getBaselineRequirementsChecker();
    }

    protected XAdESBaselineRequirementsChecker createBaselineRequirementsChecker() {
        return new XAdESBaselineRequirementsChecker(this, this.offlineCertificateVerifier);
    }

    public boolean hasTProfile() {
        if (BDocTmSupport.hasBDocTmOcsp(this.signatureElement, this.xadesPath)) {
            return true;
        }
        return super.hasTProfile();
    }

    public boolean hasBESProfile() {
        return this.getBaselineRequirementsChecker().hasExtendedBESProfile();
    }

    public boolean hasEPESProfile() {
        return this.getBaselineRequirementsChecker().hasExtendedEPESProfile();
    }

    public boolean hasExtendedTProfile() {
        return this.getBaselineRequirementsChecker().hasExtendedTProfile();
    }

    public boolean hasCProfile() {
        return this.getBaselineRequirementsChecker().hasExtendedCProfile();
    }

    public boolean hasXProfile() {
        return this.getBaselineRequirementsChecker().hasExtendedXProfile();
    }

    public boolean hasXLProfile() {
        return this.getBaselineRequirementsChecker().hasExtendedXLProfile();
    }

    public boolean hasAProfile() {
        return this.getBaselineRequirementsChecker().hasExtendedAProfile();
    }

    public void checkSignatureIntegrity() {
        if (this.signatureCryptographicVerification != null) {
            return;
        }
        this.signatureCryptographicVerification = new SignatureCryptographicVerification();
        try {
            XMLSignature currentSantuarioSignature = this.getSantuarioSignature();
            CandidatesForSigningCertificate candidatesForSigningCertificate = this.getCandidatesForSigningCertificate();
            XAdESSignatureIntegrityValidator signingCertificateValidator = new XAdESSignatureIntegrityValidator(currentSantuarioSignature);
            CertificateValidity certificateValidity = signingCertificateValidator.validate(candidatesForSigningCertificate);
            if (certificateValidity != null) {
                candidatesForSigningCertificate.setTheCertificateValidity(certificateValidity);
            }
            List errorMessages = signingCertificateValidator.getErrorMessages();
            this.signatureCryptographicVerification.setErrorMessages(errorMessages);
            boolean allReferenceDataFound = true;
            boolean allReferenceDataIntact = true;
            List<ReferenceValidation> refValidations = this.getReferenceValidations();
            for (ReferenceValidation referenceValidation : refValidations) {
                allReferenceDataFound = allReferenceDataFound && referenceValidation.isFound();
                allReferenceDataIntact = allReferenceDataIntact && referenceValidation.isIntact();
            }
            this.signatureCryptographicVerification.setReferenceDataFound(allReferenceDataFound);
            this.signatureCryptographicVerification.setReferenceDataIntact(allReferenceDataIntact);
            this.signatureCryptographicVerification.setSignatureIntact(certificateValidity != null);
        }
        catch (Exception e) {
            LOG.error("checkSignatureIntegrity : {}", (Object)e.getMessage());
            LOG.debug("checkSignatureIntegrity : {}", (Object)e.getMessage(), (Object)e);
            StackTraceElement[] stackTrace = e.getStackTrace();
            String name = XAdESSignature.class.getName();
            int lineNumber = 0;
            for (StackTraceElement element : stackTrace) {
                String className = element.getClassName();
                if (!className.equals(name)) continue;
                lineNumber = element.getLineNumber();
                break;
            }
            this.signatureCryptographicVerification.setErrorMessage(e.getMessage() + "/ XAdESSignature/Line number/" + lineNumber);
        }
    }

    public List<ReferenceValidation> getReferenceValidations() {
        if (this.referenceValidations == null) {
            this.referenceValidations = new ArrayList();
            XMLSignature currentSantuarioSignature = this.getSantuarioSignature();
            boolean atLeastOneReferenceElementFound = false;
            List<Reference> santuarioReferences = this.getReferences();
            for (Reference reference : santuarioReferences) {
                XAdESReferenceValidation validation = new XAdESReferenceValidation(reference);
                validation.setType(DigestMatcherType.REFERENCE);
                this.referenceValidations.add(validation);
                boolean found = false;
                boolean intact = false;
                try {
                    Digest digest = DSSXMLUtils.getReferenceDigest(reference);
                    validation.setDigest(digest);
                    found = DSSXMLUtils.isAbleToDeReferenceContent(reference);
                    String uri = validation.getUri();
                    boolean isDuplicated = DSSXMLUtils.isReferencedContentAmbiguous(this.signatureElement.getOwnerDocument(), uri);
                    validation.setDuplicated(isDuplicated);
                    boolean isElementReference = DomUtils.isElementReference((String)uri);
                    if (isElementReference && DSSXMLUtils.isSignedProperties(reference, this.xadesPath)) {
                        validation.setType(DigestMatcherType.SIGNED_PROPERTIES);
                        found = found && (this.disableXSWProtection || this.findSignedPropertiesById(uri));
                    } else if (DomUtils.isXPointerQuery((String)uri)) {
                        validation.setType(DigestMatcherType.XPOINTER);
                    } else if (DSSXMLUtils.isCounterSignature(reference, this.xadesPath)) {
                        validation.setType(DigestMatcherType.COUNTER_SIGNATURE);
                        XAdESSignature masterSignature = (XAdESSignature)this.getMasterSignature();
                        if (masterSignature != null) {
                            this.referenceValidations.add(this.getCounterSignatureReferenceValidation(reference, masterSignature));
                        } else {
                            LOG.warn("Master signature is not found! Unable to verify counter signed SignatureValue for detached signatures.");
                        }
                    } else if (isElementReference && DSSXMLUtils.isKeyInfoReference(reference, currentSantuarioSignature.getElement())) {
                        validation.setType(DigestMatcherType.KEY_INFO);
                        found = true;
                    } else if (isElementReference && DSSXMLUtils.isSignaturePropertiesReference(reference, currentSantuarioSignature.getElement())) {
                        validation.setType(DigestMatcherType.SIGNATURE_PROPERTIES);
                        found = true;
                    } else if (isElementReference && reference.typeIsReferenceToObject()) {
                        validation.setType(DigestMatcherType.OBJECT);
                        found = found && (this.disableXSWProtection || this.findObjectById(uri));
                    } else if (isElementReference && reference.typeIsReferenceToManifest()) {
                        validation.setType(DigestMatcherType.MANIFEST);
                        Element manifestElement = DSSXMLUtils.getManifestById(this.signatureElement, uri);
                        boolean bl = found = found && (this.disableXSWProtection || manifestElement != null);
                        if (manifestElement != null) {
                            validation.getDependentValidations().addAll(this.getManifestReferences(manifestElement));
                        }
                    }
                    if (found && !isDuplicated) {
                        intact = reference.verify();
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Reference validation output: ");
                        LOG.trace(new String(reference.getReferencedBytes()));
                    }
                }
                catch (Exception e) {
                    LOG.warn("Unable to verify reference with Id [{}] : {}", new Object[]{reference.getId(), e.getMessage(), e});
                }
                if (DigestMatcherType.REFERENCE.equals((Object)validation.getType()) || DigestMatcherType.OBJECT.equals((Object)validation.getType()) || DigestMatcherType.MANIFEST.equals((Object)validation.getType()) || DigestMatcherType.XPOINTER.equals((Object)validation.getType()) || DigestMatcherType.COUNTER_SIGNATURE.equals((Object)validation.getType())) {
                    atLeastOneReferenceElementFound = true;
                }
                validation.setFound(found);
                validation.setIntact(intact);
            }
            if (!atLeastOneReferenceElementFound) {
                this.referenceValidations.add(this.notFound(DigestMatcherType.REFERENCE));
            }
            if (this.referenceValidations.size() < santuarioReferences.size()) {
                LOG.warn("Not all references were validated!");
            }
        }
        return this.referenceValidations;
    }

    private ReferenceValidation getCounterSignatureReferenceValidation(Reference counterSignatureReference, XAdESSignature masterSignature) {
        ReferenceValidation referenceValidation;
        block6: {
            referenceValidation = new ReferenceValidation();
            referenceValidation.setType(DigestMatcherType.COUNTER_SIGNED_SIGNATURE_VALUE);
            String masterSignatureValueBase64 = masterSignature.getSignatureValueBase64();
            if (Utils.isStringNotEmpty((String)masterSignatureValueBase64)) {
                referenceValidation.setFound(true);
                try {
                    byte[] referencedBytes = counterSignatureReference.getContentsAfterTransformation().getBytes();
                    Document document = DomUtils.buildDOM((byte[])referencedBytes);
                    Element referencedElement = document.getDocumentElement();
                    if (XMLDSigElement.SIGNATURE_VALUE.isSameTagName(referencedElement.getLocalName())) {
                        String referencedSignatureValueBase64 = referencedElement.getTextContent();
                        boolean intact = Utils.areStringsEqual((String)masterSignatureValueBase64, (String)referencedSignatureValueBase64);
                        if (!intact) {
                            LOG.warn("The referenced counter signed value does not match the master signature's ds:SignatureValue content!");
                        }
                        referenceValidation.setIntact(intact);
                        break block6;
                    }
                    LOG.warn("The counter signature reference does not result to a ds:SignatureValue element!");
                }
                catch (Exception e) {
                    LOG.warn("Unable to verify the counter signed reference! Reason : {}", (Object)e.getMessage(), (Object)e);
                }
            } else {
                LOG.warn("Master signature's ds:SignatureValue element does not contain data!");
            }
        }
        return referenceValidation;
    }

    public SignatureDigestReference getSignatureDigestReference(DigestAlgorithm digestAlgorithm) {
        byte[] signatureElementBytes = XMLCanonicalizer.createInstance((String)DEFAULT_CANONICALIZATION_METHOD).canonicalize((Node)this.signatureElement);
        byte[] digestValue = DSSUtils.digest((DigestAlgorithm)digestAlgorithm, (byte[])signatureElementBytes);
        return new SignatureDigestReference(DEFAULT_CANONICALIZATION_METHOD, new Digest(digestAlgorithm, digestValue));
    }

    public Digest getDataToBeSignedRepresentation() {
        DigestAlgorithm digestAlgorithm = this.getDigestAlgorithm();
        if (digestAlgorithm == null) {
            LOG.warn("DigestAlgorithm is not found! Unable to compute DTBSR.");
            return null;
        }
        Element signedInfo = this.getSignedInfo();
        if (signedInfo == null) {
            LOG.warn("SignedInfo element is not found! Unable to compute DTBSR.");
            return null;
        }
        String canonicalizationMethod = DomUtils.getValue((Node)signedInfo, (String)XMLDSigPath.CANONICALIZATION_ALGORITHM_PATH);
        if (Utils.isStringEmpty((String)canonicalizationMethod)) {
            LOG.warn("Canonicalization method is not present in SignedInfo element! Unable to compute DTBSR.");
            return null;
        }
        byte[] canonicalizedSignedInfo = XMLCanonicalizer.createInstance((String)canonicalizationMethod).canonicalize((Node)signedInfo);
        return new Digest(digestAlgorithm, DSSUtils.digest((DigestAlgorithm)digestAlgorithm, (byte[])canonicalizedSignedInfo));
    }

    public Element getSignedInfo() {
        try {
            return DomUtils.getElement((Node)this.signatureElement, (String)XMLDSigPath.SIGNED_INFO_PATH);
        }
        catch (DSSException e) {
            LOG.warn(String.format("Unable to extract ds:SignedInfo element! Reason : %s.", e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private List<ReferenceValidation> getManifestReferences(Element manifestElement) {
        ManifestValidator mv = new ManifestValidator(manifestElement, (List<DSSDocument>)this.detachedContents);
        return mv.validate();
    }

    private boolean findSignedPropertiesById(String uri) {
        return this.getSignedPropertiesById(uri) != null;
    }

    private Node getSignedPropertiesById(String uri) {
        if (Utils.isStringNotBlank((String)uri)) {
            String signedPropertiesById = this.xadesPath.getSignedPropertiesPath() + DomUtils.getXPathByIdAttribute((String)uri);
            return DomUtils.getNode((Node)this.signatureElement, (String)signedPropertiesById);
        }
        return null;
    }

    private boolean findObjectById(String uri) {
        return this.getObjectById(uri) != null;
    }

    public Node getObjectById(String id) {
        if (Utils.isStringNotBlank((String)id)) {
            String objectById = XMLDSigPath.OBJECT_PATH + DomUtils.getXPathByIdAttribute((String)id);
            return DomUtils.getNode((Node)this.signatureElement, (String)objectById);
        }
        return null;
    }

    public Element getManifestById(String id) {
        if (Utils.isStringNotBlank((String)id)) {
            String manifestById = XMLDSigPath.MANIFEST_PATH + DomUtils.getXPathByIdAttribute((String)id);
            return DomUtils.getElement((Node)this.signatureElement, (String)manifestById);
        }
        return null;
    }

    private ReferenceValidation notFound(DigestMatcherType type) {
        ReferenceValidation validation = new ReferenceValidation();
        validation.setType(type);
        validation.setFound(false);
        return validation;
    }

    private XMLSignature getSantuarioSignature() {
        if (this.santuarioSignature != null) {
            return this.santuarioSignature;
        }
        try {
            Document document = this.signatureElement.getOwnerDocument();
            Element rootElement = document.getDocumentElement();
            DSSXMLUtils.setIDIdentifier(rootElement);
            DSSXMLUtils.recursiveIdBrowse(rootElement);
            this.initDefaultResolvers();
            this.santuarioSignature = new XMLSignature(this.signatureElement, "", false);
            if (Utils.isCollectionNotEmpty((Collection)this.detachedContents)) {
                this.initDetachedSignatureResolvers(this.detachedContents);
                this.initCounterSignatureResolver(this.detachedContents);
            }
            return this.santuarioSignature;
        }
        catch (XMLSecurityException e) {
            throw new DSSException(String.format("Unable to initialize Santuario XMLSignature. Reason : %s", e.getMessage()), (Throwable)e);
        }
    }

    private void initDefaultResolvers() {
        ResourceResolver.register((ResourceResolverSpi)new EnforcedResolverFragment(), (boolean)false);
        ResourceResolver.register((ResourceResolverSpi)new ResolverXPointer(), (boolean)false);
    }

    private void initDetachedSignatureResolvers(List<DSSDocument> detachedContents) {
        Element signedInfo = this.getSignedInfo();
        if (signedInfo != null) {
            XMLSignature santuarioSignature = this.getSantuarioSignature();
            List<DigestAlgorithm> usedReferenceDigestAlgos = DSSXMLUtils.getReferenceDigestAlgos(signedInfo);
            for (DigestAlgorithm digestAlgorithm : usedReferenceDigestAlgos) {
                santuarioSignature.addResourceResolver((ResourceResolverSpi)new DetachedSignatureResolver(detachedContents, digestAlgorithm));
            }
        }
    }

    private void initCounterSignatureResolver(List<DSSDocument> detachedContents) {
        Element signedInfo = this.getSignedInfo();
        if (signedInfo != null) {
            XMLSignature santuarioSignature = this.getSantuarioSignature();
            List<String> types = DSSXMLUtils.getReferenceTypes(signedInfo);
            block0: for (String type : types) {
                if (!this.xadesPath.getCounterSignatureUri().equals(type)) continue;
                for (DSSDocument document : detachedContents) {
                    if (!this.isDetachedSignatureValueDocument(document)) continue;
                    santuarioSignature.addResourceResolver((ResourceResolverSpi)new CounterSignatureResolver(document));
                    continue block0;
                }
            }
        }
    }

    private boolean isDetachedSignatureValueDocument(DSSDocument detachedContents) {
        try {
            Document document;
            if (DomUtils.isDOM((DSSDocument)detachedContents) && (document = DomUtils.buildDOM((DSSDocument)detachedContents)) != null) {
                Node node = document.getChildNodes().item(0);
                return XMLDSigElement.SIGNATURE_VALUE.getTagName().equals(node.getLocalName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public List<AdvancedSignature> getCounterSignatures() {
        if (this.counterSignatures != null) {
            return this.counterSignatures;
        }
        this.counterSignatures = new ArrayList();
        NodeList counterSignaturesElements = DomUtils.getNodeList((Node)this.signatureElement, (String)this.xadesPath.getCounterSignaturePath());
        if (counterSignaturesElements != null && counterSignaturesElements.getLength() > 0) {
            for (int ii = 0; ii < counterSignaturesElements.getLength(); ++ii) {
                XAdESSignature counterSignature = DSSXMLUtils.createCounterSignature((Element)counterSignaturesElements.item(ii), this);
                if (counterSignature == null) continue;
                this.counterSignatures.add(counterSignature);
            }
        }
        return this.counterSignatures;
    }

    protected SignatureIdentifierBuilder getSignatureIdentifierBuilder() {
        return new XAdESSignatureIdentifierBuilder(this);
    }

    public String getDAIdentifier() {
        if (this.daIdentifier == null) {
            this.daIdentifier = DSSXMLUtils.getIDIdentifier(this.signatureElement);
        }
        return this.daIdentifier;
    }

    public List<String> getUnsignedSignatureProperties() {
        return DomUtils.getChildrenNames((Node)this.signatureElement, (String)this.xadesPath.getUnsignedSignaturePropertiesPath());
    }

    public List<String> getSignedSignatureProperties() {
        return DomUtils.getChildrenNames((Node)this.signatureElement, (String)this.xadesPath.getSignedSignaturePropertiesPath());
    }

    public List<String> getSignedProperties() {
        return DomUtils.getChildrenNames((Node)this.signatureElement, (String)this.xadesPath.getSignedPropertiesPath());
    }

    public List<String> getUnsignedProperties() {
        return DomUtils.getChildrenNames((Node)this.signatureElement, (String)this.xadesPath.getUnsignedPropertiesPath());
    }

    public List<String> getSignedDataObjectProperties() {
        return DomUtils.getChildrenNames((Node)this.signatureElement, (String)this.xadesPath.getSignedDataObjectPropertiesPath());
    }

    public SignatureLevel getDataFoundUpToLevel() {
        boolean skipExtendedTProfileCheck;
        if (!this.hasBESProfile()) {
            return SignatureLevel.XML_NOT_ETSI;
        }
        boolean baselineProfile = this.hasBProfile();
        boolean bl = skipExtendedTProfileCheck = baselineProfile && BDocTmSupport.hasBDocTmOcsp(this.signatureElement, this.xadesPath);
        if (!skipExtendedTProfileCheck && !this.hasExtendedTProfile()) {
            if (baselineProfile) {
                return SignatureLevel.XAdES_BASELINE_B;
            }
            if (this.hasEPESProfile()) {
                return SignatureLevel.XAdES_EPES;
            }
            return SignatureLevel.XAdES_BES;
        }
        boolean bl2 = baselineProfile = baselineProfile && this.hasTProfile();
        if (baselineProfile && this.hasLTProfile()) {
            if (this.hasLTAProfile()) {
                return SignatureLevel.XAdES_BASELINE_LTA;
            }
            return SignatureLevel.XAdES_BASELINE_LT;
        }
        if (this.hasCProfile()) {
            if (this.hasXLProfile()) {
                if (this.hasAProfile()) {
                    return SignatureLevel.XAdES_A;
                }
                if (this.hasXProfile()) {
                    return SignatureLevel.XAdES_XL;
                }
            }
            if (this.hasXProfile()) {
                return SignatureLevel.XAdES_X;
            }
            return SignatureLevel.XAdES_C;
        }
        if (this.hasXLProfile()) {
            if (this.hasAProfile()) {
                return SignatureLevel.XAdES_A;
            }
            return SignatureLevel.XAdES_LT;
        }
        return baselineProfile ? SignatureLevel.XAdES_BASELINE_T : SignatureLevel.XAdES_T;
    }

    public List<String> validateStructure() {
        return DSSXMLUtils.validateAgainstXSD(this.xadesPath.getXSDUtils(), new DOMSource(this.signatureElement));
    }

    protected List<SignatureScope> findSignatureScopes() {
        return new XAdESSignatureScopeFinder().findSignatureScope(this);
    }

    public Element getLastTimestampValidationData() {
        Element unsignedSignatureElement;
        String nodeName;
        NodeList nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)(this.xadesPath.getUnsignedSignaturePropertiesPath() + "/*"));
        if (nodeList.getLength() > 0 && XAdES141Element.TIMESTAMP_VALIDATION_DATA.isSameTagName(nodeName = (unsignedSignatureElement = (Element)nodeList.item(nodeList.getLength() - 1)).getLocalName())) {
            return unsignedSignatureElement;
        }
        return null;
    }

    public List<CommitmentTypeIndication> getCommitmentTypeIndications() {
        ArrayList<CommitmentTypeIndication> result = null;
        NodeList nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)this.xadesPath.getCommitmentTypeIndicationPath());
        if (nodeList != null && nodeList.getLength() > 0) {
            result = new ArrayList<CommitmentTypeIndication>();
            for (int ii = 0; ii < nodeList.getLength(); ++ii) {
                Element allSignedDataObjectsNode;
                Element docRefsNode;
                Node commitmentTypeIndicationNode = nodeList.item(ii);
                Element identifier = DomUtils.getElement((Node)commitmentTypeIndicationNode, (String)this.xadesPath.getCurrentCommitmentIdentifierPath());
                String uri = identifier.getTextContent();
                if (uri == null) {
                    LOG.warn("The Identifier for a CommitmentTypeIndication is not defined! The CommitmentType is skipped.");
                    continue;
                }
                ObjectIdentifierQualifier qualifier = null;
                String qualifierString = identifier.getAttribute(XAdES132Attribute.QUALIFIER.getAttributeName());
                if (Utils.isStringNotBlank((String)qualifierString)) {
                    qualifier = ObjectIdentifierQualifier.fromValue((String)qualifierString);
                }
                uri = DSSUtils.getObjectIdentifierValue((String)uri, (ObjectIdentifierQualifier)qualifier);
                CommitmentTypeIndication commitmentTypeIndication = new CommitmentTypeIndication(uri);
                Element descriptionNode = DomUtils.getElement((Node)commitmentTypeIndicationNode, (String)this.xadesPath.getCurrentCommitmentDescriptionPath());
                if (descriptionNode != null) {
                    commitmentTypeIndication.setDescription(descriptionNode.getTextContent());
                }
                if ((docRefsNode = DomUtils.getElement((Node)commitmentTypeIndicationNode, (String)this.xadesPath.getCurrentCommitmentDocumentationReferencesPath())) != null) {
                    commitmentTypeIndication.setDocumentReferences(this.getDocumentationReferences(docRefsNode));
                }
                if ((allSignedDataObjectsNode = DomUtils.getElement((Node)commitmentTypeIndicationNode, (String)this.xadesPath.getCurrentCommitmentAllSignedDataObjectsPath())) != null) {
                    commitmentTypeIndication.setAllDataSignedObjects(true);
                } else {
                    NodeList commitmentObjectReferencesNodeList = DomUtils.getNodeList((Node)commitmentTypeIndicationNode, (String)this.xadesPath.getCurrentCommitmentObjectReferencesPath());
                    if (commitmentObjectReferencesNodeList != null && commitmentObjectReferencesNodeList.getLength() > 0) {
                        commitmentTypeIndication.setObjectReferences(this.getObjectReferences(commitmentObjectReferencesNodeList));
                    }
                }
                result.add(commitmentTypeIndication);
            }
        }
        return result;
    }

    private List<String> getDocumentationReferences(Element docRefsNode) {
        NodeList docRefsChildNodes = DomUtils.getNodeList((Node)docRefsNode, (String)this.xadesPath.getCurrentDocumentationReference());
        if (docRefsChildNodes.getLength() > 0) {
            ArrayList<String> docRefs = new ArrayList<String>();
            for (int jj = 0; jj < docRefsChildNodes.getLength(); ++jj) {
                Node docRefNode = docRefsChildNodes.item(jj);
                docRefs.add(docRefNode.getTextContent());
            }
            return docRefs;
        }
        return null;
    }

    private List<String> getObjectReferences(NodeList commitmentObjectReferencesNodeList) {
        ArrayList<String> signedDataObjects = new ArrayList<String>();
        for (int i = 0; i < commitmentObjectReferencesNodeList.getLength(); ++i) {
            signedDataObjects.add(DomUtils.getId((String)commitmentObjectReferencesNodeList.item(i).getTextContent()));
        }
        return signedDataObjects;
    }

    public List<Reference> getReferences() {
        if (this.references == null) {
            XMLSignature santuarioSignature = this.getSantuarioSignature();
            SignedInfo signedInfo = santuarioSignature.getSignedInfo();
            this.references = DSSXMLUtils.extractReferences((Manifest)signedInfo);
        }
        return this.references;
    }

    public List<Element> getSignatureObjects() {
        NodeList list = DomUtils.getNodeList((Node)this.signatureElement, (String)XMLDSigPath.OBJECT_PATH);
        ArrayList<Element> references = new ArrayList<Element>(list.getLength());
        for (int ii = 0; ii < list.getLength(); ++ii) {
            Node node = list.item(ii);
            Element element = (Element)node;
            if (DomUtils.getElement((Node)element, (String)this.xadesPath.getSignedPropertiesPath()) != null) continue;
            references.add(element);
        }
        return references;
    }

    public void registerXAdESPaths(XAdESPath xadesPaths) {
        this.xadesPathHolders.add(xadesPaths);
    }

    static {
        SantuarioInitializer.init();
        DSSXMLUtils.registerXAdESNamespaces();
        JCEMapper.setProviderId((String)DSSSecurityProvider.getSecurityProviderName());
        JCEMapper.registerDefaultAlgorithms();
        JCEMapper.Algorithm notStandardAlgorithm = new JCEMapper.Algorithm("", SignatureAlgorithm.RSA_RIPEMD160.getJCEId(), "Signature");
        JCEMapper.register((String)"http://www.w3.org/2001/04/xmldsig-more/rsa-ripemd160", (JCEMapper.Algorithm)notStandardAlgorithm);
        try {
            org.apache.xml.security.algorithms.SignatureAlgorithm.register((String)"http://www.w3.org/2001/04/xmldsig-more/rsa-ripemd160", SignatureRSARIPEMD160AT.class);
        }
        catch (Exception e) {
            LOG.error("ECDSA_RIPEMD160AT algorithm initialisation failed.", (Throwable)e);
        }
    }
}

