/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.enumerations.MimeTypeEnum;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.SpDocSpecification;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.signature.SigningOperation;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.reference.DSSReference;
import eu.europa.esig.dss.xml.common.definition.DSSElement;
import eu.europa.esig.dss.xml.common.definition.DSSNamespace;
import eu.europa.esig.dss.xml.utils.DomUtils;
import eu.europa.esig.xades.definition.XAdESElement;
import eu.europa.esig.xades.definition.XAdESNamespace;
import eu.europa.esig.xades.definition.XAdESPath;
import eu.europa.esig.xades.definition.xades111.XAdES111Element;
import eu.europa.esig.xades.definition.xades111.XAdES111Path;
import eu.europa.esig.xades.definition.xades122.XAdES122Element;
import eu.europa.esig.xades.definition.xades122.XAdES122Path;
import eu.europa.esig.xades.definition.xades132.XAdES132Attribute;
import eu.europa.esig.xades.definition.xades132.XAdES132Element;
import eu.europa.esig.xades.definition.xades132.XAdES132Path;
import eu.europa.esig.xades.definition.xades141.XAdES141Element;
import eu.europa.esig.xmldsig.definition.XMLDSigElement;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class XAdESBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESBuilder.class);
    public static final String REFERENCED_DATA = "referencedData";
    public static final String TARGET = "Target";
    public static final String URI = "URI";
    protected XAdESPath xadesPath;
    protected XAdESSignatureParameters params;
    protected Document documentDom;
    protected CertificateVerifier certificateVerifier;

    protected XAdESBuilder() {
    }

    protected XAdESBuilder(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
    }

    protected void incorporateCertDigest(Element parentDom, DigestAlgorithm digestAlgorithm, Token token) {
        Element certDigestDom = DomUtils.addElement((Document)this.documentDom, (Element)parentDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementCertDigest());
        this.incorporateDigestMethod(certDigestDom, digestAlgorithm);
        this.incorporateDigestValue(certDigestDom, digestAlgorithm, token);
    }

    protected void incorporateDigestMethod(Element parentDom, DigestAlgorithm digestAlgorithm) {
        DSSNamespace namespace = this.getDigestAlgAndValueNamespace();
        DSSXMLUtils.incorporateDigestMethod(parentDom, digestAlgorithm, namespace);
    }

    protected void incorporateDigestValue(Element parentDom, DigestAlgorithm digestAlgorithm, Token token) {
        String base64EncodedDigestBytes = Utils.toBase64((byte[])token.getDigest(digestAlgorithm));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Digest value for the token with Id [{}] --> {}", (Object)token.getDSSIdAsString(), (Object)base64EncodedDigestBytes);
        }
        this.incorporateDigestValue(parentDom, base64EncodedDigestBytes);
    }

    protected void incorporateDigestValue(Element parentDom, String base64EncodedDigestBytes) {
        DSSNamespace namespace = this.getDigestAlgAndValueNamespace();
        DSSXMLUtils.incorporateDigestValue(parentDom, base64EncodedDigestBytes, namespace);
    }

    private DSSNamespace getDigestAlgAndValueNamespace() {
        return XAdESNamespace.XADES_111.isSameUri(this.getXadesNamespace().getUri()) ? this.getXadesNamespace() : this.getXmldsigNamespace();
    }

    protected Element incorporateCert(Element parentDom, CertificateToken certificate, DigestAlgorithm digestAlgorithm) {
        Element certDom = DomUtils.addElement((Document)this.documentDom, (Element)parentDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementCert());
        this.incorporateCertDigest(certDom, digestAlgorithm, (Token)certificate);
        if (this.params.isEn319132()) {
            this.incorporateIssuerV2(certDom, certificate);
        } else {
            this.incorporateIssuerV1(certDom, certificate);
        }
        return certDom;
    }

    protected void incorporateIssuerV1(Element parentDom, CertificateToken certificate) {
        Element issuerSerialDom = DomUtils.addElement((Document)this.documentDom, (Element)parentDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementIssuerSerial());
        Element x509IssuerNameDom = DomUtils.addElement((Document)this.documentDom, (Element)issuerSerialDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.X509_ISSUER_NAME);
        String issuerX500PrincipalName = certificate.getIssuerX500Principal().getName();
        DomUtils.setTextNode((Document)this.documentDom, (Element)x509IssuerNameDom, (String)issuerX500PrincipalName);
        Element x509SerialNumberDom = DomUtils.addElement((Document)this.documentDom, (Element)issuerSerialDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.X509_SERIAL_NUMBER);
        BigInteger serialNumber = certificate.getSerialNumber();
        String serialNumberString = serialNumber.toString();
        DomUtils.setTextNode((Document)this.documentDom, (Element)x509SerialNumberDom, (String)serialNumberString);
    }

    protected void incorporateIssuerV2(Element parentDom, CertificateToken certificate) {
        Element issuerSerialDom = DomUtils.addElement((Document)this.documentDom, (Element)parentDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementIssuerSerialV2());
        IssuerSerial issuerSerial = DSSASN1Utils.getIssuerSerial((CertificateToken)certificate);
        String issuerBase64 = Utils.toBase64((byte[])DSSASN1Utils.getDEREncoded((ASN1Encodable)issuerSerial));
        DomUtils.setTextNode((Document)this.documentDom, (Element)issuerSerialDom, (String)issuerBase64);
    }

    private List<String> getNotIndentedObjectIds() {
        ArrayList<String> ids = new ArrayList<String>();
        List<DSSReference> dssReferences = this.params.getReferences();
        if (dssReferences != null) {
            for (DSSReference reference : dssReferences) {
                if (!DSSXMLUtils.isObjectReferenceType(reference.getType())) continue;
                ids.add(DomUtils.getId((String)reference.getUri()));
            }
        }
        return ids;
    }

    protected DSSDocument createXmlDocument() {
        byte[] bytes;
        if (SigningOperation.SIGN.equals((Object)this.params.getContext().getOperationKind()) && this.params.isPrettyPrint()) {
            this.alignNodes();
            bytes = DomUtils.serializeNode((Node)DSSXMLUtils.getDocWithIndentedSignature(this.documentDom, this.params.getDeterministicId(), this.getNotIndentedObjectIds()));
        } else {
            bytes = DomUtils.serializeNode((Node)this.documentDom);
        }
        InMemoryDocument inMemoryDocument = new InMemoryDocument(bytes);
        inMemoryDocument.setMimeType((MimeType)MimeTypeEnum.XML);
        return inMemoryDocument;
    }

    protected abstract void alignNodes();

    protected DSSNamespace getXmldsigNamespace() {
        return this.params.getXmldsigNamespace();
    }

    protected DSSNamespace getXadesNamespace() {
        return this.params.getXadesNamespace();
    }

    protected DSSNamespace getXades141Namespace() {
        return this.params.getXades141Namespace();
    }

    protected XAdESElement getCurrentXAdESElements() {
        String xadesURI = this.getXadesNamespace().getUri();
        if (XAdESNamespace.XADES_132.getUri().equals(xadesURI)) {
            return XAdES132Element.values()[0];
        }
        if (XAdESNamespace.XADES_122.getUri().equals(xadesURI)) {
            return XAdES122Element.values()[0];
        }
        if (XAdESNamespace.XADES_111.getUri().equals(xadesURI)) {
            return XAdES111Element.values()[0];
        }
        throw new IllegalArgumentException("Unsupported URI : " + xadesURI);
    }

    protected XAdESPath getCurrentXAdESPath() {
        String xadesURI = this.getXadesNamespace().getUri();
        if (Utils.areStringsEqual((String)XAdESNamespace.XADES_132.getUri(), (String)xadesURI)) {
            return new XAdES132Path();
        }
        if (Utils.areStringsEqual((String)XAdESNamespace.XADES_122.getUri(), (String)xadesURI)) {
            return new XAdES122Path();
        }
        if (Utils.areStringsEqual((String)XAdESNamespace.XADES_111.getUri(), (String)xadesURI)) {
            return new XAdES111Path();
        }
        throw new IllegalArgumentException("Unsupported URI : " + xadesURI);
    }

    protected void incorporateSPDocSpecification(Element parentElement, SpDocSpecification spDocSpecification) {
        Element spDocSpecElement = DomUtils.addElement((Document)this.documentDom, (Element)parentElement, (DSSNamespace)this.getXades141Namespace(), (DSSElement)XAdES141Element.SP_DOC_SPECIFICATION);
        DomUtils.addNamespaceAttribute((Element)spDocSpecElement, (DSSNamespace)this.getXades141Namespace());
        Element identifierElement = DomUtils.addElement((Document)this.documentDom, (Element)spDocSpecElement, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementIdentifier());
        if (spDocSpecification.getQualifier() != null) {
            identifierElement.setAttribute(XAdES132Attribute.QUALIFIER.getAttributeName(), spDocSpecification.getQualifier().getValue());
        }
        DomUtils.setTextNode((Document)this.documentDom, (Element)identifierElement, (String)spDocSpecification.getId());
        if (Utils.isStringNotEmpty((String)spDocSpecification.getDescription())) {
            Element descriptionElement = DomUtils.addElement((Document)this.documentDom, (Element)spDocSpecElement, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementDescription());
            DomUtils.setTextNode((Document)this.documentDom, (Element)descriptionElement, (String)spDocSpecification.getDescription());
        }
        if (Utils.isArrayNotEmpty((Object[])spDocSpecification.getDocumentationReferences())) {
            Element documentReferencesElement = DomUtils.addElement((Document)this.documentDom, (Element)spDocSpecElement, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementDocumentationReferences());
            for (String docRef : spDocSpecification.getDocumentationReferences()) {
                Element documentReferenceElement = DomUtils.addElement((Document)this.documentDom, (Element)documentReferencesElement, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementDocumentationReference());
                DomUtils.setTextNode((Document)this.documentDom, (Element)documentReferenceElement, (String)docRef);
            }
        }
    }
}

