/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.jaxb.common.XSDAbstractUtils;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.reference.DSSReference;
import eu.europa.esig.dss.xades.reference.DSSTransform;
import eu.europa.esig.dss.xades.reference.DSSTransformOutput;
import eu.europa.esig.dss.xades.reference.ReferenceOutputType;
import eu.europa.esig.dss.xades.signature.PrettyPrintTransformer;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xml.common.definition.AbstractPath;
import eu.europa.esig.dss.xml.common.definition.DSSElement;
import eu.europa.esig.dss.xml.common.definition.DSSNamespace;
import eu.europa.esig.dss.xml.utils.DomUtils;
import eu.europa.esig.dss.xml.utils.SantuarioInitializer;
import eu.europa.esig.dss.xml.utils.XMLCanonicalizer;
import eu.europa.esig.xades.definition.XAdESNamespace;
import eu.europa.esig.xades.definition.XAdESPath;
import eu.europa.esig.xades.definition.xades111.XAdES111Path;
import eu.europa.esig.xades.definition.xades132.XAdES132Element;
import eu.europa.esig.xades.definition.xades132.XAdES132Path;
import eu.europa.esig.xmldsig.definition.XMLDSigAttribute;
import eu.europa.esig.xmldsig.definition.XMLDSigElement;
import eu.europa.esig.xmldsig.definition.XMLDSigNamespace;
import eu.europa.esig.xmldsig.definition.XMLDSigPath;
import java.io.IOException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.Manifest;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.ReferenceNotInitializedException;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class DSSXMLUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DSSXMLUtils.class);
    private static final Set<String> transforms;
    private static final Set<String> transformsWithNodeSetOutput;
    public static final int TRANSFORMER_INDENT_NUMBER = 4;
    private static final String TRANSFORMATION_EXCLUDE_SIGNATURE = "not(ancestor-or-self::ds:Signature)";
    private static final String TRANSFORMATION_XPATH_NODE_NAME = "XPath";
    public static final String SP_DOC_DIGEST_AS_IN_SPECIFICATION_ALGORITHM_URI = "http://uri.etsi.org/01903/v1.3.2/SignaturePolicy/SPDocDigestAsInSpecification";
    public static final DSSNamespace SAML_NAMESPACE;

    private static void registerDefaultTransforms() {
        DSSXMLUtils.registerTransform("http://www.w3.org/2000/09/xmldsig#base64");
        DSSXMLUtils.registerTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        DSSXMLUtils.registerTransform("http://www.w3.org/TR/1999/REC-xpath-19991116");
        DSSXMLUtils.registerTransform("http://www.w3.org/2002/06/xmldsig-filter2");
        DSSXMLUtils.registerTransform("http://www.w3.org/TR/2001/WD-xptr-20010108");
        DSSXMLUtils.registerTransform("http://www.w3.org/TR/1999/REC-xslt-19991116");
    }

    private static void registerTransformsWithNodeSetOutput() {
        DSSXMLUtils.registerTransformWithNodeSetOutput("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        DSSXMLUtils.registerTransformWithNodeSetOutput("http://www.w3.org/TR/1999/REC-xpath-19991116");
        DSSXMLUtils.registerTransformWithNodeSetOutput("http://www.w3.org/2002/06/xmldsig-filter2");
    }

    public static void registerXAdESNamespaces() {
        DomUtils.registerNamespace((DSSNamespace)XMLDSigNamespace.NS);
        DomUtils.registerNamespace((DSSNamespace)XAdESNamespace.XADES_111);
        DomUtils.registerNamespace((DSSNamespace)XAdESNamespace.XADES_122);
        DomUtils.registerNamespace((DSSNamespace)XAdESNamespace.XADES_132);
        DomUtils.registerNamespace((DSSNamespace)XAdESNamespace.XADES_141);
        DomUtils.registerNamespace((DSSNamespace)SAML_NAMESPACE);
    }

    private DSSXMLUtils() {
    }

    public static boolean registerTransform(String transformURI) {
        return transforms.add(transformURI);
    }

    @Deprecated
    public static boolean registerCanonicalizer(String c14nAlgorithmURI) {
        return XMLCanonicalizer.registerCanonicalizer((String)c14nAlgorithmURI);
    }

    public static boolean registerTransformWithNodeSetOutput(String transformURI) {
        return transformsWithNodeSetOutput.add(transformURI);
    }

    public static Node indentAndReplace(Document document, Node node) {
        Node indentedNode = DSSXMLUtils.getIndentedNode(document, node);
        Node importedNode = document.importNode(indentedNode, true);
        node.getParentNode().replaceChild(importedNode, node);
        return importedNode;
    }

    public static Node indentAndExtend(Document document, Node newNode, Node oldNode) {
        Node indentedNode = DSSXMLUtils.getIndentedNode(document, newNode);
        indentedNode = DSSXMLUtils.alignChildrenIndents(indentedNode);
        Node importedNode = document.importNode(indentedNode, true);
        NodeList nodeList = importedNode.getChildNodes();
        for (int i = DSSXMLUtils.getPositionToStartExtension(oldNode, importedNode); i < nodeList.getLength(); ++i) {
            Node nodeToAppend = nodeList.item(i).cloneNode(true);
            if (1 == nodeToAppend.getNodeType() && DSSXMLUtils.checkIfExists(oldNode, nodeToAppend)) continue;
            oldNode.appendChild(nodeToAppend);
        }
        newNode.getParentNode().replaceChild(oldNode, newNode);
        return oldNode;
    }

    private static int getPositionToStartExtension(Node oldNode, Node indentedNode) {
        NodeList nodeList = oldNode.getChildNodes();
        int startPosition = nodeList.getLength();
        Node child = null;
        while (oldNode.hasChildNodes() && 3 == (child = oldNode.getLastChild()).getNodeType()) {
            oldNode.removeChild(child);
        }
        Integer position = DSSXMLUtils.getPosition(indentedNode, child);
        if (position != null) {
            return position;
        }
        return startPosition;
    }

    private static boolean checkIfExists(Node parentNode, Node childToCheck) {
        return DSSXMLUtils.getPosition(parentNode, childToCheck) != null;
    }

    private static Integer getPosition(Node parentNode, Node childToCheck) {
        if (parentNode != null && childToCheck != null) {
            String nodeName = childToCheck.getLocalName();
            NodeList newNodeChildList = parentNode.getChildNodes();
            for (int i = 0; i < newNodeChildList.getLength(); ++i) {
                String idIdentifier;
                Node newChildNode = newNodeChildList.item(i);
                if (!nodeName.equals(newChildNode.getLocalName()) || (idIdentifier = DSSXMLUtils.getIDIdentifier(childToCheck)) != null && !idIdentifier.equals(DSSXMLUtils.getIDIdentifier(newChildNode))) continue;
                return i + 1;
            }
        }
        return null;
    }

    public static Document getDocWithIndentedSignature(Document documentDom, String signatureId, List<String> noIndentObjectIds) {
        NodeList signatures = DomUtils.getNodeList((Node)documentDom, (String)XMLDSigPath.ALL_SIGNATURES_PATH);
        for (int i = 0; i < signatures.getLength(); ++i) {
            Element signature = (Element)signatures.item(i);
            String signatureAttrIdValue = DSSXMLUtils.getIDIdentifier(signature);
            if (!Utils.isStringNotEmpty((String)signatureAttrIdValue) || !signatureAttrIdValue.contains(signatureId)) continue;
            Node unsignedSignatureProperties = DomUtils.getNode((Node)signature, (String)AbstractPath.allFromCurrentPosition((DSSElement)XAdES132Element.UNSIGNED_SIGNATURE_PROPERTIES));
            Node indentedSignature = DSSXMLUtils.getIndentedSignature(signature, noIndentObjectIds);
            Node importedSignature = documentDom.importNode(indentedSignature, true);
            signature.getParentNode().replaceChild(importedSignature, signature);
            if (unsignedSignatureProperties == null) continue;
            Node newUnsignedSignatureProperties = DomUtils.getNode((Node)signature, (String)AbstractPath.allFromCurrentPosition((DSSElement)XAdES132Element.UNSIGNED_SIGNATURE_PROPERTIES));
            newUnsignedSignatureProperties.getParentNode().replaceChild(unsignedSignatureProperties, newUnsignedSignatureProperties);
        }
        return documentDom;
    }

    private static Node getIndentedSignature(Node signature, List<String> noIndentObjectIds) {
        Node indentedSignature = DSSXMLUtils.getIndentedNode(signature);
        NodeList sigChildNodes = signature.getChildNodes();
        for (int i = 0; i < sigChildNodes.getLength(); ++i) {
            Element sigChild;
            String idAttribute;
            Node childNode = sigChildNodes.item(i);
            if (childNode.getNodeType() != 1 || !noIndentObjectIds.contains(idAttribute = DSSXMLUtils.getIDIdentifier(sigChild = (Element)childNode))) continue;
            Element nodeToReplace = DomUtils.getElementById((Node)indentedSignature, (String)idAttribute);
            Node importedNode = indentedSignature.getOwnerDocument().importNode(sigChild, true);
            indentedSignature.replaceChild(importedNode, nodeToReplace);
        }
        return indentedSignature;
    }

    public static Node getIndentedNode(Node documentDom, Node xmlNode) {
        NodeList signatures = DomUtils.getNodeList((Node)documentDom, (String)XMLDSigPath.ALL_SIGNATURES_PATH);
        DSSElement element = XAdES132Element.fromTagName((String)xmlNode.getLocalName());
        String pathAllFromCurrentPosition = element != null ? AbstractPath.allFromCurrentPosition((DSSElement)element) : ".//" + xmlNode.getNodeName();
        for (int i = 0; i < signatures.getLength(); ++i) {
            Node indentedXmlNode;
            Node signature = signatures.item(i);
            String idAttribute = DSSXMLUtils.getIDIdentifier(xmlNode);
            NodeList candidateList = idAttribute != null ? DomUtils.getNodeList((Node)signature, (String)(".//*" + DomUtils.getXPathByIdAttribute((String)idAttribute))) : DomUtils.getNodeList((Node)signature, (String)pathAllFromCurrentPosition);
            if (!DSSXMLUtils.isNodeListContains(candidateList, xmlNode)) continue;
            Node indentedSignature = DSSXMLUtils.getIndentedNode(signature);
            if (idAttribute != null) {
                indentedXmlNode = DomUtils.getElementById((Node)indentedSignature, (String)idAttribute);
            } else {
                NodeList indentedXmlNodes = DomUtils.getNodeList((Node)indentedSignature, (String)pathAllFromCurrentPosition);
                if (indentedXmlNodes.getLength() == 0) {
                    throw new IllegalStateException(String.format("No elements found matching the '%s' XPath expression!", pathAllFromCurrentPosition));
                }
                indentedXmlNode = indentedXmlNodes.item(indentedXmlNodes.getLength() - 1);
            }
            if (indentedXmlNode == null) continue;
            return indentedXmlNode;
        }
        return xmlNode;
    }

    private static Node getIndentedNode(Node xmlNode) {
        PrettyPrintTransformer prettyPrintTransformer = new PrettyPrintTransformer();
        return prettyPrintTransformer.transform(xmlNode);
    }

    private static boolean isNodeListContains(NodeList nodeList, Node node) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child != node) continue;
            return true;
        }
        return false;
    }

    public static Node alignChildrenIndents(Node parentNode) {
        NodeList nodeChildren;
        String targetIndent;
        if (parentNode.hasChildNodes() && (targetIndent = DSSXMLUtils.getTargetIndent(nodeChildren = parentNode.getChildNodes())) != null) {
            for (int i = 0; i < nodeChildren.getLength() - 1; ++i) {
                Node node = nodeChildren.item(i);
                if (3 != node.getNodeType()) continue;
                node.setNodeValue(targetIndent);
            }
            Node lastChild = parentNode.getLastChild();
            targetIndent = targetIndent.substring(0, targetIndent.length() - 4);
            switch (lastChild.getNodeType()) {
                case 1: {
                    DomUtils.setTextNode((Document)parentNode.getOwnerDocument(), (Element)((Element)parentNode), (String)targetIndent);
                    break;
                }
                case 3: {
                    lastChild.setNodeValue(targetIndent);
                    break;
                }
            }
        }
        return parentNode;
    }

    private static String getTargetIndent(NodeList nodeChildren) {
        for (int i = 0; i < nodeChildren.getLength() - 1; ++i) {
            Node node = nodeChildren.item(i);
            if (3 != node.getNodeType()) continue;
            return node.getNodeValue();
        }
        return null;
    }

    @Deprecated
    public static byte[] serializeNode(Node xmlNode) {
        return DomUtils.serializeNode((Node)xmlNode);
    }

    @Deprecated
    public static boolean canCanonicalize(String canonicalizationMethod) {
        return XMLCanonicalizer.canCanonicalize((String)canonicalizationMethod);
    }

    @Deprecated
    public static byte[] canonicalize(String canonicalizationMethod, byte[] toCanonicalizeBytes) throws DSSException {
        return XMLCanonicalizer.createInstance((String)canonicalizationMethod).canonicalize(toCanonicalizeBytes);
    }

    @Deprecated
    public static byte[] canonicalizeSubtree(String canonicalizationMethod, Node node) {
        return XMLCanonicalizer.createInstance((String)canonicalizationMethod).canonicalize(node);
    }

    @Deprecated
    public static String getCanonicalizationMethod(String canonicalizationMethod) {
        if (Utils.isStringEmpty((String)canonicalizationMethod)) {
            LOG.warn("Canonicalization method is not defined. An inclusive canonicalization '{}' will be used (see XMLDSIG 4.4.3.2).", (Object)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            return "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        }
        return canonicalizationMethod;
    }

    public static void recursiveIdBrowse(Element element) {
        DSSXMLUtils.setIDIdentifier(element);
        for (int ii = 0; ii < element.getChildNodes().getLength(); ++ii) {
            Node node = element.getChildNodes().item(ii);
            if (node.getNodeType() != 1) continue;
            DSSXMLUtils.recursiveIdBrowse((Element)node);
        }
    }

    public static String getIDIdentifier(Node node) {
        return DSSXMLUtils.getAttribute(node, XMLDSigAttribute.ID.getAttributeName());
    }

    public static String getAttribute(Node node, String attributeName) {
        NamedNodeMap attributes = node.getAttributes();
        for (int jj = 0; jj < attributes.getLength(); ++jj) {
            String localName;
            Node item = attributes.item(jj);
            String string = localName = item.getLocalName() != null ? item.getLocalName() : item.getNodeName();
            if (!Utils.areStringsEqualIgnoreCase((String)attributeName, (String)localName)) continue;
            return item.getTextContent();
        }
        return null;
    }

    public static void setIDIdentifier(Element childElement) {
        NamedNodeMap attributes = childElement.getAttributes();
        for (int jj = 0; jj < attributes.getLength(); ++jj) {
            Node item = attributes.item(jj);
            String localName = item.getLocalName();
            String nodeName = item.getNodeName();
            if (localName == null || !Utils.areStringsEqualIgnoreCase((String)XMLDSigAttribute.ID.getAttributeName(), (String)localName)) continue;
            childElement.setIdAttribute(nodeName, true);
            break;
        }
    }

    public static List<String> validateAgainstXSD(XSDAbstractUtils xsdUtils, Source source) {
        return xsdUtils.validateAgainstXSD(source);
    }

    public static boolean isDuplicateIdsDetected(DSSDocument doc) {
        try {
            Document dom = DomUtils.buildDOM((DSSDocument)doc);
            Element root = dom.getDocumentElement();
            DSSXMLUtils.recursiveIdBrowse(root);
            XPathExpression xPathExpression = DomUtils.createXPathExpression((String)"//*/@*");
            NodeList nodeList = (NodeList)xPathExpression.evaluate(root, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                XPathExpression xpathAllById;
                NodeList nodeListById;
                Attr attr = (Attr)nodeList.item(i);
                if (!Utils.areStringsEqualIgnoreCase((String)XMLDSigAttribute.ID.getAttributeName(), (String)attr.getName()) || (nodeListById = (NodeList)(xpathAllById = DomUtils.createXPathExpression((String)("//*[@" + attr.getName() + "='" + attr.getValue() + "']"))).evaluate(root, XPathConstants.NODESET)).getLength() == 1) continue;
                LOG.warn("Problem detected with Id '{}', nb occurences = {}", (Object)attr.getValue(), (Object)nodeListById.getLength());
                return true;
            }
        }
        catch (XPathExpressionException e) {
            throw new DSSException("Unable to check if duplicate ids are present", (Throwable)e);
        }
        return false;
    }

    @Deprecated
    public static byte[] getNodeBytes(Node node) {
        return DomUtils.getNodeBytes((Node)node);
    }

    public static byte[] getReferenceOriginalContentBytes(Reference reference) {
        try {
            Element transformsElement;
            NodeList transformChildNodes;
            Transforms transforms = reference.getTransforms();
            if (transforms != null && (transformChildNodes = (transformsElement = transforms.getElement()).getChildNodes()) != null && transformChildNodes.getLength() > 0) {
                for (int i = 0; i < transformChildNodes.getLength(); ++i) {
                    Node transformation = transformChildNodes.item(i);
                    if (!DSSXMLUtils.isEnvelopedTransform(transformation)) continue;
                    return reference.getReferencedBytes();
                }
            }
        }
        catch (XMLSecurityException e) {
            LOG.warn("Signature reference with id [{}] is corrupted or has an invalid format. Original data cannot be obtained. Reason: [{}]", (Object)reference.getId(), (Object)e.getMessage());
        }
        return DSSXMLUtils.getBytesBeforeTransformation(reference);
    }

    private static boolean isEnvelopedTransform(Node transformation) {
        String algorithm = DomUtils.getValue((Node)transformation, (String)"@Algorithm");
        if ("http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(algorithm)) {
            return true;
        }
        if ("http://www.w3.org/TR/1999/REC-xpath-19991116".equals(algorithm) || "http://www.w3.org/2002/06/xmldsig-filter2".equals(algorithm)) {
            NodeList childNodes = transformation.getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node item = childNodes.item(j);
                if (1 != item.getNodeType() || !TRANSFORMATION_XPATH_NODE_NAME.equals(item.getLocalName()) || !TRANSFORMATION_EXCLUDE_SIGNATURE.equals(item.getTextContent())) continue;
                return true;
            }
        }
        return false;
    }

    private static byte[] getBytesBeforeTransformation(Reference reference) {
        try {
            return reference.getContentsBeforeTransformation().getBytes();
        }
        catch (ReferenceNotInitializedException e) {
            LOG.warn("Original data is not provided for the reference with id [{}]. Reason: [{}]", (Object)reference.getId(), (Object)e.getMessage());
        }
        catch (IOException | CanonicalizationException e) {
            LOG.error("Unable to retrieve the content of reference with id [{}].", (Object)reference.getId(), (Object)e);
        }
        return null;
    }

    public static Digest getDigestAndValue(Element element) {
        String digestValueBase64;
        String digestAlgorithmUri;
        if (element == null) {
            return null;
        }
        if (XAdESNamespace.XADES_111.isSameUri(element.getNamespaceURI())) {
            digestAlgorithmUri = DomUtils.getValue((Node)element, (String)XAdES111Path.DIGEST_METHOD_ALGORITHM_PATH);
            digestValueBase64 = DomUtils.getValue((Node)element, (String)XAdES111Path.DIGEST_VALUE_PATH);
        } else {
            digestAlgorithmUri = DomUtils.getValue((Node)element, (String)XMLDSigPath.DIGEST_METHOD_ALGORITHM_PATH);
            digestValueBase64 = DomUtils.getValue((Node)element, (String)XMLDSigPath.DIGEST_VALUE_PATH);
        }
        DigestAlgorithm digestAlgorithm = DSSXMLUtils.getDigestAlgorithm(digestAlgorithmUri);
        byte[] digestValue = DSSXMLUtils.getDigestValue(digestValueBase64);
        if (digestAlgorithm == null || Utils.isArrayEmpty((byte[])digestValue)) {
            LOG.warn("Unable to read object DigestAlgAndValueType (XMLDSig or XAdES 1.1.1)");
            return null;
        }
        return new Digest(digestAlgorithm, digestValue);
    }

    private static byte[] getDigestValue(String digestValueBase64) {
        byte[] result = null;
        if (Utils.isStringEmpty((String)digestValueBase64)) {
            LOG.error("An empty DigestValue obtained!");
        } else if (!Utils.isBase64Encoded((String)digestValueBase64)) {
            LOG.error("The DigestValue is not base64 encoded! Obtained string : {}", (Object)digestValueBase64);
        } else {
            result = Utils.fromBase64((String)digestValueBase64);
        }
        return result;
    }

    private static DigestAlgorithm getDigestAlgorithm(String digestAlgorithmUri) {
        DigestAlgorithm result = null;
        if (Utils.isStringNotEmpty((String)digestAlgorithmUri)) {
            try {
                result = DigestAlgorithm.forXML((String)digestAlgorithmUri);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Unable to retrieve the used digest algorithm", (Throwable)e);
            }
        }
        return result;
    }

    public static boolean isSignedProperties(Reference reference, XAdESPath xadesPaths) {
        return xadesPaths.getSignedPropertiesUri().equals(reference.getType());
    }

    public static boolean isCounterSignature(Reference reference, XAdESPath xadesPaths) {
        return xadesPaths.getCounterSignatureUri().equals(reference.getType());
    }

    public static boolean isKeyInfoReference(Reference reference, Element signature) {
        String uri = reference.getURI();
        uri = DomUtils.getId((String)uri);
        Element keyInfoElement = DomUtils.getElement((Node)signature, (String)(XMLDSigPath.KEY_INFO_PATH + DomUtils.getXPathByIdAttribute((String)uri)));
        return keyInfoElement != null;
    }

    public static boolean isSignaturePropertiesReference(Reference reference, Element signature) {
        String uri = reference.getURI();
        uri = DomUtils.getId((String)uri);
        Element signaturePropertiesElement = DomUtils.getElement((Node)signature, (String)(XMLDSigPath.SIGNATURE_PROPERTIES_PATH + DomUtils.getXPathByIdAttribute((String)uri)));
        Element signaturePropertyElement = DomUtils.getElement((Node)signature, (String)(XMLDSigPath.SIGNATURE_PROPERTY_PATH + DomUtils.getXPathByIdAttribute((String)uri)));
        return signaturePropertiesElement != null || signaturePropertyElement != null;
    }

    public static boolean isObjectReferenceType(String referenceType) {
        return "http://www.w3.org/2000/09/xmldsig#Object".equals(referenceType);
    }

    public static boolean isManifestReferenceType(String referenceType) {
        return "http://www.w3.org/2000/09/xmldsig#Manifest".equals(referenceType);
    }

    public static boolean isCounterSignatureReferenceType(String referenceType) {
        return "http://uri.etsi.org/01903#CountersignedSignature".equals(referenceType);
    }

    public static boolean isSameDocumentReference(String referenceUri) {
        return "".equals(referenceUri) || DomUtils.startsFromHash((String)referenceUri);
    }

    public static Element getObjectById(Element signatureElement, String id) {
        if (Utils.isStringNotBlank((String)id)) {
            try {
                String objectById = XMLDSigPath.OBJECT_PATH + DomUtils.getXPathByIdAttribute((String)id);
                return DomUtils.getElement((Node)signatureElement, (String)objectById);
            }
            catch (Exception e) {
                String errorMessage = "An error occurred on attempt to extract Object element with Id '{}' : {}";
                if (LOG.isDebugEnabled()) {
                    LOG.warn(errorMessage, new Object[]{id, e.getMessage(), e});
                }
                LOG.warn(errorMessage, (Object)id, (Object)e.getMessage());
            }
        }
        return null;
    }

    public static Element getManifestById(Element signatureElement, String id) {
        if (Utils.isStringNotBlank((String)id)) {
            try {
                String manifestById = XMLDSigPath.MANIFEST_PATH + DomUtils.getXPathByIdAttribute((String)id);
                return DomUtils.getElement((Node)signatureElement, (String)manifestById);
            }
            catch (Exception e) {
                String errorMessage = "An error occurred on attempt to extract Manifest element with Id '{}' : {}";
                if (LOG.isDebugEnabled()) {
                    LOG.warn(errorMessage, new Object[]{id, e.getMessage(), e});
                }
                LOG.warn(errorMessage, (Object)id, (Object)e.getMessage());
            }
        }
        return null;
    }

    public static Manifest initManifest(Element manifestElement) throws XMLSecurityException {
        return new Manifest(manifestElement, "");
    }

    public static PublicKey getKeyInfoSigningCertificatePublicKey(Element signatureElement) {
        Element keyInfoElement = DomUtils.getElement((Node)signatureElement, (String)XMLDSigPath.KEY_INFO_PATH);
        if (keyInfoElement != null) {
            try {
                KeyInfo keyInfo = new KeyInfo(keyInfoElement, "");
                return keyInfo.getPublicKey();
            }
            catch (XMLSecurityException e) {
                LOG.warn("Unable to extract signing certificate's public key. Reason : {}", (Object)e.getMessage(), (Object)e);
            }
        }
        LOG.warn("Unable to extract the public key. Reason : KeyInfo element is null");
        return null;
    }

    public static XAdESSignature createCounterSignature(Element counterSignatureElement, XAdESSignature masterSignature) {
        try {
            Node counterSignatureNode = DomUtils.getNode((Node)counterSignatureElement, (String)XMLDSigPath.SIGNATURE_PATH);
            XAdESSignature xadesCounterSignature = new XAdESSignature((Element)counterSignatureNode, masterSignature.getXAdESPathsHolders());
            xadesCounterSignature.setSignatureFilename(masterSignature.getSignatureFilename());
            xadesCounterSignature.setDetachedContents(masterSignature.getDetachedContents());
            if (DSSXMLUtils.isCounterSignature(xadesCounterSignature)) {
                xadesCounterSignature.setMasterSignature((AdvancedSignature)masterSignature);
                return xadesCounterSignature;
            }
        }
        catch (Exception e) {
            String errorMessage = "An error occurred during counter signature extraction. The element entry is skipped. Reason : {}";
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
            }
            LOG.warn(errorMessage, (Object)e.getMessage());
        }
        return null;
    }

    private static boolean isCounterSignature(XAdESSignature xadesCounterSignature) {
        List<Reference> references = xadesCounterSignature.getReferences();
        for (Reference reference : references) {
            if (!DSSXMLUtils.isCounterSignature(reference, xadesCounterSignature.getXAdESPaths())) continue;
            return true;
        }
        return false;
    }

    public static NodeList getAllSignaturesExceptCounterSignatures(Node documentNode) {
        return DomUtils.getNodeList((Node)documentNode, (String)XAdES132Path.ALL_SIGNATURE_WITH_NO_COUNTERSIGNATURE_AS_PARENT_PATH);
    }

    public static NodeList getAllEncapsulatedTimestamps(Node documentNode) {
        return DomUtils.getNodeList((Node)documentNode, (String)XAdES132Path.ALL_ENCAPSULATED_TIMESTAMP_PARENT_PATH);
    }

    public static NodeList getReferenceNodeList(Node signatureElement) {
        return DomUtils.getNodeList((Node)signatureElement, (String)XMLDSigPath.SIGNED_INFO_REFERENCE_PATH);
    }

    public static ReferenceOutputType getReferenceOutputType(DSSReference reference) {
        ReferenceOutputType outputType = DSSXMLUtils.getDereferenceOutputType(reference.getUri());
        if (Utils.isCollectionNotEmpty(reference.getTransforms())) {
            for (DSSTransform transform : reference.getTransforms()) {
                String algorithmUri = transform.getAlgorithm();
                outputType = DSSXMLUtils.getTransformOutputType(algorithmUri);
            }
        }
        return outputType;
    }

    public static ReferenceOutputType getReferenceOutputType(Reference reference) throws XMLSecurityException {
        ReferenceOutputType outputType = DSSXMLUtils.getDereferenceOutputType(reference.getURI());
        Transforms transforms = reference.getTransforms();
        if (transforms != null) {
            for (int ii = 0; ii < transforms.getLength(); ++ii) {
                Transform transform = transforms.item(ii);
                outputType = DSSXMLUtils.getTransformOutputType(transform.getURI());
            }
        }
        return outputType;
    }

    private static ReferenceOutputType getDereferenceOutputType(String referenceUri) {
        return DSSXMLUtils.isSameDocumentReference(referenceUri) ? ReferenceOutputType.NODE_SET : ReferenceOutputType.OCTET_STREAM;
    }

    private static ReferenceOutputType getTransformOutputType(String algorithmUri) {
        return transformsWithNodeSetOutput.contains(algorithmUri) ? ReferenceOutputType.NODE_SET : ReferenceOutputType.OCTET_STREAM;
    }

    public static byte[] applyTransforms(Node node, List<DSSTransform> transforms) {
        byte[] bytes = DSSUtils.EMPTY_BYTE_ARRAY;
        if (Utils.isCollectionNotEmpty(transforms)) {
            DSSTransformOutput output = new DSSTransformOutput(node);
            Iterator<DSSTransform> iterator = transforms.iterator();
            while (iterator.hasNext()) {
                DSSTransform transform = iterator.next();
                output = transform.performTransform(output);
                bytes = output.getBytes();
                if (!iterator.hasNext() || !Utils.isArrayEmpty((byte[])bytes)) continue;
                throw new IllegalInputException(String.format("Unable to perform the next transform. The %s produced an empty output!", transform));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reference bytes after transforms: ");
                LOG.debug(new String(bytes));
            }
            if (Utils.isArrayEmpty((byte[])bytes)) {
                LOG.warn("The output of reference transforms processing is an empty byte array!");
            }
            return bytes;
        }
        bytes = DomUtils.getNodeBytes((Node)node);
        return bytes;
    }

    public static byte[] applyTransforms(DSSDocument document, List<DSSTransform> transforms) {
        return DSSXMLUtils.applyTransforms(DomUtils.buildDOM((DSSDocument)document), transforms);
    }

    public static List<DigestAlgorithm> getReferenceDigestAlgos(Element referenceContainer) {
        ArrayList<DigestAlgorithm> digestAlgorithms = new ArrayList<DigestAlgorithm>();
        NodeList referenceNodeList = DomUtils.getNodeList((Node)referenceContainer, (String)XMLDSigPath.REFERENCE_PATH);
        for (int ii = 0; ii < referenceNodeList.getLength(); ++ii) {
            Element referenceElement = (Element)referenceNodeList.item(ii);
            Digest digest = DSSXMLUtils.getDigestAndValue(referenceElement);
            if (digest == null) continue;
            digestAlgorithms.add(digest.getAlgorithm());
        }
        return digestAlgorithms;
    }

    public static List<String> getReferenceTypes(Element referenceContainer) {
        ArrayList<String> referenceTypes = new ArrayList<String>();
        NodeList referenceNodeList = DomUtils.getNodeList((Node)referenceContainer, (String)XMLDSigPath.REFERENCE_PATH);
        for (int ii = 0; ii < referenceNodeList.getLength(); ++ii) {
            Element referenceElement = (Element)referenceNodeList.item(ii);
            String type = referenceElement.getAttribute(XMLDSigAttribute.TYPE.getAttributeName());
            if (!Utils.isStringNotEmpty((String)type)) continue;
            referenceTypes.add(type);
        }
        return referenceTypes;
    }

    public static List<Reference> extractReferences(Manifest manifest) {
        ArrayList<Reference> references = new ArrayList<Reference>();
        int numberOfReferences = manifest.getLength();
        for (int ii = 0; ii < numberOfReferences; ++ii) {
            try {
                Reference reference = manifest.item(ii);
                references.add(reference);
                continue;
            }
            catch (XMLSecurityException e) {
                LOG.warn("Unable to retrieve reference #{} : {}", (Object)ii, (Object)e.getMessage());
            }
        }
        return references;
    }

    public static Digest getReferenceDigest(Reference reference) {
        try {
            Digest digest = new Digest();
            digest.setValue(reference.getDigestValue());
            digest.setAlgorithm(DigestAlgorithm.forXML((String)reference.getMessageDigestAlgorithm().getAlgorithmURI()));
            return digest;
        }
        catch (XMLSecurityException e) {
            LOG.warn("Unable to extract Digest from a reference with Id [{}] : {}", new Object[]{reference.getId(), e.getMessage(), e});
            return null;
        }
    }

    public static String getReferenceURI(Reference reference) {
        Element element;
        if (reference != null && (element = reference.getElement()) != null) {
            return DSSXMLUtils.getAttribute(element, XMLDSigAttribute.URI.getAttributeName());
        }
        return null;
    }

    public static boolean isAbleToDeReferenceContent(Reference reference) {
        try {
            return reference.getContentsBeforeTransformation() != null;
        }
        catch (ReferenceNotInitializedException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Cannot get the pointed bytes by a reference with uri='%s'. Reason : [%s]", reference.getURI(), e.getMessage()));
            }
            return false;
        }
    }

    public static boolean isReferencedContentAmbiguous(Document document, String uri) {
        if (Utils.isStringNotEmpty((String)uri)) {
            return !XMLUtils.protectAgainstWrappingAttack((Node)document, (String)DomUtils.getId((String)uri));
        }
        return false;
    }

    public static void incorporateTransforms(Element parentElement, List<DSSTransform> transforms, DSSNamespace namespace) {
        if (Utils.isCollectionNotEmpty(transforms)) {
            Document documentDom = parentElement.getOwnerDocument();
            Element transformsDom = DomUtils.createElementNS((Document)documentDom, (DSSNamespace)namespace, (DSSElement)XMLDSigElement.TRANSFORMS);
            parentElement.appendChild(transformsDom);
            for (DSSTransform dssTransform : transforms) {
                dssTransform.createTransform(documentDom, transformsDom);
            }
        }
    }

    public static void incorporateDigestMethod(Element parentElement, DigestAlgorithm digestAlgorithm, DSSNamespace namespace) {
        Document documentDom = parentElement.getOwnerDocument();
        Element digestMethodDom = DomUtils.addElement((Document)documentDom, (Element)parentElement, (DSSNamespace)namespace, (DSSElement)XMLDSigElement.DIGEST_METHOD);
        digestMethodDom.setAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName(), digestAlgorithm.getUri());
    }

    public static void incorporateDigestValue(Element parentDom, String base64EncodedDigestBytes, DSSNamespace namespace) {
        Document documentDom = parentDom.getOwnerDocument();
        Element digestValueDom = DomUtils.createElementNS((Document)documentDom, (DSSNamespace)namespace, (DSSElement)XMLDSigElement.DIGEST_VALUE);
        Text textNode = documentDom.createTextNode(base64EncodedDigestBytes);
        digestValueDom.appendChild(textNode);
        parentDom.appendChild(digestValueDom);
    }

    public static DigestAlgorithm getReferenceDigestAlgorithmOrDefault(XAdESSignatureParameters params) {
        DigestAlgorithm digestAlgorithm;
        DigestAlgorithm digestAlgorithm2 = digestAlgorithm = params.getReferenceDigestAlgorithm() != null ? params.getReferenceDigestAlgorithm() : params.getDigestAlgorithm();
        if (digestAlgorithm == null || digestAlgorithm.getUri() == null) {
            throw new IllegalArgumentException(String.format("The Reference DigestAlgorithm '%s' is not supported for XAdES creation! Define another algorithm within #setReferenceDigestAlgorithm method.", digestAlgorithm));
        }
        return digestAlgorithm;
    }

    static {
        SAML_NAMESPACE = new DSSNamespace("urn:oasis:names:tc:SAML:2.0:assertion", "saml2");
        SantuarioInitializer.init();
        transforms = new HashSet<String>();
        DSSXMLUtils.registerDefaultTransforms();
        transformsWithNodeSetOutput = new HashSet<String>();
        DSSXMLUtils.registerTransformsWithNodeSetOutput();
        DSSXMLUtils.registerXAdESNamespaces();
    }
}

