/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigAttribute;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigElement;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigPaths;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.EndorsementType;
import eu.europa.esig.dss.enumerations.MaskGenerationFunction;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.CandidatesForSigningCertificate;
import eu.europa.esig.dss.spi.x509.CertificateValidity;
import eu.europa.esig.dss.spi.x509.revocation.crl.OfflineCRLSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OfflineOCSPSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CommitmentTypeIndication;
import eu.europa.esig.dss.validation.DefaultAdvancedSignature;
import eu.europa.esig.dss.validation.ReferenceValidation;
import eu.europa.esig.dss.validation.SignatureCertificateSource;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.validation.SignatureDigestReference;
import eu.europa.esig.dss.validation.SignatureIdentifier;
import eu.europa.esig.dss.validation.SignaturePolicy;
import eu.europa.esig.dss.validation.SignaturePolicyProvider;
import eu.europa.esig.dss.validation.SignatureProductionPlace;
import eu.europa.esig.dss.validation.SignerRole;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.SantuarioInitializer;
import eu.europa.esig.dss.xades.definition.XAdESNamespaces;
import eu.europa.esig.dss.xades.definition.XAdESPaths;
import eu.europa.esig.dss.xades.definition.xades132.XAdES132Element;
import eu.europa.esig.dss.xades.definition.xades132.XAdES132Paths;
import eu.europa.esig.dss.xades.definition.xades141.XAdES141Element;
import eu.europa.esig.dss.xades.reference.XAdESReferenceValidation;
import eu.europa.esig.dss.xades.validation.DetachedSignatureResolver;
import eu.europa.esig.dss.xades.validation.ManifestValidator;
import eu.europa.esig.dss.xades.validation.SignatureRSARIPEMD160AT;
import eu.europa.esig.dss.xades.validation.XAdESCRLSource;
import eu.europa.esig.dss.xades.validation.XAdESCertificateSource;
import eu.europa.esig.dss.xades.validation.XAdESOCSPSource;
import eu.europa.esig.dss.xades.validation.XAdESSignatureIdentifier;
import eu.europa.esig.dss.xades.validation.XAdESTimestampSource;
import java.security.Key;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.xml.transform.dom.DOMSource;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.ReferenceNotInitializedException;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.digidoc4j.dss.xades.BDocTmSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESSignature
extends DefaultAdvancedSignature {
    private static final long serialVersionUID = -2639858392612722185L;
    private static final Logger LOG = LoggerFactory.getLogger(XAdESSignature.class);
    private static SignatureLevel[] signatureLevels = new SignatureLevel[]{SignatureLevel.XML_NOT_ETSI, SignatureLevel.XAdES_BASELINE_B, SignatureLevel.XAdES_BASELINE_T, SignatureLevel.XAdES_C, SignatureLevel.XAdES_X, SignatureLevel.XAdES_BASELINE_LT, SignatureLevel.XAdES_BASELINE_LTA};
    private static final String DEFAULT_CANONICALIZATION_METHOD = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private final List<XAdESPaths> xadesPathsHolders;
    private DSSNamespace xmldSigNamespace;
    private DSSNamespace xadesNamespace;
    private XAdESPaths xadesPaths;
    private boolean disableXSWProtection = false;
    private final Element signatureElement;
    private transient XMLSignature santuarioSignature;
    private String daIdentifier;
    private transient List<Reference> references;
    private List<ReferenceValidation> referenceValidations;

    public XAdESSignature(Element signatureElement) {
        this(signatureElement, Arrays.asList(new XAdES132Paths()));
    }

    public XAdESSignature(Element signatureElement, List<XAdESPaths> xadesPathsHolders) {
        Objects.requireNonNull(signatureElement, "Signature Element cannot be null");
        this.signatureElement = signatureElement;
        this.xadesPathsHolders = xadesPathsHolders;
        this.initialiseSettings();
    }

    public void setDisableXSWProtection(boolean disableXSWProtection) {
        this.disableXSWProtection = disableXSWProtection;
    }

    private void initialiseSettings() {
        this.recursiveNamespaceBrowser(this.signatureElement);
        if (this.xadesPaths == null) {
            LOG.warn("There is no suitable XAdESPaths / XAdESNamespace to manage the signature. The default ones will be used.");
            this.xadesPaths = new XAdES132Paths();
            this.xadesNamespace = XAdESNamespaces.XADES_132;
        }
    }

    public void recursiveNamespaceBrowser(Element element) {
        for (int ii = 0; ii < element.getChildNodes().getLength(); ++ii) {
            Node node = element.getChildNodes().item(ii);
            if (node.getNodeType() != 1) continue;
            String prefix = node.getPrefix();
            Element childElement = (Element)node;
            String namespaceURI = childElement.getNamespaceURI();
            String localName = childElement.getLocalName();
            if (XMLDSigElement.TRANSFORM.isSameTagName(localName) && XMLDSigElement.TRANSFORM.getURI().equals(namespaceURI)) {
                this.xmldSigNamespace = new DSSNamespace(namespaceURI, prefix);
                continue;
            }
            if (XAdES132Element.QUALIFYING_PROPERTIES.isSameTagName(localName)) {
                this.setXAdESPathAndNamespace(prefix, namespaceURI);
                return;
            }
            this.recursiveNamespaceBrowser(childElement);
        }
    }

    private void setXAdESPathAndNamespace(String prefix, String namespaceURI) {
        for (XAdESPaths currentXAdESPaths : this.xadesPathsHolders) {
            if (!currentXAdESPaths.getNamespace().isSameUri(namespaceURI)) continue;
            this.xadesPaths = currentXAdESPaths;
            this.xadesNamespace = new DSSNamespace(namespaceURI, prefix);
        }
    }

    public XAdESPaths getXAdESPaths() {
        return this.xadesPaths;
    }

    public DSSNamespace getXmldSigNamespace() {
        return this.xmldSigNamespace;
    }

    public DSSNamespace getXadesNamespace() {
        return this.xadesNamespace;
    }

    public Element getSignatureElement() {
        return this.signatureElement;
    }

    public SignatureForm getSignatureForm() {
        return SignatureForm.XAdES;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        SignatureAlgorithm signatureAlgorithm = this.getSignatureAlgorithm();
        if (signatureAlgorithm == null) {
            return null;
        }
        return signatureAlgorithm.getEncryptionAlgorithm();
    }

    public DigestAlgorithm getDigestAlgorithm() {
        SignatureAlgorithm signatureAlgorithm = this.getSignatureAlgorithm();
        if (signatureAlgorithm == null) {
            return null;
        }
        return signatureAlgorithm.getDigestAlgorithm();
    }

    public MaskGenerationFunction getMaskGenerationFunction() {
        SignatureAlgorithm signatureAlgorithm = this.getSignatureAlgorithm();
        if (signatureAlgorithm == null) {
            return null;
        }
        return signatureAlgorithm.getMaskGenerationFunction();
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        String xmlName = DomUtils.getElement((Node)this.signatureElement, (String)XMLDSigPaths.SIGNATURE_METHOD_PATH).getAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName());
        return SignatureAlgorithm.forXML((String)xmlName, null);
    }

    public SignatureCertificateSource getCertificateSource() {
        if (this.offlineCertificateSource == null) {
            this.offlineCertificateSource = new XAdESCertificateSource(this.signatureElement, this.xadesPaths);
        }
        return this.offlineCertificateSource;
    }

    public void resetCertificateSource() {
        this.offlineCertificateSource = null;
    }

    public OfflineCRLSource getCRLSource() {
        if (this.signatureCRLSource == null) {
            this.signatureCRLSource = new XAdESCRLSource(this.signatureElement, this.xadesPaths);
        }
        return this.signatureCRLSource;
    }

    public OfflineOCSPSource getOCSPSource() {
        if (this.signatureOCSPSource == null) {
            this.signatureOCSPSource = new XAdESOCSPSource(this.signatureElement, this.xadesPaths);
        }
        return this.signatureOCSPSource;
    }

    public void resetRevocationSources() {
        this.signatureCRLSource = null;
        this.signatureOCSPSource = null;
    }

    public XAdESTimestampSource getTimestampSource() {
        if (this.signatureTimestampSource == null) {
            this.signatureTimestampSource = new XAdESTimestampSource(this, this.signatureElement, this.xadesPaths);
        }
        return (XAdESTimestampSource)this.signatureTimestampSource;
    }

    public void resetTimestampSource() {
        this.signatureTimestampSource = null;
    }

    public Date getSigningTime() {
        Element signingTimeEl = DomUtils.getElement((Node)this.signatureElement, (String)this.xadesPaths.getSigningTimePath());
        if (signingTimeEl == null) {
            return null;
        }
        String text = signingTimeEl.getTextContent();
        return DomUtils.getDate((String)text);
    }

    public void checkSignaturePolicy(SignaturePolicyProvider signaturePolicyProvider) {
        Element policyIdentifier = DomUtils.getElement((Node)this.signatureElement, (String)this.xadesPaths.getSignaturePolicyIdentifier());
        if (policyIdentifier != null) {
            Element policyId = DomUtils.getElement((Node)policyIdentifier, (String)this.xadesPaths.getCurrentSignaturePolicyId());
            if (policyId != null) {
                Element docRefsNode;
                Element policyDescription;
                String policyUrlString = null;
                String policyIdString = policyId.getTextContent();
                if (Utils.isStringNotEmpty((String)policyIdString)) {
                    policyIdString = policyIdString.replaceAll("\n", "");
                    if (DSSXMLUtils.isOid(policyIdString = policyIdString.trim())) {
                        policyIdString = DSSXMLUtils.getOidCode(policyIdString);
                    } else {
                        policyUrlString = policyIdString;
                    }
                }
                this.signaturePolicy = new SignaturePolicy(policyIdString);
                Digest digest = DSSXMLUtils.getDigestAndValue(DomUtils.getElement((Node)policyIdentifier, (String)this.xadesPaths.getCurrentSignaturePolicyDigestAlgAndValue()));
                this.signaturePolicy.setDigest(digest);
                Element policyUrl = DomUtils.getElement((Node)policyIdentifier, (String)this.xadesPaths.getCurrentSignaturePolicySPURI());
                if (policyUrl != null) {
                    policyUrlString = policyUrl.getTextContent().trim();
                }
                if ((policyDescription = DomUtils.getElement((Node)policyIdentifier, (String)this.xadesPaths.getCurrentSignaturePolicyDescription())) != null && Utils.isStringNotEmpty((String)policyDescription.getTextContent())) {
                    this.signaturePolicy.setDescription(policyDescription.getTextContent());
                }
                if ((docRefsNode = DomUtils.getElement((Node)policyIdentifier, (String)this.xadesPaths.getCurrentSignaturePolicyDocumentationReferences())) != null) {
                    this.signaturePolicy.setDocumentationReferences(this.getDocumentationReferences(docRefsNode));
                }
                this.signaturePolicy.setUrl(policyUrlString);
                this.signaturePolicy.setPolicyContent(signaturePolicyProvider.getSignaturePolicy(policyIdString, policyUrlString));
            } else {
                Element signaturePolicyImplied = DomUtils.getElement((Node)policyIdentifier, (String)this.xadesPaths.getCurrentSignaturePolicyImplied());
                if (signaturePolicyImplied != null) {
                    this.signaturePolicy = new SignaturePolicy();
                }
            }
        }
    }

    public SignatureProductionPlace getSignatureProductionPlace() {
        String signatureProductionPlaceV2Path;
        NodeList nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)this.xadesPaths.getSignatureProductionPlacePath());
        if ((nodeList.getLength() == 0 || nodeList.item(0) == null) && (signatureProductionPlaceV2Path = this.xadesPaths.getSignatureProductionPlaceV2Path()) != null) {
            nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)signatureProductionPlaceV2Path);
        }
        if (nodeList.getLength() == 0 || nodeList.item(0) == null) {
            return null;
        }
        SignatureProductionPlace signatureProductionPlace = new SignatureProductionPlace();
        NodeList list = nodeList.item(0).getChildNodes();
        for (int ii = 0; ii < list.getLength(); ++ii) {
            Node item = list.item(ii);
            String name = item.getLocalName();
            String nodeValue = item.getTextContent();
            if (XAdES132Element.CITY.isSameTagName(name)) {
                signatureProductionPlace.setCity(nodeValue);
                continue;
            }
            if (XAdES132Element.STATE_OR_PROVINCE.isSameTagName(name)) {
                signatureProductionPlace.setStateOrProvince(nodeValue);
                continue;
            }
            if (XAdES132Element.POSTAL_CODE.isSameTagName(name)) {
                signatureProductionPlace.setPostalCode(nodeValue);
                continue;
            }
            if (XAdES132Element.COUNTRY_NAME.isSameTagName(name)) {
                signatureProductionPlace.setCountryName(nodeValue);
                continue;
            }
            if (!XAdES132Element.STREET_ADDRESS.isSameTagName(name)) continue;
            signatureProductionPlace.setStreetAddress(nodeValue);
        }
        return signatureProductionPlace;
    }

    public List<SignerRole> getSignedAssertions() {
        ArrayList<SignerRole> result = new ArrayList<SignerRole>();
        String signedAssertionPath = this.xadesPaths.getSignedAssertionPath();
        if (signedAssertionPath != null) {
            NodeList nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)signedAssertionPath);
            for (int ii = 0; ii < nodeList.getLength(); ++ii) {
                result.add(new SignerRole(DomUtils.xmlToString((Node)nodeList.item(ii).getFirstChild()), EndorsementType.SIGNED));
            }
        }
        return result;
    }

    public List<SignerRole> getClaimedSignerRoles() {
        String claimedRoleV2Path;
        NodeList nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)this.xadesPaths.getClaimedRolePath());
        if (nodeList.getLength() == 0 && (claimedRoleV2Path = this.xadesPaths.getClaimedRoleV2Path()) != null && (nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)claimedRoleV2Path)).getLength() == 0) {
            return Collections.emptyList();
        }
        ArrayList<SignerRole> claimedRoles = new ArrayList<SignerRole>();
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            claimedRoles.add(new SignerRole(nodeList.item(ii).getTextContent(), EndorsementType.CLAIMED));
        }
        return claimedRoles;
    }

    public List<SignerRole> getCertifiedSignerRoles() {
        String certifiedRoleV2Path;
        NodeList nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)this.xadesPaths.getCertifiedRolePath());
        if (nodeList.getLength() == 0 && (certifiedRoleV2Path = this.xadesPaths.getCertifiedRoleV2Path()) != null && (nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)certifiedRoleV2Path)).getLength() == 0) {
            return Collections.emptyList();
        }
        ArrayList<SignerRole> certifiedRoles = new ArrayList<SignerRole>();
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            Element certEl = (Element)nodeList.item(ii);
            String textContent = certEl.getTextContent();
            certifiedRoles.add(new SignerRole(textContent, EndorsementType.CERTIFIED));
        }
        return certifiedRoles;
    }

    public String getContentType() {
        String contentType = null;
        NodeList allContentTypes = DomUtils.getNodeList((Node)this.signatureElement, (String)this.xadesPaths.getDataObjectFormatObjectIdentifier());
        if (allContentTypes != null && allContentTypes.getLength() > 0) {
            for (int i = 0; i < allContentTypes.getLength(); ++i) {
                Node node = allContentTypes.item(i);
                if (!(node instanceof Element)) continue;
                Element element = (Element)node;
                contentType = element.getTextContent();
                break;
            }
        }
        return contentType;
    }

    public String getMimeType() {
        String mimeType = null;
        NodeList allMimeTypes = DomUtils.getNodeList((Node)this.signatureElement, (String)this.xadesPaths.getDataObjectFormatMimeType());
        if (allMimeTypes != null && allMimeTypes.getLength() > 0) {
            for (int i = 0; i < allMimeTypes.getLength(); ++i) {
                Node node = allMimeTypes.item(i);
                if (!(node instanceof Element)) continue;
                Element element = (Element)node;
                mimeType = element.getTextContent();
                break;
            }
        }
        return mimeType;
    }

    public String getContentIdentifier() {
        return null;
    }

    public String getContentHints() {
        return null;
    }

    public String getSignatureValueBase64() {
        Element signatureValueElement = DomUtils.getElement((Node)this.signatureElement, (String)XMLDSigPaths.SIGNATURE_VALUE_PATH);
        if (signatureValueElement != null) {
            return signatureValueElement.getTextContent();
        }
        return null;
    }

    public byte[] getSignatureValue() {
        String signatureValueBase64 = this.getSignatureValueBase64();
        if (signatureValueBase64 != null) {
            return Utils.fromBase64((String)signatureValueBase64);
        }
        return null;
    }

    public String getSignatureValueId() {
        return DomUtils.getValue((Node)this.signatureElement, (String)XMLDSigPaths.SIGNATURE_VALUE_ID_PATH);
    }

    public NodeList getObjects() {
        return DomUtils.getNodeList((Node)this.signatureElement, (String)XMLDSigPaths.OBJECT_PATH);
    }

    public Element getCompleteCertificateRefs() {
        return DomUtils.getElement((Node)this.signatureElement, (String)this.xadesPaths.getCompleteCertificateRefsPath());
    }

    public Element getCompleteRevocationRefs() {
        return DomUtils.getElement((Node)this.signatureElement, (String)this.xadesPaths.getCompleteRevocationRefsPath());
    }

    public NodeList getSigAndRefsTimeStamp() {
        String sigAndRefsTimestampV2Path;
        NodeList nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)this.xadesPaths.getSigAndRefsTimestampPath());
        if ((nodeList == null || nodeList.getLength() == 0) && (sigAndRefsTimestampV2Path = this.xadesPaths.getSigAndRefsTimestampV2Path()) != null) {
            nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)sigAndRefsTimestampV2Path);
        }
        return nodeList;
    }

    public Element getCertificateValues() {
        return DomUtils.getElement((Node)this.signatureElement, (String)this.xadesPaths.getCertificateValuesPath());
    }

    public Element getRevocationValues() {
        return DomUtils.getElement((Node)this.signatureElement, (String)this.xadesPaths.getRevocationValuesPath());
    }

    public boolean hasBProfile() {
        return DomUtils.isNotEmpty((Node)this.signatureElement, (String)this.xadesPaths.getSignedSignaturePropertiesPath());
    }

    public boolean hasTProfile() {
        if (BDocTmSupport.hasBDocTmPolicyId(this.signatureElement, this.xadesPaths)) {
            boolean hasOcspResponse = Utils.isStringNotBlank((String)DomUtils.getValue((Node)this.signatureElement, (String)(this.xadesPaths.getRevocationValuesPath() + this.xadesPaths.getCurrentEncapsulatedOCSPValue().substring(1))));
            return hasOcspResponse;
        }
        return super.hasTProfile();
    }

    public boolean hasCProfile() {
        boolean certRefs = DomUtils.isNotEmpty((Node)this.signatureElement, (String)this.xadesPaths.getCompleteCertificateRefsPath());
        boolean revocationRefs = DomUtils.isNotEmpty((Node)this.signatureElement, (String)this.xadesPaths.getCompleteRevocationRefsPath());
        return certRefs || revocationRefs;
    }

    public boolean hasXProfile() {
        return DomUtils.isNotEmpty((Node)this.signatureElement, (String)this.xadesPaths.getSigAndRefsTimestampPath());
    }

    public void checkSignatureIntegrity() {
        if (this.signatureCryptographicVerification != null) {
            return;
        }
        this.signatureCryptographicVerification = new SignatureCryptographicVerification();
        try {
            XMLSignature currentSantuarioSignature = this.getSantuarioSignature();
            boolean coreValidity = false;
            CandidatesForSigningCertificate candidates = this.getCandidatesForSigningCertificate();
            if (candidates.isEmpty()) {
                this.signatureCryptographicVerification.setErrorMessage("There is no signing certificate within the signature or certificate pool.");
            }
            List certificateValidityList = candidates.getCertificateValidityList();
            LOG.debug("Determining signing certificate from certificate candidates list...");
            ArrayList<String> preliminaryErrorMessages = new ArrayList<String>();
            int certificateNumber = 0;
            for (CertificateValidity certificateValidity : certificateValidityList) {
                String errorMessagePrefix = "Certificate #" + (certificateNumber + 1) + ": ";
                try {
                    PublicKey publicKey = certificateValidity.getPublicKey();
                    if (currentSantuarioSignature.checkSignatureValue((Key)publicKey)) {
                        LOG.debug("Public key matching the signature value found.");
                        coreValidity = true;
                        candidates.setTheCertificateValidity(certificateValidity);
                        if (certificateValidity.isValid()) {
                            LOG.info("Determining signing certificate from certificate candidates list succeeded : {}", (Object)certificateValidity.getCertificateToken().getDSSIdAsString());
                            break;
                        }
                        if (certificateValidity.getCertificateToken() != null) {
                            LOG.warn("The signing certificate candidate '{}' does not match a signing certificate reference!", (Object)certificateValidity.getCertificateToken().getDSSIdAsString());
                        }
                    } else {
                        preliminaryErrorMessages.add(errorMessagePrefix + "Signature verification failed");
                    }
                }
                catch (XMLSignatureException e) {
                    LOG.debug("Exception while probing candidate certificate as signing certificate: {}", (Object)e.getMessage());
                    preliminaryErrorMessages.add(errorMessagePrefix + e.getMessage());
                }
                catch (Exception e) {
                    LOG.error("Technical Exception : " + e.getMessage());
                }
                ++certificateNumber;
            }
            if (!coreValidity) {
                LOG.warn("Determining signing certificate from certificate candidates list failed: {}", preliminaryErrorMessages);
                for (String preliminaryErrorMessage : preliminaryErrorMessages) {
                    this.signatureCryptographicVerification.setErrorMessage(preliminaryErrorMessage);
                }
            }
            boolean allReferenceDataFound = true;
            boolean allReferenceDataIntact = true;
            List<ReferenceValidation> refValidations = this.getReferenceValidations();
            for (ReferenceValidation referenceValidation : refValidations) {
                allReferenceDataFound = allReferenceDataFound && referenceValidation.isFound();
                allReferenceDataIntact = allReferenceDataIntact && referenceValidation.isIntact();
            }
            this.signatureCryptographicVerification.setReferenceDataFound(allReferenceDataFound);
            this.signatureCryptographicVerification.setReferenceDataIntact(allReferenceDataIntact);
            this.signatureCryptographicVerification.setSignatureIntact(coreValidity);
        }
        catch (Exception e) {
            LOG.error("checkSignatureIntegrity : {}", (Object)e.getMessage());
            LOG.debug("checkSignatureIntegrity : {}", (Object)e.getMessage(), (Object)e);
            StackTraceElement[] stackTrace = e.getStackTrace();
            String name = XAdESSignature.class.getName();
            int lineNumber = 0;
            for (StackTraceElement element : stackTrace) {
                String className = element.getClassName();
                if (!className.equals(name)) continue;
                lineNumber = element.getLineNumber();
                break;
            }
            this.signatureCryptographicVerification.setErrorMessage(e.getMessage() + "/ XAdESSignature/Line number/" + lineNumber);
        }
    }

    private void extractReferences() {
        this.references = new ArrayList<Reference>();
        XMLSignature currentSantuarioSignature = this.getSantuarioSignature();
        SignedInfo signedInfo = currentSantuarioSignature.getSignedInfo();
        int numberOfReferences = signedInfo.getLength();
        for (int ii = 0; ii < numberOfReferences; ++ii) {
            try {
                Reference reference = signedInfo.item(ii);
                this.references.add(reference);
                continue;
            }
            catch (XMLSecurityException e) {
                LOG.warn("Unable to retrieve reference #{} : {}", (Object)ii, (Object)e.getMessage());
            }
        }
    }

    public List<ReferenceValidation> getReferenceValidations() {
        if (this.referenceValidations == null) {
            this.referenceValidations = new ArrayList<ReferenceValidation>();
            XMLSignature currentSantuarioSignature = this.getSantuarioSignature();
            boolean atLeastOneReferenceElementFound = false;
            List<Reference> santuarioReferences = this.getReferences();
            for (Reference reference : santuarioReferences) {
                XAdESReferenceValidation validation = new XAdESReferenceValidation(reference);
                validation.setType(DigestMatcherType.REFERENCE);
                boolean found = false;
                boolean intact = false;
                try {
                    boolean isElementReference;
                    block22: {
                        Digest digest = new Digest();
                        digest.setValue(reference.getDigestValue());
                        digest.setAlgorithm(DigestAlgorithm.forXML((String)reference.getMessageDigestAlgorithm().getAlgorithmURI()));
                        validation.setDigest(digest);
                        try {
                            found = reference.getContentsBeforeTransformation() != null;
                        }
                        catch (ReferenceNotInitializedException e) {
                            if (!LOG.isDebugEnabled()) break block22;
                            LOG.debug(String.format("Cannot get the pointed bytes by a reference with uri='%s'. Reason : [%s]", reference.getURI(), e.getMessage()));
                        }
                    }
                    String uri = validation.getUri();
                    boolean noDuplicateIdFound = true;
                    if (Utils.isStringNotEmpty((String)uri)) {
                        noDuplicateIdFound = XMLUtils.protectAgainstWrappingAttack((Node)currentSantuarioSignature.getDocument(), (String)DomUtils.getId((String)uri));
                    }
                    if ((isElementReference = DomUtils.isElementReference((String)uri)) && DSSXMLUtils.isSignedProperties(reference, this.xadesPaths)) {
                        validation.setType(DigestMatcherType.SIGNED_PROPERTIES);
                        found = found && noDuplicateIdFound && (this.disableXSWProtection || this.findSignedPropertiesById(uri));
                    } else if (DomUtils.isXPointerQuery((String)uri)) {
                        validation.setType(DigestMatcherType.XPOINTER);
                        found = found && noDuplicateIdFound;
                    } else if (isElementReference && DSSXMLUtils.isKeyInfoReference(reference, currentSantuarioSignature.getElement())) {
                        validation.setType(DigestMatcherType.KEY_INFO);
                        found = true;
                    } else if (isElementReference && reference.typeIsReferenceToObject()) {
                        validation.setType(DigestMatcherType.OBJECT);
                        found = found && noDuplicateIdFound && (this.disableXSWProtection || this.findObjectById(uri));
                    } else if (isElementReference && reference.typeIsReferenceToManifest()) {
                        validation.setType(DigestMatcherType.MANIFEST);
                        Node manifestNode = this.getManifestById(uri);
                        boolean bl = found = found && noDuplicateIdFound && (this.disableXSWProtection || manifestNode != null);
                        if (manifestNode != null) {
                            validation.getDependentValidations().addAll(this.getManifestReferences(manifestNode));
                        }
                    } else {
                        boolean bl = found = found && noDuplicateIdFound;
                    }
                    if (found) {
                        intact = reference.verify();
                    }
                }
                catch (Exception e) {
                    LOG.warn("Unable to verify reference with Id [{}] : {}", new Object[]{reference.getId(), e.getMessage(), e});
                }
                if (DigestMatcherType.REFERENCE.equals((Object)validation.getType()) || DigestMatcherType.OBJECT.equals((Object)validation.getType()) || DigestMatcherType.MANIFEST.equals((Object)validation.getType()) || DigestMatcherType.XPOINTER.equals((Object)validation.getType())) {
                    atLeastOneReferenceElementFound = true;
                }
                validation.setFound(found);
                validation.setIntact(intact);
                this.referenceValidations.add(validation);
            }
            if (!atLeastOneReferenceElementFound) {
                this.referenceValidations.add(this.notFound(DigestMatcherType.REFERENCE));
            }
            if (this.referenceValidations.size() < santuarioReferences.size()) {
                LOG.warn("Not all references were validated!");
            }
        }
        return this.referenceValidations;
    }

    public SignatureDigestReference getSignatureDigestReference(DigestAlgorithm digestAlgorithm) {
        byte[] signatureElementBytes = DSSXMLUtils.canonicalizeSubtree(DEFAULT_CANONICALIZATION_METHOD, this.signatureElement);
        byte[] digestValue = DSSUtils.digest((DigestAlgorithm)digestAlgorithm, (byte[])signatureElementBytes);
        return new SignatureDigestReference(DEFAULT_CANONICALIZATION_METHOD, new Digest(digestAlgorithm, digestValue));
    }

    public List<ReferenceValidation> getManifestReferences(Node manifestNode) {
        ManifestValidator mv = new ManifestValidator(this.signatureElement, manifestNode, this.detachedContents);
        return mv.validate();
    }

    private boolean findSignedPropertiesById(String uri) {
        return this.getSignedPropertiesById(uri) != null;
    }

    private Node getSignedPropertiesById(String uri) {
        if (Utils.isStringNotBlank((String)uri)) {
            String signedPropertiesById = this.xadesPaths.getSignedPropertiesPath() + DomUtils.getXPathByIdAttribute((String)uri);
            return DomUtils.getNode((Node)this.signatureElement, (String)signedPropertiesById);
        }
        return null;
    }

    private boolean findObjectById(String uri) {
        return this.getObjectById(uri) != null;
    }

    public Node getObjectById(String uri) {
        if (Utils.isStringNotBlank((String)uri)) {
            String objectById = XMLDSigPaths.OBJECT_PATH + DomUtils.getXPathByIdAttribute((String)uri);
            return DomUtils.getNode((Node)this.signatureElement, (String)objectById);
        }
        return null;
    }

    public Node getManifestById(String uri) {
        if (Utils.isStringNotBlank((String)uri)) {
            String manifestById = XMLDSigPaths.MANIFEST_PATH + DomUtils.getXPathByIdAttribute((String)uri);
            return DomUtils.getNode((Node)this.signatureElement, (String)manifestById);
        }
        return null;
    }

    private ReferenceValidation notFound(DigestMatcherType type) {
        ReferenceValidation validation = new ReferenceValidation();
        validation.setType(type);
        validation.setFound(false);
        return validation;
    }

    private XMLSignature getSantuarioSignature() {
        if (this.santuarioSignature != null) {
            return this.santuarioSignature;
        }
        try {
            Document document = this.signatureElement.getOwnerDocument();
            Element rootElement = document.getDocumentElement();
            DSSXMLUtils.setIDIdentifier(rootElement);
            DSSXMLUtils.recursiveIdBrowse(rootElement);
            this.santuarioSignature = new XMLSignature(this.signatureElement, "", false);
            if (Utils.isCollectionNotEmpty((Collection)this.detachedContents)) {
                this.initDetachedSignatureResolvers(this.detachedContents);
            }
            return this.santuarioSignature;
        }
        catch (XMLSecurityException e) {
            throw new DSSException("Unable to initialize santuario XMLSignature", (Throwable)e);
        }
    }

    private void initDetachedSignatureResolvers(List<DSSDocument> detachedContents) {
        List<Reference> currentReferences = this.getReferences();
        for (Reference reference : currentReferences) {
            try {
                DigestAlgorithm digestAlgorithm = DigestAlgorithm.forXML((String)reference.getMessageDigestAlgorithm().getAlgorithmURI());
                this.santuarioSignature.addResourceResolver((ResourceResolverSpi)new DetachedSignatureResolver(detachedContents, digestAlgorithm));
            }
            catch (XMLSignatureException e) {
                LOG.warn("Unable to retrieve reference digest algorithm {}", (Object)reference.getId(), (Object)e);
            }
        }
    }

    public List<AdvancedSignature> getCounterSignatures() {
        ArrayList<AdvancedSignature> xadesList = new ArrayList<AdvancedSignature>();
        NodeList counterSignatures = DomUtils.getNodeList((Node)this.signatureElement, (String)this.xadesPaths.getCounterSignaturePath());
        if (counterSignatures != null && counterSignatures.getLength() > 0) {
            for (int ii = 0; ii < counterSignatures.getLength(); ++ii) {
                Element currentCounterSignatureElement = (Element)counterSignatures.item(ii);
                NodeList counterSignaturesList = DomUtils.getNodeList((Node)currentCounterSignatureElement, (String)XMLDSigPaths.SIGNATURE_PATH);
                if (counterSignaturesList == null || counterSignaturesList.getLength() <= 0) continue;
                for (int jj = 0; jj < counterSignaturesList.getLength(); ++jj) {
                    XAdESSignature xadesCounterSignature = new XAdESSignature((Element)counterSignaturesList.item(jj), this.xadesPathsHolders);
                    if (!this.isCounterSignature(xadesCounterSignature)) continue;
                    xadesCounterSignature.setMasterSignature((AdvancedSignature)this);
                    xadesList.add((AdvancedSignature)xadesCounterSignature);
                }
            }
        }
        return xadesList;
    }

    private boolean isCounterSignature(XAdESSignature xadesCounterSignature) {
        List<Reference> references = xadesCounterSignature.getReferences();
        for (Reference reference : references) {
            if (!DSSXMLUtils.isCounterSignature(reference, this.xadesPaths)) continue;
            return true;
        }
        return false;
    }

    protected SignatureIdentifier buildSignatureIdentifier() {
        return new XAdESSignatureIdentifier(this);
    }

    public String getDAIdentifier() {
        if (this.daIdentifier == null) {
            this.daIdentifier = DSSXMLUtils.getIDIdentifier(this.signatureElement);
        }
        return this.daIdentifier;
    }

    public List<String> getUnsignedSignatureProperties() {
        return DomUtils.getChildrenNames((Node)this.signatureElement, (String)this.xadesPaths.getUnsignedSignaturePropertiesPath());
    }

    public List<String> getSignedSignatureProperties() {
        return DomUtils.getChildrenNames((Node)this.signatureElement, (String)this.xadesPaths.getSignedSignaturePropertiesPath());
    }

    public List<String> getSignedProperties() {
        return DomUtils.getChildrenNames((Node)this.signatureElement, (String)this.xadesPaths.getSignedPropertiesPath());
    }

    public List<String> getUnsignedProperties() {
        return DomUtils.getChildrenNames((Node)this.signatureElement, (String)this.xadesPaths.getUnsignedPropertiesPath());
    }

    public List<String> getSignedDataObjectProperties() {
        return DomUtils.getChildrenNames((Node)this.signatureElement, (String)this.xadesPaths.getSignedDataObjectPropertiesPath());
    }

    public SignatureLevel getDataFoundUpToLevel() {
        if (!this.hasBProfile()) {
            return SignatureLevel.XML_NOT_ETSI;
        }
        if (!this.hasTProfile()) {
            return SignatureLevel.XAdES_BASELINE_B;
        }
        if (this.hasLTProfile()) {
            if (this.hasLTAProfile()) {
                return SignatureLevel.XAdES_BASELINE_LTA;
            }
            return SignatureLevel.XAdES_BASELINE_LT;
        }
        if (this.hasCProfile()) {
            if (this.hasXProfile()) {
                return SignatureLevel.XAdES_X;
            }
            return SignatureLevel.XAdES_C;
        }
        return SignatureLevel.XAdES_BASELINE_T;
    }

    public SignatureLevel[] getSignatureLevels() {
        return signatureLevels;
    }

    public void validateStructure() {
        this.structureValidation = DSSXMLUtils.validateAgainstXSD(this.xadesPaths.getXSDUtils(), new DOMSource(this.signatureElement));
    }

    public Element getLastTimestampValidationData() {
        Element unsignedSignatureElement;
        String nodeName;
        NodeList nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)(this.xadesPaths.getUnsignedSignaturePropertiesPath() + "/*"));
        if (nodeList.getLength() > 0 && XAdES141Element.TIMESTAMP_VALIDATION_DATA.isSameTagName(nodeName = (unsignedSignatureElement = (Element)nodeList.item(nodeList.getLength() - 1)).getLocalName())) {
            return unsignedSignatureElement;
        }
        return null;
    }

    public List<CommitmentTypeIndication> getCommitmentTypeIndications() {
        ArrayList<CommitmentTypeIndication> result = null;
        NodeList nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)this.xadesPaths.getCommitmentTypeIndicationPath());
        if (nodeList != null && nodeList.getLength() > 0) {
            result = new ArrayList<CommitmentTypeIndication>();
            for (int ii = 0; ii < nodeList.getLength(); ++ii) {
                Element docRefsNode;
                Node commitmentTypeIndicationNode = nodeList.item(ii);
                String uri = DomUtils.getValue((Node)commitmentTypeIndicationNode, (String)this.xadesPaths.getCurrentCommitmentIdentifierPath());
                if (uri == null) {
                    LOG.warn("The Identifier for a CommitmentTypeIndication is not defined! The CommitmentType is skipped.");
                    continue;
                }
                CommitmentTypeIndication commitmentTypeIndication = new CommitmentTypeIndication(uri);
                Element descriptionNode = DomUtils.getElement((Node)commitmentTypeIndicationNode, (String)this.xadesPaths.getCurrentCommitmentDescriptionPath());
                if (descriptionNode != null) {
                    commitmentTypeIndication.setDescription(descriptionNode.getTextContent());
                }
                if ((docRefsNode = DomUtils.getElement((Node)commitmentTypeIndicationNode, (String)this.xadesPaths.getCurrentCommitmentDocumentationReferencesPath())) != null) {
                    commitmentTypeIndication.setDocumentReferences(this.getDocumentationReferences(docRefsNode));
                }
                result.add(commitmentTypeIndication);
            }
        }
        return result;
    }

    private List<String> getDocumentationReferences(Element docRefsNode) {
        NodeList docRefsChildNodes = DomUtils.getNodeList((Node)docRefsNode, (String)this.xadesPaths.getCurrentDocumentationReference());
        if (docRefsChildNodes.getLength() > 0) {
            ArrayList<String> docRefs = new ArrayList<String>();
            for (int jj = 0; jj < docRefsChildNodes.getLength(); ++jj) {
                Node docRefNode = docRefsChildNodes.item(jj);
                docRefs.add(docRefNode.getTextContent());
            }
            return docRefs;
        }
        return null;
    }

    public List<Reference> getReferences() {
        if (this.references == null) {
            this.extractReferences();
        }
        return this.references;
    }

    public List<Element> getSignatureObjects() {
        NodeList list = DomUtils.getNodeList((Node)this.signatureElement, (String)XMLDSigPaths.OBJECT_PATH);
        ArrayList<Element> references = new ArrayList<Element>(list.getLength());
        for (int ii = 0; ii < list.getLength(); ++ii) {
            Node node = list.item(ii);
            Element element = (Element)node;
            if (DomUtils.getElement((Node)element, (String)this.xadesPaths.getSignedPropertiesPath()) != null) continue;
            references.add(element);
        }
        return references;
    }

    public void registerXAdESPaths(XAdESPaths xadesPaths) {
        this.xadesPathsHolders.add(xadesPaths);
    }

    static {
        SantuarioInitializer.init();
        XAdESNamespaces.registerNamespaces();
        JCEMapper.Algorithm notStandardAlgorithm = new JCEMapper.Algorithm("", SignatureAlgorithm.RSA_RIPEMD160.getJCEId(), "Signature");
        JCEMapper.register((String)"http://www.w3.org/2001/04/xmldsig-more/rsa-ripemd160", (JCEMapper.Algorithm)notStandardAlgorithm);
        try {
            org.apache.xml.security.algorithms.SignatureAlgorithm.register((String)"http://www.w3.org/2001/04/xmldsig-more/rsa-ripemd160", SignatureRSARIPEMD160AT.class);
        }
        catch (Exception e) {
            LOG.error("ECDSA_RIPEMD160AT algorithm initialisation failed.", (Throwable)e);
        }
    }
}

