/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.validation.ValidationDataForInclusion;
import eu.europa.esig.dss.xades.signature.XAdESLevelBaselineT;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;

public class XAdESLevelBaselineLT
extends XAdESLevelBaselineT
implements Serializable {
    public XAdESLevelBaselineLT(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    @Override
    protected void extendSignatureTag() throws DSSException {
        super.extendSignatureTag();
        if (this.xadesSignature.hasLTAProfile()) {
            return;
        }
        this.xadesSignature.resetCertificateSource();
        this.xadesSignature.resetRevocationSources();
        this.xadesSignature.resetTimestampSource();
        this.assertExtendSignatureToLTPossible();
        Element levelTUnsignedProperties = (Element)this.unsignedSignaturePropertiesDom.cloneNode(true);
        this.checkSignatureIntegrity();
        ValidationContext validationContext = this.xadesSignature.getSignatureValidationContext(this.certificateVerifier);
        String indent = this.removeOldCertificateValues();
        this.removeOldRevocationValues();
        ValidationDataForInclusion validationDataForInclusion = this.getValidationDataForInclusion(validationContext);
        Set certificateValuesToAdd = validationDataForInclusion.getCertificateTokens();
        List crlsToAdd = validationDataForInclusion.getCrlTokens();
        List ocspsToAdd = validationDataForInclusion.getOcspTokens();
        this.incorporateCertificateValues(this.unsignedSignaturePropertiesDom, certificateValuesToAdd, indent);
        this.incorporateRevocationValues(this.unsignedSignaturePropertiesDom, crlsToAdd, ocspsToAdd, indent);
        this.unsignedSignaturePropertiesDom = this.indentIfPrettyPrint(this.unsignedSignaturePropertiesDom, levelTUnsignedProperties);
    }

    protected void checkSignatureIntegrity() throws DSSException {
        SignatureCryptographicVerification signatureCryptographicVerification = this.xadesSignature.getSignatureCryptographicVerification();
        if (!signatureCryptographicVerification.isSignatureIntact()) {
            String errorMessage = signatureCryptographicVerification.getErrorMessage();
            throw new DSSException("Cryptographic signature verification has failed" + (errorMessage.isEmpty() ? "." : " / " + errorMessage));
        }
    }

    private String removeOldCertificateValues() {
        String text = null;
        Element toRemove = this.xadesSignature.getCertificateValues();
        if (toRemove != null) {
            text = this.removeChild(this.unsignedSignaturePropertiesDom, toRemove);
            this.xadesSignature.resetCertificateSource();
        }
        return text;
    }

    private void removeOldRevocationValues() {
        Element toRemove = this.xadesSignature.getRevocationValues();
        if (toRemove != null) {
            this.removeChild(this.unsignedSignaturePropertiesDom, toRemove);
            this.xadesSignature.resetRevocationSources();
        }
    }

    private void assertExtendSignatureToLTPossible() {
        SignatureLevel signatureLevel = this.params.getSignatureLevel();
        if (SignatureLevel.XAdES_BASELINE_LT.equals((Object)signatureLevel) && this.xadesSignature.hasLTAProfile()) {
            String exceptionMessage = "Cannot extend the signature. The signedData is already extended with [%s]!";
            throw new DSSException(String.format("Cannot extend the signature. The signedData is already extended with [%s]!", "XAdES LTA"));
        }
        if (this.xadesSignature.areAllSelfSignedCertificates()) {
            throw new DSSException("Cannot extend the signature. The signature contains only self-signed certificate chains!");
        }
    }
}

