/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.definition.DSSElement;
import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigAttribute;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigElement;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.ProfileParameters;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.definition.XAdESElement;
import eu.europa.esig.dss.xades.definition.XAdESNamespaces;
import eu.europa.esig.dss.xades.definition.XAdESPaths;
import eu.europa.esig.dss.xades.definition.xades111.XAdES111Element;
import eu.europa.esig.dss.xades.definition.xades111.XAdES111Paths;
import eu.europa.esig.dss.xades.definition.xades122.XAdES122Element;
import eu.europa.esig.dss.xades.definition.xades122.XAdES122Paths;
import eu.europa.esig.dss.xades.definition.xades132.XAdES132Element;
import eu.europa.esig.dss.xades.definition.xades132.XAdES132Paths;
import eu.europa.esig.dss.xades.reference.CanonicalizationTransform;
import eu.europa.esig.dss.xades.reference.DSSReference;
import eu.europa.esig.dss.xades.reference.DSSTransform;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class XAdESBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESBuilder.class);
    public static final String REFERENCED_DATA = "referencedData";
    public static final String SIGNATURE = "Signature";
    public static final String TARGET = "Target";
    public static final String URI = "URI";
    protected XAdESPaths xadesPaths;
    protected XAdESSignatureParameters params;
    protected Document documentDom;
    protected CertificateVerifier certificateVerifier;

    public XAdESBuilder(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
    }

    protected void incorporateDigestMethod(Element parentDom, DigestAlgorithm digestAlgorithm) {
        Element digestMethodDom = DomUtils.addElement((Document)this.documentDom, (Element)parentDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.DIGEST_METHOD);
        digestMethodDom.setAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName(), digestAlgorithm.getUri());
    }

    protected void incorporateDigestValue(Element parentDom, DSSReference dssReference, DigestAlgorithm digestAlgorithm, DSSDocument originalDocument) {
        DSSTransform dssTransform;
        Element digestValueDom = DomUtils.createElementNS((Document)this.documentDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.DIGEST_VALUE);
        String base64EncodedDigestBytes = null;
        if (this.params.isManifestSignature()) {
            dssTransform = this.getUniqueCanonicalizationTransform(dssReference);
            Document doc = DomUtils.buildDOM((DSSDocument)originalDocument);
            byte[] bytes = dssTransform.getBytesAfterTranformation(doc, dssReference.getUri());
            base64EncodedDigestBytes = Utils.toBase64((byte[])DSSUtils.digest((DigestAlgorithm)digestAlgorithm, (byte[])bytes));
        } else if (this.params.isEmbedXML()) {
            dssTransform = this.getUniqueCanonicalizationTransform(dssReference);
            Document doc = DomUtils.buildDOM((DSSDocument)originalDocument);
            Element root = doc.getDocumentElement();
            Document doc2 = DomUtils.buildDOM();
            Element dom = DomUtils.createElementNS((Document)doc2, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.OBJECT);
            Element dom2 = DomUtils.createElementNS((Document)doc2, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.OBJECT);
            doc2.appendChild(dom2);
            dom2.appendChild(dom);
            dom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), dssReference.getUri().substring(1));
            Node adopted = doc2.adoptNode(root);
            dom.appendChild(adopted);
            byte[] bytes = dssTransform.getBytesAfterTranformation(dom, dssReference.getUri());
            base64EncodedDigestBytes = Utils.toBase64((byte[])DSSUtils.digest((DigestAlgorithm)digestAlgorithm, (byte[])bytes));
        } else {
            base64EncodedDigestBytes = originalDocument.getDigest(digestAlgorithm);
        }
        LOG.trace("C14n Digest value {} --> {}", (Object)parentDom.getNodeName(), (Object)base64EncodedDigestBytes);
        Text textNode = this.documentDom.createTextNode(base64EncodedDigestBytes);
        digestValueDom.appendChild(textNode);
        parentDom.appendChild(digestValueDom);
    }

    private DSSTransform getUniqueCanonicalizationTransform(DSSReference dssReference) {
        List<DSSTransform> transforms = dssReference.getTransforms();
        if (Utils.collectionSize(transforms) != 1) {
            throw new DSSException("Only one transformation is supported");
        }
        DSSTransform dssTransform = transforms.get(0);
        if (!(dssTransform instanceof CanonicalizationTransform)) {
            throw new DSSException("Only canonicalization transform is allowed in the given use case");
        }
        return dssTransform;
    }

    protected void incorporateDigestValue(Element parentDom, DigestAlgorithm digestAlgorithm, Token token) {
        Element digestValueDom = null;
        digestValueDom = XAdESNamespaces.XADES_111.isSameUri(this.getXadesNamespace().getUri()) ? DomUtils.createElementNS((Document)this.documentDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)XAdES111Element.DIGEST_VALUE) : DomUtils.createElementNS((Document)this.documentDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.DIGEST_VALUE);
        String base64EncodedDigestBytes = Utils.toBase64((byte[])token.getDigest(digestAlgorithm));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Digest value {} --> {}", (Object)parentDom.getNodeName(), (Object)base64EncodedDigestBytes);
        }
        Text textNode = this.documentDom.createTextNode(base64EncodedDigestBytes);
        digestValueDom.appendChild(textNode);
        parentDom.appendChild(digestValueDom);
    }

    protected void incorporateCertificateRef(Element signingCertificateDom, Set<CertificateToken> certificates) {
        for (CertificateToken certificate : certificates) {
            Element certDom = this.incorporateCert(signingCertificateDom, certificate);
            this.incorporateIssuerV1(certDom, certificate);
        }
    }

    protected Element incorporateCert(Element parentDom, CertificateToken certificate) {
        Element certDom = DomUtils.addElement((Document)this.documentDom, (Element)parentDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementCert());
        Element certDigestDom = DomUtils.addElement((Document)this.documentDom, (Element)certDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementCertDigest());
        DigestAlgorithm signingCertificateDigestMethod = this.params.getSigningCertificateDigestMethod();
        Element digestMethodDom = null;
        digestMethodDom = XAdESNamespaces.XADES_111.isSameUri(this.getXadesNamespace().getUri()) ? DomUtils.addElement((Document)this.documentDom, (Element)certDigestDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)XAdES111Element.DIGEST_METHOD) : DomUtils.addElement((Document)this.documentDom, (Element)certDigestDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.DIGEST_METHOD);
        digestMethodDom.setAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName(), signingCertificateDigestMethod.getUri());
        this.incorporateDigestValue(certDigestDom, signingCertificateDigestMethod, (Token)certificate);
        return certDom;
    }

    protected void incorporateIssuerV1(Element parentDom, CertificateToken certificate) {
        Element issuerSerialDom = DomUtils.addElement((Document)this.documentDom, (Element)parentDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementIssuerSerial());
        Element x509IssuerNameDom = DomUtils.addElement((Document)this.documentDom, (Element)issuerSerialDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.X509_ISSUER_NAME);
        String issuerX500PrincipalName = certificate.getIssuerX500Principal().getName();
        DomUtils.setTextNode((Document)this.documentDom, (Element)x509IssuerNameDom, (String)issuerX500PrincipalName);
        Element x509SerialNumberDom = DomUtils.addElement((Document)this.documentDom, (Element)issuerSerialDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.X509_SERIAL_NUMBER);
        BigInteger serialNumber = certificate.getSerialNumber();
        String serialNumberString = serialNumber.toString();
        DomUtils.setTextNode((Document)this.documentDom, (Element)x509SerialNumberDom, (String)serialNumberString);
    }

    protected void incorporateIssuerV2(Element parentDom, CertificateToken certificate) {
        Element issuerSerialDom = DomUtils.addElement((Document)this.documentDom, (Element)parentDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementIssuerSerialV2());
        IssuerSerial issuerSerial = DSSASN1Utils.getIssuerSerial((CertificateToken)certificate);
        String issuerBase64 = Utils.toBase64((byte[])DSSASN1Utils.getDEREncoded((ASN1Encodable)issuerSerial));
        DomUtils.setTextNode((Document)this.documentDom, (Element)issuerSerialDom, (String)issuerBase64);
    }

    private List<String> getNotIndentedObjectIds() {
        ArrayList<String> ids = new ArrayList<String>();
        List<DSSReference> dssReferences = this.params.getReferences();
        if (dssReferences != null) {
            for (DSSReference reference : dssReferences) {
                if (!DSSXMLUtils.isObjectReferenceType(reference.getType())) continue;
                ids.add(DomUtils.getId((String)reference.getUri()));
            }
        }
        return ids;
    }

    protected DSSDocument createXmlDocument() {
        byte[] bytes;
        if (ProfileParameters.Operation.SIGNING.equals((Object)this.params.getContext().getOperationKind()) && this.params.isPrettyPrint()) {
            this.alignNodes();
            bytes = DSSXMLUtils.serializeNode(DSSXMLUtils.getDocWithIndentedSignatures(this.documentDom, this.params.getDeterministicId(), this.getNotIndentedObjectIds()));
        } else {
            bytes = DSSXMLUtils.serializeNode(this.documentDom);
        }
        InMemoryDocument inMemoryDocument = new InMemoryDocument(bytes);
        inMemoryDocument.setMimeType(MimeType.XML);
        return inMemoryDocument;
    }

    protected abstract void alignNodes();

    protected DSSNamespace getXmldsigNamespace() {
        DSSNamespace xmldsigNamespace = this.params.getXmldsigNamespace();
        if (xmldsigNamespace == null) {
            LOG.warn("Current XMLDSig namespace not found in the parameters (use the default XMLDSig)");
            xmldsigNamespace = XAdESNamespaces.XMLDSIG;
        }
        return xmldsigNamespace;
    }

    protected DSSNamespace getXadesNamespace() {
        DSSNamespace xadesNamespace = this.params.getXadesNamespace();
        if (xadesNamespace == null) {
            LOG.warn("Current XAdES namespace not found in the parameters (use the default XAdES 1.3.2)");
            xadesNamespace = XAdESNamespaces.XADES_132;
        }
        return xadesNamespace;
    }

    protected DSSNamespace getXades141Namespace() {
        DSSNamespace xades141Namespace = this.params.getXades141Namespace();
        if (xades141Namespace == null) {
            LOG.warn("Current XAdES 1.4.1 namespace not found in the parameters (use the default XAdES 1.4.1)");
            xades141Namespace = XAdESNamespaces.XADES_141;
        }
        return xades141Namespace;
    }

    protected XAdESElement getCurrentXAdESElements() {
        String xadesURI = this.getXadesNamespace().getUri();
        if (XAdESNamespaces.XADES_132.getUri().equals(xadesURI)) {
            return XAdES132Element.values()[0];
        }
        if (XAdESNamespaces.XADES_122.getUri().equals(xadesURI)) {
            return XAdES122Element.values()[0];
        }
        if (XAdESNamespaces.XADES_111.getUri().equals(xadesURI)) {
            return XAdES111Element.values()[0];
        }
        throw new DSSException("Unsupported URI : " + xadesURI);
    }

    protected XAdESPaths getCurrentXAdESPaths() {
        String xadesURI = this.getXadesNamespace().getUri();
        if (Utils.areStringsEqual((String)XAdESNamespaces.XADES_132.getUri(), (String)xadesURI)) {
            return new XAdES132Paths();
        }
        if (Utils.areStringsEqual((String)XAdESNamespaces.XADES_122.getUri(), (String)xadesURI)) {
            return new XAdES122Paths();
        }
        if (Utils.areStringsEqual((String)XAdESNamespaces.XADES_111.getUri(), (String)xadesURI)) {
            return new XAdES111Paths();
        }
        throw new DSSException("Unsupported URI : " + xadesURI);
    }
}

