/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.definition.DSSElement;
import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigAttribute;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigElement;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ManifestBuilder {
    private final String manifestId;
    private final DigestAlgorithm digestAlgorithm;
    private final List<DSSDocument> documents;
    private final DSSNamespace xmldsigNamespace;

    public ManifestBuilder(DigestAlgorithm digestAlgorithm, List<DSSDocument> documents) {
        this("manifest", digestAlgorithm, documents);
    }

    public ManifestBuilder(String manifestId, DigestAlgorithm digestAlgorithm, List<DSSDocument> documents) {
        this(manifestId, digestAlgorithm, documents, new DSSNamespace("http://www.w3.org/2000/09/xmldsig#", "ds"));
    }

    public ManifestBuilder(String manifestId, DigestAlgorithm digestAlgorithm, List<DSSDocument> documents, DSSNamespace xmldsigNamespace) {
        this.manifestId = manifestId;
        this.digestAlgorithm = digestAlgorithm;
        this.documents = documents;
        this.xmldsigNamespace = xmldsigNamespace;
    }

    public DSSDocument build() {
        Document documentDom = DomUtils.buildDOM();
        Element manifestDom = DomUtils.createElementNS((Document)documentDom, (DSSNamespace)this.xmldsigNamespace, (DSSElement)XMLDSigElement.MANIFEST);
        manifestDom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), this.manifestId);
        documentDom.appendChild(manifestDom);
        for (DSSDocument document : this.documents) {
            Element referenceDom = DomUtils.createElementNS((Document)documentDom, (DSSNamespace)this.xmldsigNamespace, (DSSElement)XMLDSigElement.REFERENCE);
            manifestDom.appendChild(referenceDom);
            referenceDom.setAttribute(XMLDSigAttribute.URI.getAttributeName(), document.getName());
            Element digestMethodDom = DomUtils.createElementNS((Document)documentDom, (DSSNamespace)this.xmldsigNamespace, (DSSElement)XMLDSigElement.DIGEST_METHOD);
            referenceDom.appendChild(digestMethodDom);
            digestMethodDom.setAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName(), this.digestAlgorithm.getUri());
            Element digestValueDom = DomUtils.createElementNS((Document)documentDom, (DSSNamespace)this.xmldsigNamespace, (DSSElement)XMLDSigElement.DIGEST_VALUE);
            referenceDom.appendChild(digestValueDom);
            Text textNode = documentDom.createTextNode(document.getDigest(this.digestAlgorithm));
            digestValueDom.appendChild(textNode);
        }
        return DomUtils.createDssDocumentFromDomDocument((Document)documentDom, (String)this.manifestId);
    }
}

