/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.definition.DSSElement;
import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.definition.XAdESNamespaces;
import eu.europa.esig.dss.xades.signature.XAdESBuilder;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ExtensionBuilder
extends XAdESBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionBuilder.class);
    protected XAdESSignature xadesSignature;
    protected Element currentSignatureDom;
    protected Element qualifyingPropertiesDom;
    protected Element unsignedPropertiesDom;
    protected Element unsignedSignaturePropertiesDom;

    protected ExtensionBuilder(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    protected void ensureUnsignedProperties() {
        NodeList qualifyingPropertiesNodeList = DomUtils.getNodeList((Node)this.currentSignatureDom, (String)this.xadesPaths.getQualifyingPropertiesPath());
        if (qualifyingPropertiesNodeList.getLength() != 1) {
            throw new DSSException("The signature does not contain QualifyingProperties element (or contains more than one)! Extension is not possible.");
        }
        this.qualifyingPropertiesDom = (Element)qualifyingPropertiesNodeList.item(0);
        NodeList unsignedPropertiesNodeList = DomUtils.getNodeList((Node)this.currentSignatureDom, (String)this.xadesPaths.getUnsignedPropertiesPath());
        int length = unsignedPropertiesNodeList.getLength();
        if (length == 1) {
            this.unsignedPropertiesDom = (Element)qualifyingPropertiesNodeList.item(0);
        } else if (length == 0) {
            this.unsignedPropertiesDom = DomUtils.addElement((Document)this.documentDom, (Element)this.qualifyingPropertiesDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementUnsignedProperties());
            if (this.params.isPrettyPrint()) {
                this.qualifyingPropertiesDom = (Element)DSSXMLUtils.alignChildrenIndents(this.qualifyingPropertiesDom);
                this.unsignedPropertiesDom = (Element)DomUtils.getNode((Node)this.currentSignatureDom, (String)this.xadesPaths.getUnsignedPropertiesPath());
            }
        } else {
            throw new DSSException("The signature contains more then one UnsignedProperties element! Extension is not possible.");
        }
    }

    protected void ensureUnsignedSignatureProperties() {
        NodeList unsignedSignaturePropertiesNodeList = DomUtils.getNodeList((Node)this.currentSignatureDom, (String)this.xadesPaths.getUnsignedSignaturePropertiesPath());
        int length = unsignedSignaturePropertiesNodeList.getLength();
        if (length == 1) {
            this.unsignedSignaturePropertiesDom = (Element)unsignedSignaturePropertiesNodeList.item(0);
        } else if (length == 0) {
            this.unsignedSignaturePropertiesDom = DomUtils.addElement((Document)this.documentDom, (Element)this.unsignedPropertiesDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementUnsignedSignatureProperties());
            if (this.params.isPrettyPrint()) {
                this.unsignedPropertiesDom = (Element)DSSXMLUtils.indentAndReplace(this.documentDom, this.unsignedPropertiesDom);
                this.unsignedSignaturePropertiesDom = (Element)DomUtils.getNode((Node)this.currentSignatureDom, (String)this.xadesPaths.getUnsignedSignaturePropertiesPath());
            }
        } else {
            throw new DSSException("The signature contains more then one UnsignedSignatureProperties element! Extension is not possible.");
        }
    }

    protected void ensureSignedDataObjectProperties() {
        NodeList signedDataObjectPropertiesNodeList = DomUtils.getNodeList((Node)this.currentSignatureDom, (String)this.xadesPaths.getSignedDataObjectPropertiesPath());
        int length = signedDataObjectPropertiesNodeList.getLength();
        if (length > 1) {
            throw new DSSException("The signature contains more than one SignedDataObjectProperties element! Extension is not possible.");
        }
    }

    protected void assertSignatureValid(XAdESSignature xadesSignature) {
        SignatureCryptographicVerification signatureCryptographicVerification = xadesSignature.getSignatureCryptographicVerification();
        if (!signatureCryptographicVerification.isSignatureIntact()) {
            String errorMessage = signatureCryptographicVerification.getErrorMessage();
            throw new DSSException("Cryptographic signature verification has failed" + (errorMessage.isEmpty() ? "." : " / " + errorMessage));
        }
    }

    protected Element indentIfPrettyPrint(Element nodeToIndent, Element oldNode) {
        if (this.params.isPrettyPrint()) {
            nodeToIndent = (Element)DSSXMLUtils.indentAndExtend(this.documentDom, nodeToIndent, oldNode);
        }
        return nodeToIndent;
    }

    @Override
    protected void alignNodes() {
        if (this.unsignedSignaturePropertiesDom != null) {
            DSSXMLUtils.alignChildrenIndents(this.unsignedSignaturePropertiesDom);
        }
        if (this.qualifyingPropertiesDom != null) {
            DSSXMLUtils.alignChildrenIndents(this.qualifyingPropertiesDom);
        }
    }

    protected String removeChild(Node parentNode, Node nodeToRemove) {
        String text = null;
        if (nodeToRemove != null) {
            Node nextSibling = nodeToRemove.getNextSibling();
            if (nextSibling != null && 3 == nextSibling.getNodeType()) {
                text = nextSibling.getNodeValue();
                this.unsignedSignaturePropertiesDom.removeChild(nextSibling);
            }
            this.unsignedSignaturePropertiesDom.removeChild(nodeToRemove);
        }
        return text;
    }

    @Override
    protected DSSNamespace getXmldsigNamespace() {
        DSSNamespace xmldsigNamespace = this.xadesSignature.getXmldSigNamespace();
        if (xmldsigNamespace == null) {
            LOG.warn("Current XMLDSig namespace not found in the signature");
            xmldsigNamespace = this.params.getXmldsigNamespace();
            if (xmldsigNamespace == null) {
                LOG.warn("Current XMLDSig namespace not found in the parameters (use the default XMLDSig)");
                xmldsigNamespace = XAdESNamespaces.XMLDSIG;
            }
        }
        return xmldsigNamespace;
    }

    @Override
    protected DSSNamespace getXadesNamespace() {
        DSSNamespace xadesNamespace = this.xadesSignature.getXadesNamespace();
        if (xadesNamespace == null) {
            LOG.warn("Current XAdES namespace not found in the signature");
            xadesNamespace = this.params.getXadesNamespace();
            if (xadesNamespace == null) {
                LOG.warn("Current XAdES namespace not found in the parameters (use the default XAdES 1.3.2)");
                xadesNamespace = XAdESNamespaces.XADES_132;
            }
        }
        return xadesNamespace;
    }
}

