/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.reference.DSSReference;
import eu.europa.esig.dss.xades.signature.XAdESSignatureBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class DetachedSignatureBuilder
extends XAdESSignatureBuilder {
    public DetachedSignatureBuilder(XAdESSignatureParameters params, DSSDocument origDoc, CertificateVerifier certificateVerifier) {
        super(params, origDoc, certificateVerifier);
    }

    @Override
    protected Document buildRootDocumentDom() {
        if (this.params.getRootDocument() != null) {
            return this.params.getRootDocument();
        }
        return DomUtils.buildDOM();
    }

    @Override
    protected Node getParentNodeOfSignature() {
        if (this.params.getRootDocument() != null) {
            return this.documentDom.getDocumentElement();
        }
        return this.documentDom;
    }

    @Override
    protected DSSReference createReference(DSSDocument document, int referenceIndex) {
        DSSReference reference = new DSSReference();
        reference.setId("r-" + this.deterministicId + "-" + referenceIndex);
        if (Utils.isStringNotEmpty((String)document.getName())) {
            reference.setUri(DSSUtils.encodeURI((String)document.getName()));
        }
        reference.setContents(document);
        DigestAlgorithm digestAlgorithm = this.getReferenceDigestAlgorithmOrDefault(this.params);
        reference.setDigestMethodAlgorithm(digestAlgorithm);
        return reference;
    }

    @Override
    protected DSSDocument transformReference(DSSReference reference) {
        if (Utils.isCollectionNotEmpty(reference.getTransforms())) {
            DSSDocument contents = reference.getContents();
            Document dom = DomUtils.buildDOM((DSSDocument)contents);
            Element root = dom.getDocumentElement();
            return new InMemoryDocument(this.applyTransformations(reference, root));
        }
        return reference.getContents();
    }
}

