/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.validation.SignatureScope;
import java.util.List;

public class XmlElementSignatureScope
extends SignatureScope {
    private final List<String> transformations;

    protected XmlElementSignatureScope(String xmlId, List<String> transformations) {
        super(xmlId);
        this.transformations = transformations;
    }

    public String getDescription() {
        String description = "The XML element with ID '" + this.getName() + "'";
        if (this.transformations.isEmpty()) {
            return description;
        }
        return this.addTransformationDescription(description);
    }

    protected String addTransformationDescription(String description) {
        StringBuilder result = new StringBuilder();
        result.append(description).append(" with transformations: ");
        for (String transformation : this.transformations) {
            result.append(transformation).append("; ");
        }
        result.delete(result.length() - 2, result.length()).append('.');
        return result.toString();
    }

    protected List<String> getTransformations() {
        return this.transformations;
    }
}

