/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.XAdESNamespaces;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.FullSignatureScope;
import eu.europa.esig.dss.validation.SignatureScope;
import eu.europa.esig.dss.validation.SignatureScopeFinder;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.XPointerSignatureScope;
import eu.europa.esig.dss.xades.validation.XmlElementSignatureScope;
import eu.europa.esig.dss.xades.validation.XmlRootSignatureScope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.transforms.Transforms;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESSignatureScopeFinder
implements SignatureScopeFinder<XAdESSignature> {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESSignatureScopeFinder.class);
    private static final String XP_OPEN = "xpointer(";
    private static final String XNS_OPEN = "xmlns(";
    private final List<String> transformationToIgnore = new ArrayList<String>();
    private final Map<String, String> presentableTransformationNames = new HashMap<String, String>();

    public XAdESSignatureScopeFinder() {
        this.transformationToIgnore.add("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        this.transformationToIgnore.add("http://www.w3.org/2000/09/xmldsig#base64");
        this.transformationToIgnore.add("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        this.transformationToIgnore.add("http://www.w3.org/2006/12/xml-c14n11#WithComments");
        this.transformationToIgnore.add("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        this.presentableTransformationNames.put("http://www.w3.org/2002/06/xmldsig-filter2", "XPath filtering");
        this.presentableTransformationNames.put("http://www.w3.org/TR/1999/REC-xpath-19991116", "XPath filtering");
        this.presentableTransformationNames.put("http://www.w3.org/TR/1999/REC-xslt-19991116", "XSLT Transform");
        this.presentableTransformationNames.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "Canonical XML 1.0 (omits comments)");
        this.presentableTransformationNames.put("http://www.w3.org/2006/12/xml-c14n11", "Canonical XML 1.1 (omits comments)");
        this.presentableTransformationNames.put("http://www.w3.org/2001/10/xml-exc-c14n#", "Exclusive Canonical XML (omits comments)");
    }

    public List<SignatureScope> findSignatureScope(XAdESSignature xadesSignature) {
        ArrayList<SignatureScope> result = new ArrayList<SignatureScope>();
        List<Reference> references = xadesSignature.getReferences();
        boolean isEverythingCovered = this.isEverythingCovered(xadesSignature);
        for (Reference signatureReference : references) {
            if (this.isSignedProperties(xadesSignature, signatureReference.getType())) continue;
            String uri = signatureReference.getURI();
            List<String> transformations = this.getTransformationNames(signatureReference);
            if (Utils.isStringBlank((String)uri)) {
                if (isEverythingCovered) {
                    result.add(new XmlRootSignatureScope(transformations));
                    continue;
                }
                result.add(new XmlElementSignatureScope("", transformations));
                continue;
            }
            if (uri.startsWith("#")) {
                Node signedElement;
                String namespaceURI;
                String xmlIdOfSignedElement = uri.substring(1);
                if (this.isXPointerQuery(uri)) {
                    String id = DSSXMLUtils.getIDIdentifier(signatureReference.getElement());
                    XPointerSignatureScope xPointerSignatureScope = new XPointerSignatureScope(id, uri);
                    result.add(xPointerSignatureScope);
                    continue;
                }
                if (signatureReference.typeIsReferenceToObject()) {
                    Node objectById = xadesSignature.getObjectById(uri);
                    if (objectById == null) continue;
                    result.add(new XmlElementSignatureScope(xmlIdOfSignedElement, transformations));
                    continue;
                }
                if (signatureReference.typeIsReferenceToManifest()) {
                    Node manifestById = xadesSignature.getManifestById(uri);
                    if (manifestById == null) continue;
                    result.add(new XmlElementSignatureScope(xmlIdOfSignedElement, transformations));
                    continue;
                }
                NodeList nodeList = DomUtils.getNodeList((Node)xadesSignature.getSignatureElement().getOwnerDocument().getDocumentElement(), (String)("//*" + DomUtils.getXPathByIdAttribute((String)uri)));
                if (nodeList == null || nodeList.getLength() != 1 || (namespaceURI = (signedElement = nodeList.item(0)).getNamespaceURI()) != null && (XAdESNamespaces.exists((String)namespaceURI) || namespaceURI.equals("http://www.w3.org/2000/09/xmldsig#"))) continue;
                if (isEverythingCovered) {
                    result.add(new XmlRootSignatureScope(transformations));
                    continue;
                }
                result.add(new XmlElementSignatureScope(xmlIdOfSignedElement, transformations));
                continue;
            }
            result.add((SignatureScope)new FullSignatureScope(DSSUtils.decodeUrl((String)uri)));
        }
        return result;
    }

    private List<String> getTransformationNames(Reference reference) {
        ArrayList<String> algorithms = new ArrayList<String>();
        try {
            Element transformsElement;
            NodeList transfromChildNodes;
            Transforms transforms = reference.getTransforms();
            if (transforms != null && (transfromChildNodes = (transformsElement = transforms.getElement()).getChildNodes()) != null && transfromChildNodes.getLength() > 0) {
                for (int i = 0; i < transfromChildNodes.getLength(); ++i) {
                    Node transformation = transfromChildNodes.item(i);
                    String algorithm = DomUtils.getValue((Node)transformation, (String)"@Algorithm");
                    if (this.transformationToIgnore.contains(algorithm)) continue;
                    if (this.presentableTransformationNames.containsKey(algorithm)) {
                        algorithms.add(this.presentableTransformationNames.get(algorithm));
                        continue;
                    }
                    algorithms.add(algorithm);
                }
            }
        }
        catch (XMLSecurityException e) {
            LOG.warn("Unable to analyze trasnformations", (Throwable)e);
        }
        return algorithms;
    }

    private boolean isXPointerQuery(String uriValue) {
        int ii;
        if (uriValue.isEmpty() || uriValue.charAt(0) != '#') {
            return false;
        }
        String decodedUri = DSSUtils.decodeUrl((String)uriValue);
        if (decodedUri == null) {
            return false;
        }
        String[] parts = decodedUri.substring(1).split("\\s");
        for (ii = 0; ii < parts.length - 1; ++ii) {
            if (parts[ii].endsWith(")") && parts[ii].startsWith(XNS_OPEN)) continue;
            return false;
        }
        return parts[ii].endsWith(")") && parts[ii].startsWith(XP_OPEN);
    }

    private boolean isSignedProperties(XAdESSignature signature, String type) {
        return signature.getXPathQueryHolder().XADES_SIGNED_PROPERTIES.equals(type);
    }

    public boolean isEverythingCovered(XAdESSignature signature) {
        Element parent = signature.getSignatureElement().getOwnerDocument().getDocumentElement();
        return this.recursiveCheck(this.getIds(signature), parent);
    }

    private Set<String> getIds(XAdESSignature signature) {
        List<Reference> references = signature.getReferences();
        HashSet<String> result = new HashSet<String>();
        for (Reference reference : references) {
            if (reference.typeIsReferenceToManifest() || reference.typeIsReferenceToObject() || this.isSignedProperties(signature, reference.getType()) || this.isXPointerQuery(reference.getURI())) continue;
            result.add(DomUtils.getId((String)reference.getURI()));
        }
        return result;
    }

    private boolean recursiveCheck(Set<String> ids, Node currentNode) {
        if (currentNode != null) {
            if ("Signature".equals(currentNode.getLocalName()) || this.isRelatedToUri(currentNode, ids)) {
                return true;
            }
            NodeList childNodes = currentNode.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                if (1 != childNodes.item(i).getNodeType()) continue;
                return this.recursiveCheck(ids, childNodes.item(i));
            }
        }
        return false;
    }

    private boolean isRelatedToUri(Node currentNode, Set<String> ids) {
        String idValue = DSSXMLUtils.getIDIdentifier(currentNode);
        if (idValue == null) {
            return Utils.collectionSize(ids) == 1 && Utils.isStringBlank((String)ids.iterator().next());
        }
        return ids.contains(idValue) || ids.contains("");
    }
}

