/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DSSRevocationUtils;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.x509.ocsp.OfflineOCSPSource;
import eu.europa.esig.dss.xades.XPathQueryHolder;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESOCSPSource
extends OfflineOCSPSource {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESOCSPSource.class);
    private final Element signatureElement;
    private final XPathQueryHolder xPathQueryHolder;
    private List<BasicOCSPResp> containedOCSPResponses;

    public XAdESOCSPSource(Element signatureElement, XPathQueryHolder xPathQueryHolder) {
        this.signatureElement = signatureElement;
        this.xPathQueryHolder = xPathQueryHolder;
    }

    public List<BasicOCSPResp> getContainedOCSPResponses() {
        if (this.containedOCSPResponses == null) {
            this.containedOCSPResponses = new ArrayList<BasicOCSPResp>();
            this.containedOCSPResponses.addAll(this.getEncapsulatedOCSPValues());
            this.containedOCSPResponses.addAll(this.getTimestampEncapsulatedOCSPValues());
        }
        return this.containedOCSPResponses;
    }

    public List<BasicOCSPResp> getEncapsulatedOCSPValues() {
        return this.getOCSPValues(this.xPathQueryHolder.XPATH_OCSP_VALUES_ENCAPSULATED_OCSP);
    }

    public List<BasicOCSPResp> getTimestampEncapsulatedOCSPValues() {
        return this.getOCSPValues(this.xPathQueryHolder.XPATH_TSVD_ENCAPSULATED_OCSP_VALUE);
    }

    private List<BasicOCSPResp> getOCSPValues(String xPathQuery) {
        ArrayList<BasicOCSPResp> list = new ArrayList<BasicOCSPResp>();
        NodeList nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)xPathQuery);
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            Element certEl = (Element)nodeList.item(ii);
            try {
                list.add(DSSRevocationUtils.loadOCSPBase64Encoded((String)certEl.getTextContent()));
                continue;
            }
            catch (Exception e) {
                LOG.warn("Cannot retrieve OCSP response from '" + certEl.getTextContent() + "' : " + e.getMessage(), (Throwable)e);
            }
        }
        return list;
    }
}

