/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.MimeType;
import eu.europa.esig.dss.SignatureLevel;
import eu.europa.esig.dss.SignaturePackaging;
import eu.europa.esig.dss.TimestampParameters;
import eu.europa.esig.dss.XAdESNamespaces;
import eu.europa.esig.dss.signature.SignatureExtension;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.x509.CertificatePool;
import eu.europa.esig.dss.x509.CertificateSource;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.TimestampType;
import eu.europa.esig.dss.x509.tsp.TSPSource;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.ProfileParameters;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.signature.ExtensionBuilder;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import java.io.Serializable;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.tsp.TimeStampToken;
import org.digidoc4j.dss.xades.BDocTmSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XAdESLevelBaselineT
extends ExtensionBuilder
implements SignatureExtension<XAdESSignatureParameters>,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESLevelBaselineT.class);
    protected TSPSource tspSource;

    public XAdESLevelBaselineT(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    private void incorporateC14nMethod(Element parentDom, String signedInfoC14nMethod) {
        Element canonicalizationMethodDom = this.documentDom.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:CanonicalizationMethod");
        canonicalizationMethodDom.setAttribute("Algorithm", signedInfoC14nMethod);
        parentDom.appendChild(canonicalizationMethodDom);
    }

    public InMemoryDocument extendSignatures(DSSDocument dssDocument, XAdESSignatureParameters params) throws DSSException {
        if (dssDocument == null) {
            throw new NullPointerException();
        }
        if (this.tspSource == null) {
            throw new NullPointerException();
        }
        this.params = params;
        ProfileParameters context = params.getContext();
        if (LOG.isInfoEnabled()) {
            LOG.info("====> Extending: " + (dssDocument.getName() == null ? "IN MEMORY DOCUMENT" : dssDocument.getName()));
        }
        this.documentDom = DomUtils.buildDOM((DSSDocument)dssDocument);
        NodeList signatureNodeList = this.documentDom.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (signatureNodeList.getLength() == 0) {
            throw new DSSException("There is no signature to extend!");
        }
        String signatureId = null;
        SignaturePackaging signaturePackaging = params.getSignaturePackaging();
        ProfileParameters.Operation operationKind = context.getOperationKind();
        if (ProfileParameters.Operation.SIGNING.equals((Object)operationKind) && SignaturePackaging.ENVELOPED.equals((Object)signaturePackaging)) {
            signatureId = params.getDeterministicId();
        }
        for (int ii = 0; ii < signatureNodeList.getLength(); ++ii) {
            this.currentSignatureDom = (Element)signatureNodeList.item(ii);
            String currentSignatureId = this.currentSignatureDom.getAttribute("Id");
            if (signatureId != null && !signatureId.equals(currentSignatureId)) continue;
            CertificatePool certPool = new CertificatePool();
            this.xadesSignature = new XAdESSignature(this.currentSignatureDom, certPool);
            this.xadesSignature.setDetachedContents(params.getDetachedContents());
            this.extendSignatureTag();
        }
        byte[] documentBytes = DSSXMLUtils.serializeNode(this.documentDom);
        InMemoryDocument inMemoryDocument = new InMemoryDocument(documentBytes);
        inMemoryDocument.setMimeType(MimeType.XML);
        return inMemoryDocument;
    }

    protected void extendSignatureTag() throws DSSException {
        this.assertExtendSignaturePossible();
        this.ensureUnsignedProperties();
        this.ensureUnsignedSignatureProperties();
        this.ensureSignedDataObjectProperties();
        this.assertSignatureValid(this.xadesSignature);
        if (BDocTmSupport.isBdocTmSignatureProfile(this.params)) {
            return;
        }
        if (!this.xadesSignature.hasTProfile() || SignatureLevel.XAdES_BASELINE_T.equals((Object)this.params.getSignatureLevel())) {
            TimestampParameters signatureTimestampParameters = this.params.getSignatureTimestampParameters();
            String canonicalizationMethod = signatureTimestampParameters.getCanonicalizationMethod();
            byte[] canonicalisedValue = this.xadesSignature.getSignatureTimestampData(null, canonicalizationMethod);
            DigestAlgorithm timestampDigestAlgorithm = signatureTimestampParameters.getDigestAlgorithm();
            byte[] digestValue = DSSUtils.digest((DigestAlgorithm)timestampDigestAlgorithm, (byte[])canonicalisedValue);
            this.createXAdESTimeStampType(TimestampType.SIGNATURE_TIMESTAMP, canonicalizationMethod, digestValue);
        }
    }

    private void assertExtendSignaturePossible() throws DSSException {
        SignatureLevel signatureLevel = this.params.getSignatureLevel();
        if (SignatureLevel.XAdES_BASELINE_T.equals((Object)signatureLevel) && (this.xadesSignature.hasLTProfile() || this.xadesSignature.hasLTAProfile())) {
            String exceptionMessage = "Cannot extend signature. The signedData is already extended with [%s].";
            throw new DSSException(String.format("Cannot extend signature. The signedData is already extended with [%s].", "XAdES LT"));
        }
    }

    public void setTspSource(TSPSource tspSource) {
        this.tspSource = tspSource;
    }

    protected void incorporateCertificateValues(Element parentDom, ValidationContext validationContext) {
        Set toIncludeCertificates = this.xadesSignature.getCertificatesForInclusion(validationContext);
        if (!toIncludeCertificates.isEmpty()) {
            Element certificateValuesDom = DomUtils.addElement((Document)this.documentDom, (Element)parentDom, (String)XAdESNamespaces.XAdES, (String)"xades:CertificateValues");
            CertificateSource trustedCertSource = this.certificateVerifier.getTrustedCertSource();
            boolean trustAnchorBPPolicy = this.params.bLevel().isTrustAnchorBPPolicy();
            boolean trustAnchorIncluded = false;
            int responderCertCounter = 0;
            for (CertificateToken certificateToken : toIncludeCertificates) {
                boolean isCaCert;
                if (trustAnchorBPPolicy && trustedCertSource != null && !trustedCertSource.get(certificateToken.getSubjectX500Principal()).isEmpty()) {
                    trustAnchorIncluded = true;
                }
                byte[] bytes = certificateToken.getEncoded();
                String base64EncodeCertificate = Base64.encodeBase64String((byte[])bytes);
                Element element = DomUtils.addElement((Document)this.documentDom, (Element)certificateValuesDom, (String)XAdESNamespaces.XAdES, (String)"xades:EncapsulatedX509Certificate");
                boolean bl = isCaCert = certificateToken.getCertificate().getBasicConstraints() != -1;
                if (DSSASN1Utils.isOCSPSigning((CertificateToken)certificateToken) && !isCaCert) {
                    element.setAttribute("Id", this.xadesSignature.getId() + "-RESPONDER_CERT-" + responderCertCounter);
                    ++responderCertCounter;
                }
                DomUtils.setTextNode((Document)this.documentDom, (Element)element, (String)base64EncodeCertificate);
            }
            if (trustAnchorBPPolicy && !trustAnchorIncluded) {
                LOG.warn("The trust anchor is missing but its inclusion is required by the signature policy!");
            }
        }
    }

    protected void createXAdESTimeStampType(TimestampType timestampType, String timestampC14nMethod, byte[] digestValue) throws DSSException {
        Element timeStampDom = null;
        TimestampParameters signatureTimestampParameters = this.params.getSignatureTimestampParameters();
        DigestAlgorithm timestampDigestAlgorithm = signatureTimestampParameters.getDigestAlgorithm();
        switch (timestampType) {
            case SIGNATURE_TIMESTAMP: {
                timeStampDom = DomUtils.addElement((Document)this.documentDom, (Element)this.unsignedSignaturePropertiesDom, (String)XAdESNamespaces.XAdES, (String)"xades:SignatureTimeStamp");
                break;
            }
            case VALIDATION_DATA_REFSONLY_TIMESTAMP: {
                break;
            }
            case VALIDATION_DATA_TIMESTAMP: {
                if (this.params.isEn319132() && !SignatureLevel.XAdES_X.equals((Object)this.params.getSignatureLevel())) {
                    timeStampDom = DomUtils.addElement((Document)this.documentDom, (Element)this.unsignedSignaturePropertiesDom, (String)XAdESNamespaces.XAdES, (String)"xades:SigAndRefsTimeStampV2");
                    break;
                }
                timeStampDom = DomUtils.addElement((Document)this.documentDom, (Element)this.unsignedSignaturePropertiesDom, (String)XAdESNamespaces.XAdES, (String)"xades:SigAndRefsTimeStamp");
                break;
            }
            case ARCHIVE_TIMESTAMP: {
                timeStampDom = DomUtils.addElement((Document)this.documentDom, (Element)this.unsignedSignaturePropertiesDom, (String)"http://uri.etsi.org/01903/v1.4.1#", (String)"xades141:ArchiveTimeStamp");
                timestampDigestAlgorithm = this.params.getArchiveTimestampParameters().getDigestAlgorithm();
                break;
            }
            case ALL_DATA_OBJECTS_TIMESTAMP: {
                timeStampDom = DomUtils.addElement((Document)this.documentDom, (Element)this.signedDataObjectPropertiesDom, (String)XAdESNamespaces.XAdES, (String)"xades:AllDataObjectsTimeStamp");
                break;
            }
            case INDIVIDUAL_DATA_OBJECTS_TIMESTAMP: {
                timeStampDom = DomUtils.addElement((Document)this.documentDom, (Element)this.signedDataObjectPropertiesDom, (String)XAdESNamespaces.XAdES, (String)"xades:IndividualDataObjectsTimeStamp");
                break;
            }
            default: {
                LOG.error("Unsupported timestamp type : " + timestampType);
            }
        }
        if (LOG.isDebugEnabled()) {
            String encodedDigestValue = Utils.toBase64((byte[])digestValue);
            LOG.debug("Timestamp generation: " + timestampDigestAlgorithm.getName() + " / " + timestampC14nMethod + " / " + encodedDigestValue);
        }
        TimeStampToken timeStampToken = this.tspSource.getTimeStampResponse(timestampDigestAlgorithm, digestValue);
        String base64EncodedTimeStampToken = Utils.toBase64((byte[])DSSASN1Utils.getEncoded((TimeStampToken)timeStampToken));
        String timestampId = UUID.randomUUID().toString();
        timeStampDom.setAttribute("Id", "TS-" + timestampId);
        this.incorporateC14nMethod(timeStampDom, timestampC14nMethod);
        Element encapsulatedTimeStampDom = DomUtils.addElement((Document)this.documentDom, (Element)timeStampDom, (String)XAdESNamespaces.XAdES, (String)"xades:EncapsulatedTimeStamp");
        encapsulatedTimeStampDom.setAttribute("Id", "ETS-" + timestampId);
        DomUtils.setTextNode((Document)this.documentDom, (Element)encapsulatedTimeStampDom, (String)base64EncodedTimeStampToken);
    }
}

