/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.TimestampParameters;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.TimestampToken;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.x509.TimestampType;
import eu.europa.esig.dss.xades.signature.XAdESLevelBaselineLT;
import java.io.Serializable;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XAdESLevelBaselineLTA
extends XAdESLevelBaselineLT
implements Serializable {
    public XAdESLevelBaselineLTA(CertificateVerifier certVerifier) {
        super(certVerifier);
    }

    @Override
    protected void extendSignatureTag() throws DSSException {
        super.extendSignatureTag();
        if (this.xadesSignature.hasLTAProfile()) {
            this.checkSignatureIntegrity();
            ValidationContext validationContext = this.xadesSignature.getSignatureValidationContext(this.certificateVerifier);
            this.removeLastTimestampValidationData();
            this.incorporateTimestampValidationData(validationContext);
        }
        this.incorporateArchiveTimestamp();
    }

    private void removeLastTimestampValidationData() {
        Element toRemove = this.xadesSignature.getLastTimestampValidationData();
        if (toRemove != null) {
            this.unsignedSignaturePropertiesDom.removeChild(toRemove);
        }
    }

    private void incorporateTimestampValidationData(ValidationContext validationContext) {
        Element timeStampValidationDataDom = DomUtils.addElement((Document)this.documentDom, (Element)this.unsignedSignaturePropertiesDom, (String)"http://uri.etsi.org/01903/v1.4.1#", (String)"xades141:TimeStampValidationData");
        this.incorporateCertificateValues(timeStampValidationDataDom, validationContext);
        this.incorporateRevocationValues(timeStampValidationDataDom, validationContext);
        String id = "1";
        List<TimestampToken> archiveTimestamps = this.xadesSignature.getArchiveTimestamps();
        if (archiveTimestamps.size() > 0) {
            TimestampToken timestampToken = archiveTimestamps.get(archiveTimestamps.size() - 1);
            id = timestampToken.getDSSIdAsString();
        }
        timeStampValidationDataDom.setAttribute("Id", "id-" + id);
    }

    private void incorporateArchiveTimestamp() {
        TimestampParameters archiveTimestampParameters = this.params.getArchiveTimestampParameters();
        String canonicalizationMethod = archiveTimestampParameters.getCanonicalizationMethod();
        byte[] archiveTimestampData = this.xadesSignature.getArchiveTimestampData(null, canonicalizationMethod);
        DigestAlgorithm timestampDigestAlgorithm = archiveTimestampParameters.getDigestAlgorithm();
        byte[] digestBytes = DSSUtils.digest((DigestAlgorithm)timestampDigestAlgorithm, (byte[])archiveTimestampData);
        this.createXAdESTimeStampType(TimestampType.ARCHIVE_TIMESTAMP, canonicalizationMethod, digestBytes);
    }
}

