/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.xades.SantuarioInitializer;
import eu.europa.esig.dss.xades.SignatureBuilder;
import eu.europa.esig.dss.xades.SignatureProfile;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.signature.XAdESSignatureBuilder;
import java.io.Serializable;

public class XAdESLevelBaselineB
implements SignatureProfile,
Serializable {
    private CertificateVerifier certificateVerifier;

    public XAdESLevelBaselineB(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
    }

    public byte[] getDataToSign(DSSDocument dssDocument, XAdESSignatureParameters parameters) throws DSSException {
        XAdESSignatureBuilder signatureBuilder = XAdESSignatureBuilder.getSignatureBuilder(parameters, dssDocument, this.certificateVerifier);
        parameters.getContext().setBuilder(signatureBuilder);
        byte[] dataToSign = signatureBuilder.build();
        return dataToSign;
    }

    @Override
    public DSSDocument signDocument(DSSDocument document, XAdESSignatureParameters parameters, byte[] signatureValue) throws DSSException {
        SignatureBuilder builder = parameters.getContext().getBuilder();
        builder = builder != null ? parameters.getContext().getBuilder() : XAdESSignatureBuilder.getSignatureBuilder(parameters, document, this.certificateVerifier);
        DSSDocument dssDocument = builder.signDocument(signatureValue);
        parameters.getContext().setBuilder(builder);
        return dssDocument;
    }

    static {
        SantuarioInitializer.init();
    }
}

