/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ValidationData;
import eu.europa.esig.dss.validation.ValidationDataContainer;
import eu.europa.esig.dss.xades.signature.XAdESLevelX;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;

public class XAdESLevelXL
extends XAdESLevelX {
    public XAdESLevelXL(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    @Override
    protected void extendSignatures(List<AdvancedSignature> signatures) {
        super.extendSignatures(signatures);
        boolean xlLevelRequired = false;
        for (AdvancedSignature signature : signatures) {
            this.initializeSignatureBuilder((XAdESSignature)signature);
            if (!this.xlLevelExtensionRequired()) continue;
            this.checkSignatureIntegrity();
            this.xadesSignature.resetTimestampSource();
            xlLevelRequired = true;
        }
        if (!xlLevelRequired) {
            return;
        }
        ValidationDataContainer validationDataContainer = this.documentValidator.getValidationData(signatures);
        for (AdvancedSignature signature : signatures) {
            this.initializeSignatureBuilder((XAdESSignature)signature);
            if (!this.xlLevelExtensionRequired()) continue;
            this.assertExtendSignatureToXLPossible();
            String indent = this.removeOldCertificateValues();
            this.removeOldRevocationValues();
            Element levelXUnsignedProperties = (Element)this.unsignedSignaturePropertiesDom.cloneNode(true);
            ValidationData validationDataForInclusion = validationDataContainer.getCompleteValidationDataForSignature(signature);
            Set certificateValuesToAdd = validationDataForInclusion.getCertificateTokens();
            Set crlsToAdd = validationDataForInclusion.getCrlTokens();
            Set ocspsToAdd = validationDataForInclusion.getOcspTokens();
            this.incorporateCertificateValues(this.unsignedSignaturePropertiesDom, certificateValuesToAdd, indent);
            this.incorporateRevocationValues(this.unsignedSignaturePropertiesDom, crlsToAdd, ocspsToAdd, indent);
            this.unsignedSignaturePropertiesDom = this.indentIfPrettyPrint(this.unsignedSignaturePropertiesDom, levelXUnsignedProperties);
        }
    }

    private boolean xlLevelExtensionRequired() {
        return SignatureLevel.XAdES_XL.equals((Object)this.params.getSignatureLevel()) || !this.xadesSignature.hasAProfile();
    }

    private void assertExtendSignatureToXLPossible() {
        SignatureLevel signatureLevel = this.params.getSignatureLevel();
        if (SignatureLevel.XAdES_XL.equals((Object)signatureLevel) && this.xadesSignature.hasAProfile()) {
            throw new IllegalInputException(String.format("Cannot extend signature to '%s'. The signature is already extended with A level.", signatureLevel));
        }
        if (this.xadesSignature.areAllSelfSignedCertificates()) {
            throw new IllegalInputException("Cannot extend the signature. The signature contains only self-signed certificate chains!");
        }
    }
}

