/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.utils.impl;

import eu.europa.esig.dss.utils.IUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ApacheCommonsUtils
implements IUtils {
    public boolean isStringEmpty(String text) {
        return StringUtils.isEmpty((CharSequence)text);
    }

    public boolean isStringNotEmpty(String text) {
        return StringUtils.isNotEmpty((CharSequence)text);
    }

    public boolean isStringBlank(String text) {
        return StringUtils.isBlank((CharSequence)text);
    }

    public boolean isStringNotBlank(String text) {
        return StringUtils.isNotBlank((CharSequence)text);
    }

    public boolean areStringsEqual(String text1, String text2) {
        return StringUtils.equals((CharSequence)text1, (CharSequence)text2);
    }

    public boolean areStringsEqualIgnoreCase(String text1, String text2) {
        return StringUtils.equalsIgnoreCase((CharSequence)text1, (CharSequence)text2);
    }

    public boolean isStringDigits(String text) {
        return NumberUtils.isDigits((String)text);
    }

    public String trim(String text) {
        return StringUtils.trim((String)text);
    }

    public String joinStrings(Collection<String> strings, String separator) {
        return StringUtils.join(strings, (String)separator);
    }

    public String substringAfter(String text, String after) {
        return StringUtils.substringAfter((String)text, (String)after);
    }

    public boolean endsWithIgnoreCase(String text, String expected) {
        return StringUtils.endsWithIgnoreCase((CharSequence)text, (CharSequence)expected);
    }

    public String lowerCase(String text) {
        return StringUtils.lowerCase((String)text);
    }

    public String upperCase(String text) {
        return StringUtils.upperCase((String)text);
    }

    public boolean isArrayEmpty(Object[] array) {
        return ArrayUtils.isEmpty((Object[])array);
    }

    public boolean isArrayNotEmpty(Object[] array) {
        return ArrayUtils.isNotEmpty((Object[])array);
    }

    public boolean isArrayNotEmpty(byte[] array) {
        return ArrayUtils.isNotEmpty((byte[])array);
    }

    public boolean isArrayEmpty(byte[] array) {
        return ArrayUtils.isEmpty((byte[])array);
    }

    public byte[] subarray(byte[] array, int start, int length) {
        return ArrayUtils.subarray((byte[])array, (int)start, (int)length);
    }

    public boolean isTrue(Boolean bool) {
        return BooleanUtils.isTrue((Boolean)bool);
    }

    public boolean isCollectionEmpty(Collection collection) {
        return CollectionUtils.isEmpty((Collection)collection);
    }

    public boolean isCollectionNotEmpty(Collection collection) {
        return CollectionUtils.isNotEmpty((Collection)collection);
    }

    public int collectionSize(Collection collection) {
        return CollectionUtils.size((Object)collection);
    }

    public String toHex(byte[] bytes) {
        return Hex.encodeHexString((byte[])bytes);
    }

    public byte[] fromHex(String hex) {
        try {
            return Hex.decodeHex((char[])hex.toCharArray());
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException("Unable to extract binary from Hex", e);
        }
    }

    public String toBase64(byte[] bytes) {
        return Base64.encodeBase64String((byte[])bytes);
    }

    public byte[] fromBase64(String base64) {
        return Base64.decodeBase64((String)base64);
    }

    public byte[] toByteArray(InputStream is) throws IOException {
        return IOUtils.toByteArray((InputStream)is);
    }

    public void closeQuietly(Closeable closeable) {
        IOUtils.closeQuietly((Closeable)closeable);
    }

    public void copy(InputStream is, OutputStream os) throws IOException {
        IOUtils.copy((InputStream)is, (OutputStream)os);
    }

    public void write(byte[] content, OutputStream os) throws IOException {
        IOUtils.write((byte[])content, (OutputStream)os);
    }

    public void cleanDirectory(File directory) throws IOException {
        try {
            FileUtils.cleanDirectory((File)directory);
        }
        catch (IllegalArgumentException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    public Collection<File> listFiles(File folder, String[] extensions, boolean recursive) {
        return FileUtils.listFiles((File)folder, (String[])extensions, (boolean)recursive);
    }
}

