/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.sync;

import eu.europa.esig.dss.spi.tsl.LOTLInfo;
import eu.europa.esig.dss.spi.tsl.ParsingInfoRecord;
import eu.europa.esig.dss.spi.tsl.TLInfo;
import eu.europa.esig.dss.spi.tsl.ValidationInfoRecord;
import eu.europa.esig.dss.tsl.sync.SynchronizationStrategy;
import java.util.Date;

public class ExpirationAndSignatureCheckStrategy
implements SynchronizationStrategy {
    private boolean acceptExpiredTrustedList = false;
    private boolean acceptInvalidTrustedList = false;
    private boolean acceptExpiredListOfTrustedLists = false;
    private boolean acceptInvalidListOfTrustedLists = false;

    public void setAcceptExpiredTrustedList(boolean acceptExpiredTrustedList) {
        this.acceptExpiredTrustedList = acceptExpiredTrustedList;
    }

    public void setAcceptInvalidTrustedList(boolean acceptInvalidTrustedList) {
        this.acceptInvalidTrustedList = acceptInvalidTrustedList;
    }

    public void setAcceptExpiredListOfTrustedLists(boolean acceptExpiredListOfTrustedLists) {
        this.acceptExpiredListOfTrustedLists = acceptExpiredListOfTrustedLists;
    }

    public void setAcceptInvalidListOfTrustedLists(boolean acceptInvalidListOfTrustedLists) {
        this.acceptInvalidListOfTrustedLists = acceptInvalidListOfTrustedLists;
    }

    @Override
    public boolean canBeSynchronized(TLInfo trustedList) {
        return this.isSyncSupported(trustedList, this.acceptExpiredTrustedList, this.acceptInvalidTrustedList);
    }

    @Override
    public boolean canBeSynchronized(LOTLInfo listOfTrustedList) {
        return this.isSyncSupported((TLInfo)listOfTrustedList, this.acceptExpiredListOfTrustedLists, this.acceptInvalidListOfTrustedLists);
    }

    private boolean isSyncSupported(TLInfo tlInfo, boolean syncExpired, boolean syncInvalid) {
        ValidationInfoRecord validationCacheInfo;
        ParsingInfoRecord parsingCacheInfo;
        if (!syncExpired && (parsingCacheInfo = tlInfo.getParsingCacheInfo()) != null && parsingCacheInfo.isResultExist()) {
            Date currentDate = new Date();
            Date nextUpdateDate = parsingCacheInfo.getNextUpdateDate();
            if (nextUpdateDate == null || currentDate.after(nextUpdateDate)) {
                return false;
            }
        }
        if (!syncInvalid && (validationCacheInfo = tlInfo.getValidationCacheInfo()) != null && validationCacheInfo.isResultExist()) {
            return validationCacheInfo.isValid();
        }
        return true;
    }
}

