/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.cache;

import eu.europa.esig.dss.tsl.cache.AbstractCache;
import eu.europa.esig.dss.tsl.cache.CacheKey;
import eu.europa.esig.dss.tsl.cache.CacheType;
import eu.europa.esig.dss.tsl.cache.state.CachedEntry;
import eu.europa.esig.dss.tsl.download.XmlDownloadResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadCache
extends AbstractCache<XmlDownloadResult> {
    private static final Logger LOG = LoggerFactory.getLogger(DownloadCache.class);

    public boolean isUpToDate(CacheKey cacheKey, XmlDownloadResult downloadedResult) {
        LOG.trace("Extracting cached file for the key [{}]...", (Object)cacheKey);
        CachedEntry cachedFileEntry = this.get(cacheKey);
        if (!cachedFileEntry.isEmpty()) {
            XmlDownloadResult cachedResult = (XmlDownloadResult)cachedFileEntry.getCachedResult();
            LOG.trace("Comparing digest of the stored file [{}] with the downloaded file [{}]", (Object)cachedResult.getDigest(), (Object)downloadedResult.getDigest());
            boolean upToDate = cachedResult.getDigest().equals((Object)downloadedResult.getDigest());
            LOG.trace("Is file with the key [{}] up to date ? {}", (Object)cacheKey, (Object)upToDate);
            if (upToDate) {
                cachedFileEntry.syncUpdateDate();
            }
            return upToDate;
        }
        LOG.trace("The FileCache does not contain a file result for the key [{}]!", (Object)cacheKey);
        return false;
    }

    @Override
    protected CacheType getCacheType() {
        return CacheType.DOWNLOAD;
    }
}

