/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.sync;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.tsl.LOTLInfo;
import eu.europa.esig.dss.spi.tsl.ParsingInfoRecord;
import eu.europa.esig.dss.spi.tsl.PivotInfo;
import eu.europa.esig.dss.spi.tsl.TLInfo;
import eu.europa.esig.dss.spi.tsl.TLValidationJobSummary;
import eu.europa.esig.dss.spi.tsl.TrustProperties;
import eu.europa.esig.dss.spi.tsl.TrustService;
import eu.europa.esig.dss.spi.tsl.TrustServiceProvider;
import eu.europa.esig.dss.spi.tsl.TrustServiceStatusAndInformationExtensions;
import eu.europa.esig.dss.spi.tsl.TrustedListsCertificateSource;
import eu.europa.esig.dss.spi.tsl.builder.TrustServiceProviderBuilder;
import eu.europa.esig.dss.spi.util.TimeDependentValues;
import eu.europa.esig.dss.tsl.cache.CacheKey;
import eu.europa.esig.dss.tsl.cache.access.SynchronizerCacheAccess;
import eu.europa.esig.dss.tsl.source.LOTLSource;
import eu.europa.esig.dss.tsl.source.TLSource;
import eu.europa.esig.dss.tsl.summary.ValidationJobSummaryBuilder;
import eu.europa.esig.dss.tsl.sync.SynchronizationStrategy;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustedListCertificateSourceSynchronizer {
    private static final Logger LOG = LoggerFactory.getLogger(TrustedListCertificateSourceSynchronizer.class);
    private final TLSource[] tlSources;
    private final LOTLSource[] lotlSources;
    private final SynchronizationStrategy synchronizationStrategy;
    private final TrustedListsCertificateSource certificateSource;
    private final SynchronizerCacheAccess cacheAccess;

    public TrustedListCertificateSourceSynchronizer(TLSource[] tlSources, LOTLSource[] lotlSources, TrustedListsCertificateSource certificateSource, SynchronizationStrategy synchronizationStrategy, SynchronizerCacheAccess cacheAccess) {
        this.tlSources = tlSources;
        this.lotlSources = lotlSources;
        this.synchronizationStrategy = synchronizationStrategy;
        this.certificateSource = certificateSource;
        this.cacheAccess = cacheAccess;
    }

    public void sync() {
        try {
            ValidationJobSummaryBuilder summaryBuilder = new ValidationJobSummaryBuilder(this.cacheAccess, this.tlSources, this.lotlSources);
            TLValidationJobSummary summary = summaryBuilder.build();
            if (this.isCertificateSyncNeeded(summary)) {
                this.synchronizeCertificates(summary);
            }
            this.syncCache(summary);
            this.certificateSource.setSummary(summaryBuilder.build());
        }
        catch (Exception e) {
            LOG.error("Unable to synchronize the TrustedListsCertificateSource", (Throwable)e);
        }
    }

    private boolean isCertificateSyncNeeded(TLValidationJobSummary summary) {
        for (LOTLInfo lotlInfo : summary.getLOTLInfos()) {
            if (!this.isTLParsingDesyncOrError(lotlInfo.getTLInfos())) continue;
            return true;
        }
        return this.isTLParsingDesyncOrError(summary.getOtherTLInfos());
    }

    private boolean isTLParsingDesyncOrError(List<TLInfo> tlInfos) {
        for (TLInfo tlInfo : tlInfos) {
            ParsingInfoRecord parsingCacheInfo = tlInfo.getParsingCacheInfo();
            if (!parsingCacheInfo.isDesynchronized() && !parsingCacheInfo.isError()) continue;
            return true;
        }
        return false;
    }

    private void synchronizeCertificates(TLValidationJobSummary summary) {
        WeakHashMap<CertificateToken, List<TrustProperties>> trustPropertiesByCerts = new WeakHashMap<CertificateToken, List<TrustProperties>>();
        for (LOTLInfo lotlInfo : summary.getLOTLInfos()) {
            if (this.synchronizationStrategy.canBeSynchronized(lotlInfo)) {
                this.addCertificatesFromTLs(trustPropertiesByCerts, lotlInfo.getTLInfos(), lotlInfo);
                continue;
            }
            LOG.warn("Certificate synchronization is skipped for LOTL '{}' and its TLs", (Object)lotlInfo.getUrl());
        }
        this.addCertificatesFromTLs(trustPropertiesByCerts, summary.getOtherTLInfos(), null);
        this.certificateSource.setTrustPropertiesByCertificates(trustPropertiesByCerts);
    }

    private void addCertificatesFromTLs(Map<CertificateToken, List<TrustProperties>> trustPropertiesByCerts, List<TLInfo> tlInfos, LOTLInfo relatedLOTL) {
        for (TLInfo tlInfo : tlInfos) {
            if (this.synchronizationStrategy.canBeSynchronized(tlInfo)) {
                ParsingInfoRecord parsingCacheInfo = tlInfo.getParsingCacheInfo();
                if (!parsingCacheInfo.isResultExist()) {
                    LOG.warn("No Parsing result for TLInfo with url [{}]", (Object)tlInfo.getUrl());
                    continue;
                }
                List trustServiceProviders = parsingCacheInfo.getTrustServiceProviders();
                if (!Utils.isCollectionNotEmpty((Collection)trustServiceProviders)) continue;
                for (TrustServiceProvider original : trustServiceProviders) {
                    TrustServiceProvider detached = this.getDetached(original);
                    for (TrustService trustService : original.getServices()) {
                        TimeDependentValues statusAndInformationExtensions = trustService.getStatusAndInformationExtensions();
                        TrustProperties trustProperties = this.getTrustProperties(relatedLOTL, tlInfo, detached, (TimeDependentValues<TrustServiceStatusAndInformationExtensions>)statusAndInformationExtensions);
                        for (CertificateToken certificate : trustService.getCertificates()) {
                            this.addCertificate(trustPropertiesByCerts, certificate, trustProperties);
                        }
                    }
                }
                continue;
            }
            LOG.warn("Certificate synchronization is skipped for TL '{}'", (Object)tlInfo.getUrl());
        }
    }

    private void addCertificate(Map<CertificateToken, List<TrustProperties>> trustPropertiesByCerts, CertificateToken certificate, TrustProperties trustProperties) {
        List<TrustProperties> list = trustPropertiesByCerts.get(certificate);
        if (list == null) {
            list = new ArrayList<TrustProperties>();
            trustPropertiesByCerts.put(certificate, list);
        }
        if (!list.contains(trustProperties)) {
            list.add(trustProperties);
        }
    }

    private TrustServiceProvider getDetached(TrustServiceProvider original) {
        TrustServiceProviderBuilder builder = new TrustServiceProviderBuilder(original);
        builder.setServices(Collections.emptyList());
        return builder.build();
    }

    private void syncCache(TLValidationJobSummary summary) {
        for (LOTLInfo lotlInfo : summary.getLOTLInfos()) {
            this.syncTLInfosCache(lotlInfo.getTLInfos());
            this.syncPivotsCache(lotlInfo.getPivotInfos());
            this.cacheAccess.sync(new CacheKey(lotlInfo.getUrl()));
        }
        this.syncTLInfosCache(summary.getOtherTLInfos());
    }

    private void syncPivotsCache(List<PivotInfo> pivotInfos) {
        for (PivotInfo pivotInfo : pivotInfos) {
            this.cacheAccess.sync(new CacheKey(pivotInfo.getUrl()));
        }
    }

    private void syncTLInfosCache(List<TLInfo> tlInfos) {
        for (TLInfo tlInfo : tlInfos) {
            this.cacheAccess.sync(new CacheKey(tlInfo.getUrl()));
        }
    }

    private TrustProperties getTrustProperties(LOTLInfo relatedLOTL, TLInfo tlInfo, TrustServiceProvider detached, TimeDependentValues<TrustServiceStatusAndInformationExtensions> statusAndInformationExtensions) {
        if (relatedLOTL == null) {
            return new TrustProperties(tlInfo.getIdentifier(), detached, statusAndInformationExtensions);
        }
        return new TrustProperties(relatedLOTL.getIdentifier(), tlInfo.getIdentifier(), detached, statusAndInformationExtensions);
    }
}

