/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.job;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.tsl.OtherTSLPointer;
import eu.europa.esig.dss.tsl.cache.CacheKey;
import eu.europa.esig.dss.tsl.cache.access.TLChangesCacheAccess;
import eu.europa.esig.dss.tsl.dto.ParsingCacheDTO;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LOTLChangeApplier {
    private static final Logger LOG = LoggerFactory.getLogger(LOTLChangeApplier.class);
    private final TLChangesCacheAccess cacheAccess;
    private final Map<CacheKey, ParsingCacheDTO> oldValues;
    private final Map<CacheKey, ParsingCacheDTO> newValues;

    public LOTLChangeApplier(TLChangesCacheAccess cacheAccess, Map<CacheKey, ParsingCacheDTO> oldValues, Map<CacheKey, ParsingCacheDTO> newValues) {
        this.cacheAccess = cacheAccess;
        this.oldValues = oldValues;
        this.newValues = newValues;
    }

    public void analyzeAndApply() {
        for (Map.Entry<CacheKey, ParsingCacheDTO> oldEntry : this.oldValues.entrySet()) {
            Map<String, List<CertificateToken>> oldUrlCerts = this.getTLPointers(oldEntry.getValue());
            Map<String, List<CertificateToken>> newUrlCerts = this.getTLPointers(this.newValues.get(oldEntry.getKey()));
            this.detectUrlChanges(oldUrlCerts, newUrlCerts);
            this.detectSigCertsChanges(oldUrlCerts, newUrlCerts);
        }
    }

    private Map<String, List<CertificateToken>> getTLPointers(ParsingCacheDTO parsingResult) {
        List<OtherTSLPointer> tlOtherPointers = parsingResult.getTlOtherPointers();
        if (Utils.isCollectionNotEmpty(tlOtherPointers)) {
            return tlOtherPointers.stream().collect(Collectors.toMap(OtherTSLPointer::getLocation, s -> s.getCertificates()));
        }
        return Collections.emptyMap();
    }

    private void detectUrlChanges(Map<String, List<CertificateToken>> oldUrlCerts, Map<String, List<CertificateToken>> newUrlCerts) {
        for (String oldUrl : oldUrlCerts.keySet()) {
            if (newUrlCerts.containsKey(oldUrl)) continue;
            LOG.info("TL with URL '{}' is not used anymore (replaced URL in the LOTL)", (Object)oldUrl);
            this.cacheAccess.toBeDeleted(new CacheKey(oldUrl));
        }
    }

    private void detectSigCertsChanges(Map<String, List<CertificateToken>> oldUrlCerts, Map<String, List<CertificateToken>> newUrlCerts) {
        for (Map.Entry<String, List<CertificateToken>> newEntry : newUrlCerts.entrySet()) {
            String newUrl = newEntry.getKey();
            List<CertificateToken> oldCerts = oldUrlCerts.get(newUrl);
            List<CertificateToken> newCerts = newEntry.getValue();
            if (oldCerts == null || oldCerts.equals(newCerts)) continue;
            LOG.info("Signing certificates change detected for TL with URL '{}'", (Object)newUrl);
            this.cacheAccess.expireSignatureValidation(new CacheKey(newUrl));
        }
    }
}

