/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.function.converter;

import eu.europa.esig.dss.spi.tsl.TrustService;
import eu.europa.esig.dss.spi.tsl.TrustServiceProvider;
import eu.europa.esig.dss.spi.tsl.builder.TrustServiceProviderBuilder;
import eu.europa.esig.dss.tsl.function.OfficialRegistrationIdentifierPredicate;
import eu.europa.esig.dss.tsl.function.TradeNamePredicate;
import eu.europa.esig.dss.tsl.function.converter.InternationalNamesTypeConverter;
import eu.europa.esig.dss.tsl.function.converter.TrustServiceConverter;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.trustedlist.jaxb.tsl.AddressType;
import eu.europa.esig.trustedlist.jaxb.tsl.ElectronicAddressType;
import eu.europa.esig.trustedlist.jaxb.tsl.InternationalNamesType;
import eu.europa.esig.trustedlist.jaxb.tsl.MultiLangNormStringType;
import eu.europa.esig.trustedlist.jaxb.tsl.NonEmptyMultiLangURIListType;
import eu.europa.esig.trustedlist.jaxb.tsl.NonEmptyMultiLangURIType;
import eu.europa.esig.trustedlist.jaxb.tsl.PostalAddressListType;
import eu.europa.esig.trustedlist.jaxb.tsl.PostalAddressType;
import eu.europa.esig.trustedlist.jaxb.tsl.TSPInformationType;
import eu.europa.esig.trustedlist.jaxb.tsl.TSPServicesListType;
import eu.europa.esig.trustedlist.jaxb.tsl.TSPType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TrustServiceProviderConverter
implements Function<TSPType, TrustServiceProvider> {
    private String territory;

    public TrustServiceProviderConverter setTerritory(String territory) {
        this.territory = territory;
        return this;
    }

    @Override
    public TrustServiceProvider apply(TSPType original) {
        TrustServiceProviderBuilder tspBuilder = new TrustServiceProviderBuilder();
        this.extractTSPInfo(tspBuilder, original.getTSPInformation());
        tspBuilder.setServices(this.extractTrustServices(original.getTSPServices()));
        return tspBuilder.build();
    }

    private void extractTSPInfo(TrustServiceProviderBuilder tspBuilder, TSPInformationType tspInformation) {
        tspBuilder.setTerritory(this.territory);
        InternationalNamesTypeConverter converter = new InternationalNamesTypeConverter();
        tspBuilder.setNames(converter.apply(tspInformation.getTSPName()));
        converter = new InternationalNamesTypeConverter(new TradeNamePredicate());
        tspBuilder.setTradeNames(converter.apply(tspInformation.getTSPTradeName()));
        tspBuilder.setRegistrationIdentifiers(this.extractRegistrationIdentifiers(tspInformation.getTSPTradeName()));
        AddressType tspAddress = tspInformation.getTSPAddress();
        if (tspAddress != null) {
            tspBuilder.setPostalAddresses(this.extractPostalAddress(tspAddress.getPostalAddresses()));
            tspBuilder.setElectronicAddresses(this.extractElectronicAddress(tspAddress.getElectronicAddress()));
        }
        tspBuilder.setInformation(this.extractInformationURI(tspInformation.getTSPInformationURI()));
    }

    private List<String> extractRegistrationIdentifiers(InternationalNamesType internationalNamesType) {
        OfficialRegistrationIdentifierPredicate predicate = new OfficialRegistrationIdentifierPredicate();
        ArrayList<String> result = new ArrayList<String>();
        if (internationalNamesType != null && Utils.isCollectionNotEmpty((Collection)internationalNamesType.getName())) {
            for (MultiLangNormStringType multiLangNormString : internationalNamesType.getName()) {
                String value = multiLangNormString.getValue();
                if (!predicate.test(value) || result.contains(value)) continue;
                result.add(value);
            }
        }
        return result;
    }

    private Map<String, String> extractPostalAddress(PostalAddressListType postalAddressList) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (postalAddressList != null && Utils.isCollectionNotEmpty((Collection)postalAddressList.getPostalAddress())) {
            for (PostalAddressType postalAddress : postalAddressList.getPostalAddress()) {
                String lang = postalAddress.getLang();
                if (result.get(lang) != null) continue;
                result.put(lang, this.getPostalAddress(postalAddress));
            }
        }
        return result;
    }

    private String getPostalAddress(PostalAddressType postalAddress) {
        StringBuilder sb = new StringBuilder();
        if (Utils.isStringNotEmpty((String)postalAddress.getStreetAddress())) {
            sb.append(postalAddress.getStreetAddress());
            sb.append(", ");
        }
        if (Utils.isStringNotEmpty((String)postalAddress.getPostalCode())) {
            sb.append(postalAddress.getPostalCode());
            sb.append(", ");
        }
        if (Utils.isStringNotEmpty((String)postalAddress.getLocality())) {
            sb.append(postalAddress.getLocality());
            sb.append(", ");
        }
        if (Utils.isStringNotEmpty((String)postalAddress.getStateOrProvince())) {
            sb.append(postalAddress.getStateOrProvince());
            sb.append(", ");
        }
        if (Utils.isStringNotEmpty((String)postalAddress.getCountryName())) {
            sb.append(postalAddress.getCountryName());
        }
        return sb.toString();
    }

    private Map<String, List<String>> extractElectronicAddress(ElectronicAddressType electronicAddress) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        if (electronicAddress != null && Utils.isCollectionNotEmpty((Collection)electronicAddress.getURI())) {
            for (NonEmptyMultiLangURIType uriAndLang : electronicAddress.getURI()) {
                this.addEntry(result, uriAndLang.getLang(), uriAndLang.getValue());
            }
        }
        return result;
    }

    private Map<String, String> extractInformationURI(NonEmptyMultiLangURIListType tspInformationURI) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (tspInformationURI != null && Utils.isCollectionNotEmpty((Collection)tspInformationURI.getURI())) {
            for (NonEmptyMultiLangURIType uriAndLang : tspInformationURI.getURI()) {
                String lang = uriAndLang.getLang();
                if (result.get(lang) != null) continue;
                result.put(lang, uriAndLang.getValue());
            }
        }
        return result;
    }

    private void addEntry(Map<String, List<String>> result, String lang, String value) {
        List<String> resultsByLang = result.get(lang);
        if (resultsByLang == null) {
            resultsByLang = new ArrayList<String>();
            result.put(lang, resultsByLang);
        }
        resultsByLang.add(value);
    }

    private List<TrustService> extractTrustServices(TSPServicesListType tspServicesList) {
        if (tspServicesList != null && Utils.isCollectionNotEmpty((Collection)tspServicesList.getTSPService())) {
            return tspServicesList.getTSPService().stream().map(new TrustServiceConverter()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

