/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.function.converter;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.tsl.Condition;
import eu.europa.esig.dss.spi.tsl.ConditionForQualifiers;
import eu.europa.esig.dss.spi.tsl.TrustService;
import eu.europa.esig.dss.spi.tsl.TrustServiceStatusAndInformationExtensions;
import eu.europa.esig.dss.spi.util.MutableTimeDependentValues;
import eu.europa.esig.dss.spi.util.TimeDependent;
import eu.europa.esig.dss.spi.util.TimeDependentValues;
import eu.europa.esig.dss.tsl.dto.condition.CertSubjectDNAttributeCondition;
import eu.europa.esig.dss.tsl.dto.condition.CompositeCondition;
import eu.europa.esig.dss.tsl.dto.condition.ExtendedKeyUsageCondition;
import eu.europa.esig.dss.tsl.dto.condition.KeyUsageCondition;
import eu.europa.esig.dss.tsl.dto.condition.PolicyIdCondition;
import eu.europa.esig.dss.tsl.function.converter.DigitalIdentityListTypeConverter;
import eu.europa.esig.dss.tsl.function.converter.InternationalNamesTypeConverter;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.trustedlist.enums.Assert;
import eu.europa.esig.trustedlist.jaxb.ecc.CriteriaListType;
import eu.europa.esig.trustedlist.jaxb.ecc.KeyUsageBitType;
import eu.europa.esig.trustedlist.jaxb.ecc.KeyUsageType;
import eu.europa.esig.trustedlist.jaxb.ecc.PoliciesListType;
import eu.europa.esig.trustedlist.jaxb.ecc.QualificationElementType;
import eu.europa.esig.trustedlist.jaxb.ecc.QualificationsType;
import eu.europa.esig.trustedlist.jaxb.ecc.QualifierType;
import eu.europa.esig.trustedlist.jaxb.ecc.QualifiersType;
import eu.europa.esig.trustedlist.jaxb.tsl.AdditionalServiceInformationType;
import eu.europa.esig.trustedlist.jaxb.tsl.AttributedNonEmptyURIType;
import eu.europa.esig.trustedlist.jaxb.tsl.DigitalIdentityListType;
import eu.europa.esig.trustedlist.jaxb.tsl.ExtensionType;
import eu.europa.esig.trustedlist.jaxb.tsl.ExtensionsListType;
import eu.europa.esig.trustedlist.jaxb.tsl.NonEmptyMultiLangURIType;
import eu.europa.esig.trustedlist.jaxb.tsl.ServiceHistoryInstanceType;
import eu.europa.esig.trustedlist.jaxb.tsl.ServiceSupplyPointsType;
import eu.europa.esig.trustedlist.jaxb.tsl.TSPServiceInformationType;
import eu.europa.esig.trustedlist.jaxb.tsl.TSPServiceType;
import eu.europa.esig.trustedlist.jaxb.tslx.CertSubjectDNAttributeType;
import eu.europa.esig.trustedlist.jaxb.tslx.ExtendedKeyUsageType;
import eu.europa.esig.xades.jaxb.xades132.AnyType;
import eu.europa.esig.xades.jaxb.xades132.IdentifierType;
import eu.europa.esig.xades.jaxb.xades132.ObjectIdentifierType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.XMLGregorianCalendar;

public class TrustServiceConverter
implements Function<TSPServiceType, TrustService> {
    @Override
    public TrustService apply(TSPServiceType original) {
        TrustService.TrustServiceBuilder trustServiceBuilder = new TrustService.TrustServiceBuilder();
        return trustServiceBuilder.setCertificates(this.extractCertificates(original.getServiceInformation())).setStatusAndInformationExtensions(this.extractStatusAndHistory(original)).build();
    }

    private List<CertificateToken> extractCertificates(TSPServiceInformationType serviceInformation) {
        DigitalIdentityListTypeConverter converter = new DigitalIdentityListTypeConverter();
        DigitalIdentityListType serviceDigitalIdentityList = serviceInformation.getServiceDigitalIdentity();
        return Collections.unmodifiableList(converter.apply(serviceDigitalIdentityList));
    }

    private TimeDependentValues<TrustServiceStatusAndInformationExtensions> extractStatusAndHistory(TSPServiceType original) {
        MutableTimeDependentValues statusHistoryList = new MutableTimeDependentValues();
        TSPServiceInformationType serviceInfo = original.getServiceInformation();
        InternationalNamesTypeConverter converter = new InternationalNamesTypeConverter();
        TrustServiceStatusAndInformationExtensions.TrustServiceStatusAndInformationExtensionsBuilder statusBuilder = new TrustServiceStatusAndInformationExtensions.TrustServiceStatusAndInformationExtensionsBuilder();
        statusBuilder.setNames(converter.apply(serviceInfo.getServiceName()));
        statusBuilder.setType(serviceInfo.getServiceTypeIdentifier());
        statusBuilder.setStatus(serviceInfo.getServiceStatus());
        statusBuilder.setServiceSupplyPoints(this.getServiceSupplyPoints(serviceInfo.getServiceSupplyPoints()));
        this.parseExtensionsList(serviceInfo.getServiceInformationExtensions(), statusBuilder);
        Date nextEndDate = this.convertToDate(serviceInfo.getStatusStartingTime());
        statusBuilder.setStartDate(nextEndDate);
        statusHistoryList.addOldest((TimeDependent)statusBuilder.build());
        if (original.getServiceHistory() != null && Utils.isCollectionNotEmpty((Collection)original.getServiceHistory().getServiceHistoryInstance())) {
            for (ServiceHistoryInstanceType serviceHistory : original.getServiceHistory().getServiceHistoryInstance()) {
                TrustServiceStatusAndInformationExtensions.TrustServiceStatusAndInformationExtensionsBuilder statusHistoryBuilder = new TrustServiceStatusAndInformationExtensions.TrustServiceStatusAndInformationExtensionsBuilder();
                statusHistoryBuilder.setNames(converter.apply(serviceHistory.getServiceName()));
                statusHistoryBuilder.setType(serviceHistory.getServiceTypeIdentifier());
                statusHistoryBuilder.setStatus(serviceHistory.getServiceStatus());
                this.parseExtensionsList(serviceHistory.getServiceInformationExtensions(), statusHistoryBuilder);
                statusHistoryBuilder.setEndDate(nextEndDate);
                nextEndDate = this.convertToDate(serviceHistory.getStatusStartingTime());
                statusHistoryBuilder.setStartDate(nextEndDate);
                statusHistoryList.addOldest((TimeDependent)statusHistoryBuilder.build());
            }
        }
        return statusHistoryList;
    }

    private void parseExtensionsList(ExtensionsListType serviceInformationExtensions, TrustServiceStatusAndInformationExtensions.TrustServiceStatusAndInformationExtensionsBuilder statusBuilder) {
        if (serviceInformationExtensions != null) {
            statusBuilder.setConditionsForQualifiers(this.extractConditionsForQualifiers(serviceInformationExtensions.getExtension()));
            statusBuilder.setAdditionalServiceInfoUris(this.extractAdditionalServiceInfoUris(serviceInformationExtensions.getExtension()));
            statusBuilder.setExpiredCertsRevocationInfo(this.extractExpiredCertsRevocationInfo(serviceInformationExtensions.getExtension()));
        }
    }

    private List<ConditionForQualifiers> extractConditionsForQualifiers(List<ExtensionType> extensions) {
        ArrayList<ConditionForQualifiers> conditionsForQualifiers = new ArrayList<ConditionForQualifiers>();
        for (ExtensionType extensionType : extensions) {
            List content = extensionType.getContent();
            if (!Utils.isCollectionNotEmpty((Collection)content)) continue;
            for (Object object : content) {
                QualificationsType qt;
                JAXBElement jaxbElement;
                Object objectValue;
                if (!(object instanceof JAXBElement) || !((objectValue = (jaxbElement = (JAXBElement)object).getValue()) instanceof QualificationsType) || (qt = (QualificationsType)jaxbElement.getValue()) == null || !Utils.isCollectionNotEmpty((Collection)qt.getQualificationElement())) continue;
                for (QualificationElementType qualificationElement : qt.getQualificationElement()) {
                    List<String> qualifiers = this.extractQualifiers(qualificationElement);
                    Condition condition = this.getCondition(qualificationElement.getCriteriaList());
                    if (!Utils.isCollectionNotEmpty(qualifiers) || condition == null) continue;
                    conditionsForQualifiers.add(new ConditionForQualifiers(condition, Collections.unmodifiableList(qualifiers)));
                }
            }
        }
        return conditionsForQualifiers;
    }

    private List<String> extractAdditionalServiceInfoUris(List<ExtensionType> extensions) {
        ArrayList<String> additionalServiceInfos = new ArrayList<String>();
        for (ExtensionType extensionType : extensions) {
            List content = extensionType.getContent();
            if (!Utils.isCollectionNotEmpty((Collection)content)) continue;
            for (Object object : content) {
                AdditionalServiceInformationType additionalServiceInfo;
                NonEmptyMultiLangURIType uri;
                JAXBElement jaxbElement;
                Object objectValue;
                if (!(object instanceof JAXBElement) || !((objectValue = (jaxbElement = (JAXBElement)object).getValue()) instanceof AdditionalServiceInformationType) || (uri = (additionalServiceInfo = (AdditionalServiceInformationType)objectValue).getURI()) == null || !Utils.isStringNotBlank((String)uri.getValue())) continue;
                additionalServiceInfos.add(uri.getValue());
            }
        }
        return additionalServiceInfos;
    }

    private Date extractExpiredCertsRevocationInfo(List<ExtensionType> extensions) {
        for (ExtensionType extensionType : extensions) {
            List content = extensionType.getContent();
            if (!Utils.isCollectionNotEmpty((Collection)content)) continue;
            for (Object object : content) {
                JAXBElement jaxbElement;
                Object objectValue;
                if (!(object instanceof JAXBElement) || !((objectValue = (jaxbElement = (JAXBElement)object).getValue()) instanceof XMLGregorianCalendar)) continue;
                return this.convertToDate((XMLGregorianCalendar)objectValue);
            }
        }
        return null;
    }

    private Date convertToDate(XMLGregorianCalendar gregorianCalendar) {
        return gregorianCalendar.toGregorianCalendar().getTime();
    }

    private List<String> extractQualifiers(QualificationElementType qualificationElement) {
        ArrayList<String> qualifiers = new ArrayList<String>();
        QualifiersType qualifiersType = qualificationElement.getQualifiers();
        if (qualifiersType != null && Utils.isCollectionNotEmpty((Collection)qualifiersType.getQualifier())) {
            for (QualifierType qualitierType : qualifiersType.getQualifier()) {
                qualifiers.add(qualitierType.getUri());
            }
        }
        return qualifiers;
    }

    protected Condition getCondition(CriteriaListType criteriaList) {
        Assert matchingCriteriaIndicator = criteriaList.getAssert();
        CompositeCondition condition = new CompositeCondition(matchingCriteriaIndicator);
        this.addKeyUsageConditionsIfPresent(criteriaList.getKeyUsage(), condition);
        this.addPolicyIdConditionsIfPresent(criteriaList.getPolicySet(), condition);
        this.addOtherCriteriaListConditionsIfPresent(criteriaList.getOtherCriteriaList(), condition);
        this.addCriteriaListConditionsIfPresent(criteriaList.getCriteriaList(), condition);
        return condition;
    }

    private void addOtherCriteriaListConditionsIfPresent(AnyType otherCriteriaList, CompositeCondition condition) {
        if (otherCriteriaList != null && Utils.isCollectionNotEmpty((Collection)otherCriteriaList.getContent())) {
            for (Object content : otherCriteriaList.getContent()) {
                if (!(content instanceof JAXBElement)) continue;
                JAXBElement jaxbElement = (JAXBElement)content;
                Object objectValue = jaxbElement.getValue();
                if (objectValue instanceof CertSubjectDNAttributeType) {
                    CertSubjectDNAttributeType certSubDNAttr = (CertSubjectDNAttributeType)objectValue;
                    condition.addChild(new CertSubjectDNAttributeCondition(this.extractOids(certSubDNAttr.getAttributeOID())));
                    continue;
                }
                if (objectValue instanceof ExtendedKeyUsageType) {
                    ExtendedKeyUsageType extendedKeyUsage = (ExtendedKeyUsageType)objectValue;
                    condition.addChild(new ExtendedKeyUsageCondition(this.extractOids(extendedKeyUsage.getKeyPurposeId())));
                    continue;
                }
                throw new DSSException("Unsupported OtherCriteriaList");
            }
        }
    }

    private List<String> extractOids(List<ObjectIdentifierType> oits) {
        ArrayList<String> oids = new ArrayList<String>();
        if (Utils.isCollectionNotEmpty(oits)) {
            for (ObjectIdentifierType objectIdentifierType : oits) {
                oids.add(objectIdentifierType.getIdentifier().getValue());
            }
        }
        return oids;
    }

    private void addPolicyIdConditionsIfPresent(List<PoliciesListType> policySet, CompositeCondition criteriaCondition) {
        if (Utils.isCollectionNotEmpty(policySet)) {
            for (PoliciesListType policiesListType : policySet) {
                CompositeCondition condition = new CompositeCondition();
                for (ObjectIdentifierType oidType : policiesListType.getPolicyIdentifier()) {
                    IdentifierType identifier = oidType.getIdentifier();
                    String id = identifier.getValue();
                    if (id.indexOf(58) >= 0) {
                        id = id.substring(id.lastIndexOf(58) + 1);
                    }
                    condition.addChild(new PolicyIdCondition(id));
                }
                criteriaCondition.addChild(condition);
            }
        }
    }

    private void addKeyUsageConditionsIfPresent(List<KeyUsageType> keyUsages, CompositeCondition criteriaCondition) {
        if (Utils.isCollectionNotEmpty(keyUsages)) {
            for (KeyUsageType keyUsageType : keyUsages) {
                CompositeCondition condition = new CompositeCondition();
                for (KeyUsageBitType keyUsageBit : keyUsageType.getKeyUsageBit()) {
                    condition.addChild(new KeyUsageCondition(keyUsageBit.getName(), keyUsageBit.isValue()));
                }
                criteriaCondition.addChild(condition);
            }
        }
    }

    private void addCriteriaListConditionsIfPresent(List<CriteriaListType> criteriaList, CompositeCondition condition) {
        if (Utils.isCollectionNotEmpty(criteriaList)) {
            for (CriteriaListType criteriaListType : criteriaList) {
                condition.addChild(this.getCondition(criteriaListType));
            }
        }
    }

    private List<String> getServiceSupplyPoints(ServiceSupplyPointsType serviceSupplyPoints) {
        ArrayList<String> result = new ArrayList<String>();
        if (serviceSupplyPoints != null && Utils.isCollectionNotEmpty((Collection)serviceSupplyPoints.getServiceSupplyPoint())) {
            for (AttributedNonEmptyURIType nonEmptyURI : serviceSupplyPoints.getServiceSupplyPoint()) {
                result.add(nonEmptyURI.getValue());
            }
        }
        return result;
    }
}

