/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.dto.condition;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.tsl.Condition;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;

public class ExtendedKeyUsageCondition
implements Condition {
    private static final long serialVersionUID = -5969735320082024885L;
    private final List<String> extendedKeyUsageOids;

    public ExtendedKeyUsageCondition(List<String> oids) {
        this.extendedKeyUsageOids = oids;
    }

    public final List<String> getKeyPurposeIds() {
        return this.extendedKeyUsageOids == null ? Collections.emptyList() : Collections.unmodifiableList(this.extendedKeyUsageOids);
    }

    public boolean check(CertificateToken certificateToken) {
        if (Utils.isCollectionNotEmpty(this.extendedKeyUsageOids)) {
            for (String oid : this.extendedKeyUsageOids) {
                if (DSSASN1Utils.isExtendedKeyUsagePresent((CertificateToken)certificateToken, (ASN1ObjectIdentifier)new ASN1ObjectIdentifier(oid))) continue;
                return false;
            }
        }
        return true;
    }

    public String toString(String indent) {
        if (indent == null) {
            indent = "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(indent).append("ExtendedKeyUsageCondition: ").append(this.extendedKeyUsageOids).append('\n');
        return builder.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

