/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.token.AbstractKeyStoreTokenConnection;
import eu.europa.esig.dss.token.PasswordInputCallback;
import eu.europa.esig.dss.token.PrefilledPasswordCallback;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;
import java.util.UUID;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import sun.security.pkcs11.SunPKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public class Pkcs11SignatureToken
extends AbstractKeyStoreTokenConnection {
    private Provider _pkcs11Provider;
    private final String _pkcs11Path;
    private KeyStore _keyStore;
    private final PasswordInputCallback callback;
    private int slotIndex;

    public Pkcs11SignatureToken(String pkcs11Path) {
        this(pkcs11Path, (PasswordInputCallback)null);
    }

    public Pkcs11SignatureToken(String pkcs11Path, PasswordInputCallback callback) {
        this._pkcs11Path = pkcs11Path;
        this.callback = callback;
        this.slotIndex = 0;
    }

    public Pkcs11SignatureToken(String pkcs11Path, char[] password) {
        this(pkcs11Path, (PasswordInputCallback)new PrefilledPasswordCallback(password));
    }

    public Pkcs11SignatureToken(String pkcs11Path, PasswordInputCallback callback, int slotIndex) {
        this(pkcs11Path, callback);
        this.slotIndex = slotIndex;
    }

    public Pkcs11SignatureToken(String pkcs11Path, char[] password, int slotIndex) {
        this(pkcs11Path, password);
        this.slotIndex = slotIndex;
    }

    private Provider getProvider() {
        try {
            if (this._pkcs11Provider == null) {
                Provider[] providers = Security.getProviders();
                if (providers != null) {
                    for (Provider provider : providers) {
                        String providerInfo = provider.getInfo();
                        if (!providerInfo.contains(this.getPkcs11Path())) continue;
                        this._pkcs11Provider = provider;
                        return provider;
                    }
                }
                this.installProvider();
            }
            return this._pkcs11Provider;
        }
        catch (ProviderException ex) {
            throw new DSSException("Not a PKCS#11 library", (Throwable)ex);
        }
    }

    private void installProvider() {
        String aPKCS11LibraryFileName = this.getPkcs11Path();
        aPKCS11LibraryFileName = this.escapePath(aPKCS11LibraryFileName);
        String pkcs11ConfigSettings = "name = SmartCard" + UUID.randomUUID().toString() + "\nlibrary = \"" + aPKCS11LibraryFileName + "\"\nslotListIndex = " + this.slotIndex;
        byte[] pkcs11ConfigBytes = pkcs11ConfigSettings.getBytes();
        ByteArrayInputStream confStream = new ByteArrayInputStream(pkcs11ConfigBytes);
        SunPKCS11 pkcs11 = new SunPKCS11((InputStream)confStream);
        this._pkcs11Provider = pkcs11;
        Security.addProvider(this._pkcs11Provider);
    }

    private String escapePath(String pathToEscape) {
        if (pathToEscape != null) {
            return pathToEscape.replace("\\", "\\\\");
        }
        return "";
    }

    @Override
    KeyStore getKeyStore() throws DSSException {
        if (this._keyStore == null) {
            try {
                this._keyStore = KeyStore.getInstance("PKCS11", this.getProvider());
                this._keyStore.load(new KeyStore.LoadStoreParameter(){

                    @Override
                    public KeyStore.ProtectionParameter getProtectionParameter() {
                        return new KeyStore.CallbackHandlerProtection(new CallbackHandler(){

                            @Override
                            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                                for (Callback c : callbacks) {
                                    if (!(c instanceof PasswordCallback)) continue;
                                    ((PasswordCallback)c).setPassword(Pkcs11SignatureToken.this.callback.getPassword());
                                    return;
                                }
                                throw new RuntimeException("No password callback");
                            }
                        });
                    }
                });
            }
            catch (Exception e) {
                if (e instanceof PKCS11Exception && "CKR_PIN_INCORRECT".equals(e.getMessage())) {
                    throw new DSSException("Bad password for PKCS11", (Throwable)e);
                }
                throw new DSSException("Can't initialize Sun PKCS#11 security provider. Reason: " + e.getMessage(), (Throwable)e);
            }
        }
        return this._keyStore;
    }

    @Override
    KeyStore.ProtectionParameter getKeyProtectionParameter() {
        return null;
    }

    protected String getPkcs11Path() {
        return this._pkcs11Path;
    }

    public void close() {
        if (this._pkcs11Provider != null) {
            try {
                Security.removeProvider(this._pkcs11Provider.getName());
            }
            catch (Exception ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
        this._pkcs11Provider = null;
        this._keyStore = null;
    }
}

