/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.token.AbstractKeyStoreTokenConnection;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;

public class KeyStoreSignatureTokenConnection
extends AbstractKeyStoreTokenConnection {
    private final KeyStore keyStore;
    private final KeyStore.ProtectionParameter password;

    public KeyStoreSignatureTokenConnection(byte[] ksBytes, String ksType, String ksPassword) {
        this(new ByteArrayInputStream(ksBytes), ksType, ksPassword);
    }

    public KeyStoreSignatureTokenConnection(String filepath, String ksType, String ksPassword) throws IOException {
        this(new File(filepath), ksType, ksPassword);
    }

    public KeyStoreSignatureTokenConnection(File ksFile, String ksType, String ksPassword) throws IOException {
        this(new FileInputStream(ksFile), ksType, ksPassword);
    }

    public KeyStoreSignatureTokenConnection(InputStream ksStream, String ksType, String ksPassword) {
        try {
            this.keyStore = KeyStore.getInstance(ksType);
            this.password = this.createProtectionParameter(ksPassword);
            this.keyStore.load(ksStream, ((KeyStore.PasswordProtection)this.password).getPassword());
        }
        catch (Exception e) {
            throw new DSSException((Throwable)e);
        }
        finally {
            if (ksStream != null) {
                try {
                    ksStream.close();
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void close() {
    }

    @Override
    KeyStore getKeyStore() {
        return this.keyStore;
    }

    @Override
    KeyStore.ProtectionParameter getKeyProtectionParameter() {
        return this.password;
    }
}

