/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.tsl;

import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.identifier.IdentifierBasedObject;
import eu.europa.esig.dss.spi.tsl.DownloadInfoRecord;
import eu.europa.esig.dss.spi.tsl.MRA;
import eu.europa.esig.dss.spi.tsl.OtherTSLPointer;
import eu.europa.esig.dss.spi.tsl.ParsingInfoRecord;
import eu.europa.esig.dss.spi.tsl.ValidationInfoRecord;
import eu.europa.esig.dss.spi.tsl.identifier.TrustedListIdentifier;
import java.io.Serializable;
import java.util.Objects;

public class TLInfo
implements IdentifierBasedObject,
Serializable {
    private static final long serialVersionUID = -1505115221927652721L;
    private final String url;
    private final TLInfo parent;
    private final DownloadInfoRecord downloadCacheInfo;
    private final ParsingInfoRecord parsingCacheInfo;
    private final ValidationInfoRecord validationCacheInfo;
    private final OtherTSLPointer otherTSLPointer;
    private Identifier identifier;

    public TLInfo(DownloadInfoRecord downloadCacheInfo, ParsingInfoRecord parsingCacheInfo, ValidationInfoRecord validationCacheInfo, String url) {
        this(downloadCacheInfo, parsingCacheInfo, validationCacheInfo, url, null);
    }

    public TLInfo(DownloadInfoRecord downloadCacheInfo, ParsingInfoRecord parsingCacheInfo, ValidationInfoRecord validationCacheInfo, String url, TLInfo parent) {
        this(downloadCacheInfo, parsingCacheInfo, validationCacheInfo, url, parent, null);
    }

    public TLInfo(DownloadInfoRecord downloadCacheInfo, ParsingInfoRecord parsingCacheInfo, ValidationInfoRecord validationCacheInfo, String url, TLInfo parent, OtherTSLPointer otherTSLPointer) {
        Objects.requireNonNull(url, "URL String shall be provided!");
        this.downloadCacheInfo = downloadCacheInfo;
        this.parsingCacheInfo = parsingCacheInfo;
        this.validationCacheInfo = validationCacheInfo;
        this.url = url;
        this.parent = parent;
        this.otherTSLPointer = otherTSLPointer;
    }

    public DownloadInfoRecord getDownloadCacheInfo() {
        return this.downloadCacheInfo;
    }

    public ParsingInfoRecord getParsingCacheInfo() {
        return this.parsingCacheInfo;
    }

    public ValidationInfoRecord getValidationCacheInfo() {
        return this.validationCacheInfo;
    }

    public String getUrl() {
        return this.url;
    }

    public TLInfo getParent() {
        return this.parent;
    }

    public OtherTSLPointer getOtherTSLPointer() {
        return this.otherTSLPointer;
    }

    @Deprecated
    public MRA getMra() {
        OtherTSLPointer otherTSLPointer = this.getOtherTSLPointer();
        if (otherTSLPointer != null) {
            return this.getOtherTSLPointer().getMra();
        }
        return null;
    }

    public Identifier getDSSId() {
        if (this.identifier == null) {
            this.identifier = this.buildIdentifier();
        }
        return this.identifier;
    }

    protected Identifier buildIdentifier() {
        return new TrustedListIdentifier(this);
    }

    public String getDSSIdAsString() {
        return this.getDSSId().asXmlId();
    }
}

