/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation.ocsp;

import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.ResponderId;
import eu.europa.esig.dss.spi.x509.revocation.RevocationRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRefIdentifier;
import eu.europa.esig.dss.utils.Utils;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.esf.OcspResponsesID;

public class OCSPRef
extends RevocationRef<OCSP> {
    private static final long serialVersionUID = -4757221403735075782L;
    private Date producedAt;
    private ResponderId responderId;

    public OCSPRef(Digest digest, Date producedAt, ResponderId responderId) {
        this.digest = digest;
        this.producedAt = producedAt;
        this.responderId = responderId;
    }

    public OCSPRef(OcspResponsesID ocspResponsesID) {
        this.digest = DSSRevocationUtils.getDigest(ocspResponsesID.getOcspRepHash());
        this.producedAt = DSSASN1Utils.getDate((ASN1Encodable)ocspResponsesID.getOcspIdentifier().getProducedAt());
        this.responderId = DSSRevocationUtils.getDSSResponderId(ocspResponsesID.getOcspIdentifier().getOcspResponderID());
    }

    public Date getProducedAt() {
        return this.producedAt;
    }

    public ResponderId getResponderId() {
        return this.responderId;
    }

    @Override
    protected Identifier createIdentifier() {
        return new OCSPRefIdentifier(this);
    }

    @Override
    public String toString() {
        if (this.responderId.getX500Principal() != null) {
            return "OCSP Reference produced at [" + DSSUtils.formatInternal(this.producedAt) + "] with Responder Name: [" + this.responderId.getX500Principal() + "]";
        }
        return "OCSP Reference produced at [" + DSSUtils.formatInternal(this.producedAt) + "] with Responder key 64base: [" + Utils.toBase64((byte[])this.responderId.getSki()) + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.producedAt == null ? 0 : this.producedAt.hashCode());
        result = 31 * result + (this.responderId == null ? 0 : this.responderId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OCSPRef other = (OCSPRef)obj;
        if (this.producedAt == null ? other.producedAt != null : !this.producedAt.equals(other.producedAt)) {
            return false;
        }
        return !(this.responderId == null ? other.responderId != null : !this.responderId.equals(other.responderId));
    }
}

