/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509;

import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.ResponderId;
import eu.europa.esig.dss.spi.x509.SignerIdentifier;
import java.util.Arrays;

public class CertificateTokenRefMatcher {
    public boolean match(CertificateToken certificateToken, CertificateRef certificateRef) {
        if (certificateToken == null) {
            return false;
        }
        Digest certDigest = certificateRef.getCertDigest();
        SignerIdentifier signerIdentifier = certificateRef.getCertificateIdentifier();
        ResponderId responderId = certificateRef.getResponderId();
        if (certDigest != null) {
            return this.matchByDigest(certificateToken, certificateRef);
        }
        if (signerIdentifier != null && signerIdentifier.isRelatedToCertificate(certificateToken)) {
            return true;
        }
        return responderId != null && responderId.isRelatedToCertificate(certificateToken);
    }

    public boolean matchByDigest(CertificateToken certificateToken, CertificateRef certificateRef) {
        Digest certDigest = certificateRef.getCertDigest();
        if (certDigest != null) {
            byte[] currentDigest = certificateToken.getDigest(certDigest.getAlgorithm());
            return Arrays.equals(currentDigest, certDigest.getValue());
        }
        return false;
    }

    public boolean matchBySerialNumber(CertificateToken certificateToken, CertificateRef certificateRef) {
        SignerIdentifier signerIdentifier = certificateRef.getCertificateIdentifier();
        if (signerIdentifier != null && signerIdentifier.getSerialNumber() != null) {
            return certificateToken.getSerialNumber().equals(signerIdentifier.getSerialNumber());
        }
        return false;
    }

    public boolean matchByIssuerName(CertificateToken certificateToken, CertificateRef certificateRef) {
        SignerIdentifier signerIdentifier = certificateRef.getCertificateIdentifier();
        if (signerIdentifier != null && signerIdentifier.getIssuerName() != null) {
            return DSSASN1Utils.x500PrincipalAreEquals(signerIdentifier.getIssuerName(), certificateToken.getIssuerX500Principal());
        }
        return false;
    }

    public boolean matchByResponderId(CertificateToken certificateToken, CertificateRef certificateRef) {
        ResponderId responderId = certificateRef.getResponderId();
        if (responderId != null) {
            return responderId.isRelatedToCertificate(certificateToken);
        }
        return false;
    }
}

