/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.tsl;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.tsl.TrustServiceStatusAndInformationExtensions;
import eu.europa.esig.dss.spi.util.TimeDependentValues;
import java.io.Serializable;
import java.util.List;

public class TrustService
implements Serializable {
    private static final long serialVersionUID = -7162121430380199621L;
    private final List<CertificateToken> certificates;
    private final TimeDependentValues<TrustServiceStatusAndInformationExtensions> status;

    public TrustService(List<CertificateToken> certificates, TimeDependentValues<TrustServiceStatusAndInformationExtensions> status) {
        this.certificates = certificates;
        this.status = status;
    }

    public List<CertificateToken> getCertificates() {
        return this.certificates;
    }

    public TimeDependentValues<TrustServiceStatusAndInformationExtensions> getStatusAndInformationExtensions() {
        return this.status;
    }

    public static final class TrustServiceBuilder {
        private List<CertificateToken> certificates;
        private TimeDependentValues<TrustServiceStatusAndInformationExtensions> status;

        public TrustServiceBuilder setCertificates(List<CertificateToken> certificates) {
            this.certificates = certificates;
            return this;
        }

        public TrustServiceBuilder setStatusAndInformationExtensions(TimeDependentValues<TrustServiceStatusAndInformationExtensions> status) {
            this.status = status;
            return this;
        }

        public TrustService build() {
            return new TrustService(this.certificates, this.status);
        }
    }
}

