/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.client.http;

import eu.europa.esig.dss.spi.client.http.DataLoader;
import eu.europa.esig.dss.spi.client.http.NativeDataLoaderCall;
import eu.europa.esig.dss.spi.exception.DSSExternalResourceException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeHTTPDataLoader
implements DataLoader {
    private static final long serialVersionUID = 4075489539157157286L;
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeHTTPDataLoader.class);
    private long maxInputSize;
    private long timeout = 0L;

    protected byte[] request(String url, HttpMethod method, byte[] content, boolean refresh) {
        NativeDataLoaderCall task = new NativeDataLoaderCall(url, content, refresh, this.maxInputSize);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            Future<byte[]> result = executorService.submit(task);
            byte[] byArray = this.timeout > 0L ? result.get(this.timeout, TimeUnit.MILLISECONDS) : result.get();
            return byArray;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DSSExternalResourceException(e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new DSSExternalResourceException(e);
        }
        finally {
            executorService.shutdown();
        }
    }

    @Override
    public DataLoader.DataAndUrl get(List<String> urlStrings) {
        for (String urlString : urlStrings) {
            try {
                byte[] bytes = this.get(urlString);
                if (bytes == null) continue;
                return new DataLoader.DataAndUrl(urlString, bytes);
            }
            catch (Exception e) {
                LOGGER.warn("Impossible to obtain data using {}", (Object)urlString, (Object)e);
            }
        }
        throw new DSSExternalResourceException(String.format("No data have been obtained from urls : %s", urlStrings));
    }

    @Override
    public byte[] get(String url) {
        return this.get(url, false);
    }

    @Override
    public byte[] get(String url, boolean refresh) {
        return this.request(url, HttpMethod.GET, null, !refresh);
    }

    @Override
    public byte[] post(String url, byte[] content) {
        return this.request(url, HttpMethod.POST, content, false);
    }

    @Override
    public void setContentType(String contentType) {
        throw new UnsupportedOperationException("Content type change is not supported by this implementation!");
    }

    public long getMaxInputSize() {
        return this.maxInputSize;
    }

    public void setMaxInputSize(long maxInputSize) {
        this.maxInputSize = maxInputSize;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    protected static enum HttpMethod {
        GET,
        POST;

    }
}

