/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.tsl;

import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.spi.tsl.LOTLInfo;
import eu.europa.esig.dss.spi.tsl.TLInfo;
import eu.europa.esig.dss.utils.Utils;
import java.io.Serializable;
import java.util.List;

public class TLValidationJobSummary
implements Serializable {
    private final List<LOTLInfo> lotlInfos;
    private final List<TLInfo> otherTLInfos;

    public TLValidationJobSummary(List<LOTLInfo> lotlInfos, List<TLInfo> otherTLInfos) {
        this.lotlInfos = lotlInfos;
        this.otherTLInfos = otherTLInfos;
    }

    public List<LOTLInfo> getLOTLInfos() {
        return this.lotlInfos;
    }

    public List<TLInfo> getOtherTLInfos() {
        return this.otherTLInfos;
    }

    public int getNumberOfProcessedTLs() {
        int amount = 0;
        if (Utils.isCollectionNotEmpty(this.otherTLInfos)) {
            amount += this.otherTLInfos.size();
        }
        if (Utils.isCollectionNotEmpty(this.lotlInfos)) {
            for (LOTLInfo lotlInfo : this.lotlInfos) {
                amount += lotlInfo.getTLInfos().size();
            }
        }
        return amount;
    }

    public int getNumberOfProcessedLOTLs() {
        if (Utils.isCollectionNotEmpty(this.lotlInfos)) {
            return this.lotlInfos.size();
        }
        return 0;
    }

    public TLInfo getTLInfoById(Identifier identifier) {
        if (Utils.isCollectionNotEmpty(this.otherTLInfos)) {
            for (TLInfo tlInfo : this.otherTLInfos) {
                if (!identifier.equals((Object)tlInfo.getIdentifier())) continue;
                return tlInfo;
            }
        }
        if (Utils.isCollectionNotEmpty(this.lotlInfos)) {
            for (LOTLInfo lotlInfo : this.lotlInfos) {
                for (TLInfo tlInfo : lotlInfo.getTLInfos()) {
                    if (!identifier.equals((Object)tlInfo.getIdentifier())) continue;
                    return tlInfo;
                }
            }
        }
        return null;
    }

    public LOTLInfo getLOTLInfoById(Identifier identifier) {
        if (Utils.isCollectionNotEmpty(this.lotlInfos)) {
            for (LOTLInfo lotlInfo : this.lotlInfos) {
                if (!identifier.equals((Object)lotlInfo.getIdentifier())) continue;
                return lotlInfo;
            }
        }
        return null;
    }
}

