/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.tsl;

import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.tsl.CertificatePivotStatus;
import eu.europa.esig.dss.spi.tsl.DownloadInfoRecord;
import eu.europa.esig.dss.spi.tsl.LOTLInfo;
import eu.europa.esig.dss.spi.tsl.ParsingInfoRecord;
import eu.europa.esig.dss.spi.tsl.ValidationInfoRecord;
import eu.europa.esig.dss.spi.tsl.identifier.PivotIdentifier;
import java.util.HashMap;
import java.util.Map;

public class PivotInfo
extends LOTLInfo {
    private static final long serialVersionUID = 1724138551018429654L;
    private Map<CertificateToken, CertificatePivotStatus> certificateStatusMap = new HashMap<CertificateToken, CertificatePivotStatus>();
    private String lotlLocation;

    public PivotInfo(DownloadInfoRecord downloadCacheInfo, ParsingInfoRecord parsingCacheInfo, ValidationInfoRecord validationCacheInfo, String url, Map<CertificateToken, CertificatePivotStatus> certificates, String lotlLocation) {
        super(downloadCacheInfo, parsingCacheInfo, validationCacheInfo, url);
        this.certificateStatusMap = certificates;
        this.lotlLocation = lotlLocation;
    }

    public Map<CertificateToken, CertificatePivotStatus> getCertificateStatusMap() {
        return this.certificateStatusMap;
    }

    public String getLOTLLocation() {
        return this.lotlLocation;
    }

    @Override
    public boolean isPivot() {
        return true;
    }

    @Override
    public Identifier getIdentifier() {
        return new PivotIdentifier(this);
    }
}

