/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import eu.europa.esig.dss.DSSException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;

public class ResourceLoader {
    protected Class<?> anyClass = ResourceLoader.class;

    public ResourceLoader() {
    }

    public ResourceLoader(Class<?> anyClass) {
        this.anyClass = anyClass;
    }

    public static String getNormalizedFileName(String fileName) {
        String normalizedFileName = fileName.replaceAll("\\W", "_");
        return normalizedFileName;
    }

    public String getAbsoluteResourceFolder(String resourcePath) throws DSSException {
        URL uri = this.anyClass.getResource(resourcePath);
        if (uri == null) {
            return null;
        }
        String absolutePath = uri.getPath();
        try {
            String decodedAbsolutePath = URLDecoder.decode(absolutePath, "UTF-8");
            return decodedAbsolutePath;
        }
        catch (UnsupportedEncodingException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public InputStream getResource(String resourcePath) {
        InputStream resourceAsStream = this.anyClass.getResourceAsStream(resourcePath);
        return resourceAsStream;
    }
}

