/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.service.crl;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.crl.CRLValidity;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.revocation.JdbcRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationException;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLSource;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcCacheCRLSource
extends JdbcRevocationSource<CRL>
implements CRLSource {
    private static final long serialVersionUID = 3007740140330998336L;
    private static final Logger LOG = LoggerFactory.getLogger(JdbcCacheCRLSource.class);
    private static final String SQL_INIT_CHECK_EXISTENCE = "SELECT COUNT(*) FROM CACHED_CRL";
    private static final String SQL_INIT_CREATE_TABLE = "CREATE TABLE CACHED_CRL (ID CHAR(40), DATA BLOB, ISSUER LONGVARBINARY)";
    private static final String SQL_FIND_QUERY = "SELECT * FROM CACHED_CRL WHERE ID = ?";
    private static final String SQL_FIND_QUERY_ID = "ID";
    private static final String SQL_FIND_QUERY_DATA = "DATA";
    private static final String SQL_FIND_QUERY_ISSUER = "ISSUER";
    private static final String SQL_FIND_INSERT = "INSERT INTO CACHED_CRL (ID, DATA, ISSUER) VALUES (?, ?, ?)";
    private static final String SQL_FIND_UPDATE = "UPDATE CACHED_CRL SET DATA = ?, ISSUER = ?  WHERE ID = ?";
    private static final String SQL_FIND_REMOVE = "DELETE FROM CACHED_CRL WHERE ID = ?";
    private static final String SQL_DROP_TABLE = "DROP TABLE CACHED_CRL";

    protected String getCreateTableQuery() {
        return SQL_INIT_CREATE_TABLE;
    }

    protected String getTableExistenceQuery() {
        return SQL_INIT_CHECK_EXISTENCE;
    }

    protected String getFindRevocationQuery() {
        return SQL_FIND_QUERY;
    }

    protected String getRemoveRevocationTokenEntryQuery() {
        return SQL_FIND_REMOVE;
    }

    protected String getDeleteTableQuery() {
        return SQL_DROP_TABLE;
    }

    public List<String> initRevocationTokenKey(CertificateToken certificateToken) {
        return DSSRevocationUtils.getCRLRevocationTokenKeys((CertificateToken)certificateToken);
    }

    protected RevocationToken<CRL> buildRevocationTokenFromResult(ResultSet rs, CertificateToken certificateToken, CertificateToken issuerCert) {
        try {
            CRLBinary crlBinary = CRLUtils.buildCRLBinary((byte[])rs.getBytes(SQL_FIND_QUERY_DATA));
            CertificateToken cachedIssuerCertificate = DSSUtils.loadCertificate((byte[])rs.getBytes(SQL_FIND_QUERY_ISSUER));
            CRLValidity cached = CRLUtils.buildCRLValidity((CRLBinary)crlBinary, (CertificateToken)cachedIssuerCertificate);
            cached.setKey(rs.getString(SQL_FIND_QUERY_ID));
            cached.setIssuerToken(cachedIssuerCertificate);
            CRLToken crlToken = new CRLToken(certificateToken, cached);
            crlToken.setExternalOrigin(RevocationOrigin.CACHED);
            return crlToken;
        }
        catch (Exception e) {
            throw new RevocationException(String.format("An error occurred during an attempt to get a revocation token. Reason : %s", e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertRevocation(RevocationToken<CRL> token) {
        Connection c = null;
        PreparedStatement s = null;
        CRLToken crlToken = (CRLToken)token;
        CRLValidity crlValidity = crlToken.getCrlValidity();
        try {
            c = this.dataSource.getConnection();
            s = c.prepareStatement(SQL_FIND_INSERT);
            s.setString(1, token.getRevocationTokenKey());
            s.setBytes(2, crlValidity.getDerEncoded());
            s.setBytes(3, crlValidity.getIssuerToken().getEncoded());
            s.executeUpdate();
            c.commit();
            LOG.debug("CRL token with key '{}' successfully inserted in DB", (Object)token.getRevocationTokenKey());
        }
        catch (SQLException e) {
            try {
                LOG.error("Unable to insert CRL {} into the DB. Cause : '{}'", new Object[]{token, e.getMessage(), e});
                this.rollback(c);
            }
            catch (Throwable throwable) {
                this.closeQuietly(c, s, null);
                throw throwable;
            }
            this.closeQuietly(c, s, null);
        }
        this.closeQuietly(c, s, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRevocation(RevocationToken<CRL> token) {
        Connection c = null;
        PreparedStatement s = null;
        CRLToken crlToken = (CRLToken)token;
        CRLValidity crlValidity = crlToken.getCrlValidity();
        try {
            c = this.dataSource.getConnection();
            s = c.prepareStatement(SQL_FIND_UPDATE);
            s.setBytes(1, crlValidity.getDerEncoded());
            s.setBytes(2, crlValidity.getIssuerToken().getEncoded());
            s.setString(3, token.getRevocationTokenKey());
            s.executeUpdate();
            c.commit();
            LOG.debug("CRL token with key '{}' successfully updated in DB", (Object)token.getRevocationTokenKey());
        }
        catch (SQLException e) {
            try {
                LOG.error("Unable to update CRL {} into the DB. Cause : '{}'", new Object[]{token, e.getMessage(), e});
                this.rollback(c);
            }
            catch (Throwable throwable) {
                this.closeQuietly(c, s, null);
                throw throwable;
            }
            this.closeQuietly(c, s, null);
        }
        this.closeQuietly(c, s, null);
    }

    public CRLToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        return (CRLToken)super.getRevocationToken(certificateToken, issuerCertificateToken);
    }

    public CRLToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken, boolean forceRefresh) {
        return (CRLToken)super.getRevocationToken(certificateToken, issuerCertificateToken, forceRefresh);
    }
}

