/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.client.ocsp;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSRevocationUtils;
import eu.europa.esig.dss.client.NonceSource;
import eu.europa.esig.dss.client.http.DataLoader;
import eu.europa.esig.dss.client.http.commons.OCSPDataLoader;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.ocsp.OCSPRespStatus;
import eu.europa.esig.dss.x509.ocsp.OCSPSource;
import eu.europa.esig.dss.x509.ocsp.OCSPToken;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Provider;
import java.security.Security;
import java.util.Collection;
import java.util.List;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineOCSPSource
implements OCSPSource {
    private static final Logger LOG = LoggerFactory.getLogger(OnlineOCSPSource.class);
    private NonceSource nonceSource;
    private DataLoader dataLoader = new OCSPDataLoader();

    public void setDataLoader(DataLoader dataLoader) {
        this.dataLoader = dataLoader;
    }

    public void setNonceSource(NonceSource nonceSource) {
        this.nonceSource = nonceSource;
    }

    public OCSPToken getOCSPToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        if (this.dataLoader == null) {
            throw new NullPointerException("DataLoader is not provided !");
        }
        try {
            byte[] content;
            byte[] ocspRespBytes;
            String dssIdAsString = certificateToken.getDSSIdAsString();
            LOG.trace("--> OnlineOCSPSource queried for " + dssIdAsString);
            List ocspAccessLocations = DSSASN1Utils.getOCSPAccessLocations((CertificateToken)certificateToken);
            if (Utils.isCollectionEmpty((Collection)ocspAccessLocations)) {
                LOG.debug("No OCSP location found for " + dssIdAsString);
                certificateToken.extraInfo().infoNoOcspUriFoundInCertificate();
                return null;
            }
            String ocspAccessLocation = (String)ocspAccessLocations.get(0);
            CertificateID certId = DSSRevocationUtils.getOCSPCertificateID((CertificateToken)certificateToken, (CertificateToken)issuerCertificateToken);
            BigInteger nonce = null;
            if (this.nonceSource != null) {
                nonce = this.nonceSource.getNonce();
            }
            if (Utils.isArrayEmpty((byte[])(ocspRespBytes = this.dataLoader.post(ocspAccessLocation, content = this.buildOCSPRequest(certId, nonce))))) {
                return null;
            }
            OCSPResp ocspResp = new OCSPResp(ocspRespBytes);
            OCSPRespStatus status = OCSPRespStatus.fromInt((int)ocspResp.getStatus());
            if (OCSPRespStatus.SUCCESSFUL.equals((Object)status)) {
                OCSPToken ocspToken = new OCSPToken();
                ocspToken.setResponseStatus(status);
                ocspToken.setSourceURL(ocspAccessLocation);
                ocspToken.setCertId(certId);
                ocspToken.setAvailable(true);
                BasicOCSPResp basicOCSPResp = (BasicOCSPResp)ocspResp.getResponseObject();
                ocspToken.setBasicOCSPResp(basicOCSPResp);
                if (this.nonceSource != null) {
                    ocspToken.setUseNonce(true);
                    ocspToken.setNonceMatch(this.isNonceMatch(basicOCSPResp, nonce));
                }
                return ocspToken;
            }
            certificateToken.extraInfo().infoOCSPException("OCSP Response status : " + status);
            return null;
        }
        catch (OCSPException e) {
            throw new DSSException((Throwable)e);
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
    }

    private byte[] buildOCSPRequest(CertificateID certId, BigInteger nonce) throws DSSException {
        try {
            OCSPReqBuilder ocspReqBuilder = new OCSPReqBuilder();
            ocspReqBuilder.addRequest(certId);
            if (nonce != null) {
                DEROctetString encodedNonceValue = new DEROctetString(new DEROctetString(nonce.toByteArray()).getEncoded());
                Extension extension = new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, (ASN1OctetString)encodedNonceValue);
                Extensions extensions = new Extensions(extension);
                ocspReqBuilder.setRequestExtensions(extensions);
            }
            OCSPReq ocspReq = ocspReqBuilder.build();
            byte[] ocspReqData = ocspReq.getEncoded();
            return ocspReqData;
        }
        catch (OCSPException e) {
            throw new DSSException("Cannot build OCSP Request", (Throwable)e);
        }
        catch (IOException e) {
            throw new DSSException("Cannot build OCSP Request", (Throwable)e);
        }
    }

    private boolean isNonceMatch(BasicOCSPResp basicOCSPResp, BigInteger expectedNonceValue) {
        ASN1Primitive value;
        Extension extension = basicOCSPResp.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
        ASN1OctetString extnValue = extension.getExtnValue();
        try {
            value = ASN1Primitive.fromByteArray((byte[])extnValue.getOctets());
        }
        catch (IOException ex) {
            LOG.warn("Invalid encoding of nonce extension value in OCSP response", (Throwable)ex);
            return false;
        }
        if (value instanceof DEROctetString) {
            BigInteger receivedNonce = new BigInteger(((DEROctetString)value).getOctets());
            return expectedNonceValue.equals(receivedNonce);
        }
        LOG.warn("Nonce extension value in OCSP response is not an OCTET STRING");
        return false;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

