/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.client.http.commons;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public final class DefaultTrustManager
implements X509TrustManager {
    private X509TrustManager trustManager;

    public DefaultTrustManager(KeyStore keystore) throws GeneralSecurityException {
        TrustManager[] tms;
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keystore);
        for (TrustManager tm : tms = tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            this.trustManager = (X509TrustManager)tm;
            return;
        }
        throw new NoSuchAlgorithmException("No X509TrustManager in TrustManagerFactory");
    }

    public DefaultTrustManager(InputStream tsInputStream, String tsType, String tsPasswd) throws GeneralSecurityException, IOException {
        KeyStore keystore = KeyStore.getInstance(tsType);
        keystore.load(tsInputStream, tsPasswd.toCharArray());
        this.initTrustManager(keystore);
    }

    private void initTrustManager(KeyStore keystore) throws GeneralSecurityException {
        TrustManager[] tms;
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keystore);
        for (TrustManager tm : tms = tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            this.trustManager = (X509TrustManager)tm;
            return;
        }
        throw new NoSuchAlgorithmException("No X509TrustManager in TrustManagerFactory");
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.trustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.trustManager.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }
}

