/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.client.crl;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.SignatureAlgorithm;
import eu.europa.esig.dss.client.crl.OnlineCRLSource;
import eu.europa.esig.dss.crl.CRLValidity;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.crl.CRLSource;
import eu.europa.esig.dss.x509.crl.CRLToken;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcCacheCRLSource
implements CRLSource {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcCacheCRLSource.class);
    private static final String SQL_INIT_CHECK_EXISTENCE = "SELECT COUNT(*) FROM CACHED_CRL";
    private static final String SQL_INIT_CREATE_TABLE = "CREATE TABLE CACHED_CRL (ID CHAR(40), DATA LONGVARBINARY, SIGNATURE_ALGORITHM VARCHAR(20), THIS_UPDATE TIMESTAMP, NEXT_UPDATE TIMESTAMP, EXPIRED_CERTS_ON_CRL TIMESTAMP, ISSUER LONGVARBINARY, ISSUER_PRINCIPAL_MATCH BOOLEAN, SIGNATURE_INTACT BOOLEAN, CRL_SIGN_KEY_USAGE BOOLEAN, UNKNOWN_CRITICAL_EXTENSION BOOLEAN, SIGNATURE_INVALID_REASON VARCHAR(256))";
    private static final String SQL_FIND_QUERY = "SELECT * FROM CACHED_CRL WHERE ID = ?";
    private static final String SQL_FIND_QUERY_ID = "ID";
    private static final String SQL_FIND_QUERY_DATA = "DATA";
    private static final String SQL_FIND_QUERY_ISSUER = "ISSUER";
    private static final String SQL_FIND_QUERY_THIS_UPDATE = "THIS_UPDATE";
    private static final String SQL_FIND_QUERY_NEXT_UPDATE = "NEXT_UPDATE";
    private static final String SQL_FIND_QUERY_EXPIRED_CERTS_ON_CRL = "EXPIRED_CERTS_ON_CRL";
    private static final String SQL_FIND_QUERY_SIGNATURE_ALGO = "SIGNATURE_ALGORITHM";
    private static final String SQL_FIND_QUERY_ISSUER_PRINCIPAL_MATCH = "ISSUER_PRINCIPAL_MATCH";
    private static final String SQL_FIND_QUERY_SIGNATURE_INTACT = "SIGNATURE_INTACT";
    private static final String SQL_FIND_QUERY_CRL_SIGN_KEY_USAGE = "CRL_SIGN_KEY_USAGE";
    private static final String SQL_FIND_QUERY_UNKNOWN_CRITICAL_EXTENSION = "UNKNOWN_CRITICAL_EXTENSION";
    private static final String SQL_FIND_QUERY_SIGNATURE_INVALID_REASON = "SIGNATURE_INVALID_REASON";
    private static final String SQL_FIND_INSERT = "INSERT INTO CACHED_CRL (ID, DATA, SIGNATURE_ALGORITHM, THIS_UPDATE, NEXT_UPDATE, EXPIRED_CERTS_ON_CRL, ISSUER, ISSUER_PRINCIPAL_MATCH, SIGNATURE_INTACT, CRL_SIGN_KEY_USAGE, UNKNOWN_CRITICAL_EXTENSION, SIGNATURE_INVALID_REASON) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String SQL_FIND_UPDATE = "UPDATE CACHED_CRL SET DATA = ?, SIGNATURE_ALGORITHM = ?, THIS_UPDATE = ?, NEXT_UPDATE = ?, EXPIRED_CERTS_ON_CRL = ?, ISSUER = ?, ISSUER_PRINCIPAL_MATCH = ?, SIGNATURE_INTACT = ?, CRL_SIGN_KEY_USAGE = ?, UNKNOWN_CRITICAL_EXTENSION = ?, SIGNATURE_INVALID_REASON = ?  WHERE ID = ?";
    private OnlineCRLSource cachedSource;
    private DataSource dataSource;

    public CRLToken findCrl(CertificateToken certificateToken) throws DSSException {
        if (certificateToken == null) {
            return null;
        }
        CertificateToken issuerToken = certificateToken.getIssuerToken();
        if (issuerToken == null) {
            return null;
        }
        List crlUrls = DSSASN1Utils.getCrlUrls((CertificateToken)certificateToken);
        if (Utils.isCollectionEmpty((Collection)crlUrls)) {
            return null;
        }
        String crlUrl = (String)crlUrls.get(0);
        LOG.info("CRL's URL for " + certificateToken.getAbbreviation() + " : " + crlUrl);
        try {
            CRLToken crlToken;
            String key = DSSUtils.getSHA1Digest((String)crlUrl);
            CRLValidity storedValidity = this.findCrlInDB(key);
            if (storedValidity != null && storedValidity.getNextUpdate().after(new Date())) {
                LOG.debug("CRL in cache");
                crlToken = new CRLToken(certificateToken, storedValidity);
                crlToken.setSourceURL(crlUrl);
                if (crlToken.isValid()) {
                    return crlToken;
                }
            }
            if ((crlToken = this.cachedSource.findCrl(certificateToken)) != null && crlToken.isValid()) {
                if (storedValidity == null) {
                    LOG.info("CRL '{}' not in cache", (Object)crlUrl);
                    this.insertCrlInDb(key, crlToken.getCrlValidity());
                } else {
                    LOG.debug("CRL '{}' expired", (Object)crlUrl);
                    this.updateCrlInDb(key, crlToken.getCrlValidity());
                }
            }
            return crlToken;
        }
        catch (SQLException e) {
            LOG.info("Error with the cache data store", (Throwable)e);
            return null;
        }
    }

    public void setCachedSource(OnlineCRLSource cachedSource) {
        this.cachedSource = cachedSource;
    }

    private void initDao() throws Exception {
        if (!this.tableExists()) {
            this.createTable();
        }
    }

    private void createTable() throws SQLException {
        Connection c = null;
        Statement s = null;
        try {
            c = this.getDataSource().getConnection();
            s = c.createStatement();
            s.executeQuery(SQL_INIT_CREATE_TABLE);
            c.commit();
        }
        finally {
            this.closeQuietly(c, s, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tableExists() {
        boolean tableExists;
        Connection c = null;
        Statement s = null;
        try {
            c = this.getDataSource().getConnection();
            s = c.createStatement();
            s.executeQuery(SQL_INIT_CHECK_EXISTENCE);
            tableExists = true;
        }
        catch (SQLException e) {
            tableExists = false;
        }
        finally {
            this.closeQuietly(c, s, null);
        }
        return tableExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CRLValidity findCrlInDB(String key) throws SQLException {
        Connection c = null;
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            c = this.getDataSource().getConnection();
            s = c.prepareStatement(SQL_FIND_QUERY);
            s.setString(1, key);
            rs = s.executeQuery();
            if (rs.next()) {
                CRLValidity cached = new CRLValidity();
                cached.setKey(rs.getString(SQL_FIND_QUERY_ID));
                cached.setCrlEncoded(rs.getBytes(SQL_FIND_QUERY_DATA));
                cached.setSignatureAlgorithm(SignatureAlgorithm.valueOf((String)rs.getString(SQL_FIND_QUERY_SIGNATURE_ALGO)));
                cached.setThisUpdate((Date)rs.getTimestamp(SQL_FIND_QUERY_THIS_UPDATE));
                cached.setNextUpdate((Date)rs.getTimestamp(SQL_FIND_QUERY_NEXT_UPDATE));
                cached.setExpiredCertsOnCRL((Date)rs.getTimestamp(SQL_FIND_QUERY_EXPIRED_CERTS_ON_CRL));
                cached.setIssuerToken(DSSUtils.loadCertificate((byte[])rs.getBytes(SQL_FIND_QUERY_ISSUER)));
                cached.setCrlSignKeyUsage(rs.getBoolean(SQL_FIND_QUERY_CRL_SIGN_KEY_USAGE));
                cached.setUnknownCriticalExtension(rs.getBoolean(SQL_FIND_QUERY_UNKNOWN_CRITICAL_EXTENSION));
                cached.setIssuerX509PrincipalMatches(rs.getBoolean(SQL_FIND_QUERY_ISSUER_PRINCIPAL_MATCH));
                cached.setSignatureIntact(rs.getBoolean(SQL_FIND_QUERY_SIGNATURE_INTACT));
                cached.setSignatureInvalidityReason(rs.getString(SQL_FIND_QUERY_SIGNATURE_INVALID_REASON));
                CRLValidity cRLValidity = cached;
                this.closeQuietly(c, s, rs);
                return cRLValidity;
            }
            this.closeQuietly(c, s, rs);
        }
        catch (Throwable throwable) {
            this.closeQuietly(c, s, rs);
            throw throwable;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertCrlInDb(String key, CRLValidity token) throws SQLException {
        Connection c = null;
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            c = this.getDataSource().getConnection();
            s = c.prepareStatement(SQL_FIND_INSERT);
            s.setString(1, key);
            s.setBytes(2, token.getCrlEncoded());
            s.setString(3, token.getSignatureAlgorithm().name());
            if (token.getThisUpdate() != null) {
                s.setTimestamp(4, new Timestamp(token.getThisUpdate().getTime()));
            } else {
                s.setNull(4, 93);
            }
            if (token.getNextUpdate() != null) {
                s.setTimestamp(5, new Timestamp(token.getNextUpdate().getTime()));
            } else {
                s.setNull(5, 93);
            }
            if (token.getExpiredCertsOnCRL() != null) {
                s.setTimestamp(6, new Timestamp(token.getExpiredCertsOnCRL().getTime()));
            } else {
                s.setNull(6, 93);
            }
            s.setBytes(7, token.getIssuerToken().getEncoded());
            s.setBoolean(8, token.isIssuerX509PrincipalMatches());
            s.setBoolean(9, token.isSignatureIntact());
            s.setBoolean(10, token.isCrlSignKeyUsage());
            s.setBoolean(11, token.isUnknownCriticalExtension());
            s.setString(12, token.getSignatureInvalidityReason());
            s.executeUpdate();
            this.closeQuietly(c, s, rs);
        }
        catch (Throwable throwable) {
            this.closeQuietly(c, s, rs);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCrlInDb(String key, CRLValidity token) throws SQLException {
        Connection c = null;
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            c = this.getDataSource().getConnection();
            s = c.prepareStatement(SQL_FIND_UPDATE);
            s.setBytes(1, token.getCrlEncoded());
            s.setString(2, token.getSignatureAlgorithm().name());
            if (token.getThisUpdate() != null) {
                s.setTimestamp(3, new Timestamp(token.getThisUpdate().getTime()));
            } else {
                s.setNull(3, 93);
            }
            if (token.getNextUpdate() != null) {
                s.setTimestamp(4, new Timestamp(token.getNextUpdate().getTime()));
            } else {
                s.setNull(4, 93);
            }
            if (token.getExpiredCertsOnCRL() != null) {
                s.setTimestamp(5, new Timestamp(token.getExpiredCertsOnCRL().getTime()));
            } else {
                s.setNull(5, 93);
            }
            s.setBytes(6, token.getIssuerToken().getEncoded());
            s.setBoolean(7, token.isIssuerX509PrincipalMatches());
            s.setBoolean(8, token.isSignatureIntact());
            s.setBoolean(9, token.isCrlSignKeyUsage());
            s.setBoolean(10, token.isUnknownCriticalExtension());
            s.setString(11, token.getSignatureInvalidityReason());
            s.setString(12, key);
            s.executeUpdate();
            this.closeQuietly(c, s, rs);
        }
        catch (Throwable throwable) {
            this.closeQuietly(c, s, rs);
            throw throwable;
        }
    }

    private DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) throws Exception {
        this.dataSource = dataSource;
        this.initDao();
    }

    private void closeQuietly(Connection c, Statement s, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (s != null) {
                s.close();
            }
            if (c != null) {
                c.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

