/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.service.http.commons;

import java.net.URLDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapURLUtils {
    private static final Logger LOG = LoggerFactory.getLogger(LdapURLUtils.class);

    private LdapURLUtils() {
    }

    public static String encode(String str) {
        char[] legalChars = new char[]{':', '/', '?', '#', '[', ']', '@', '!', '$', '&', '\'', '(', ')', '*', '+', ',', ';', '=', '-', '.', '_', '~'};
        StringBuilder url = new StringBuilder();
        boolean encoded = false;
        for (int i = 0; i < str.length(); ++i) {
            char curChar = str.charAt(i);
            if (Character.isLetter(curChar) || Character.isDigit(curChar) || LdapURLUtils.contains(legalChars, curChar) || LdapURLUtils.charIsEncoded(str, i)) {
                url.append(curChar);
                continue;
            }
            url.append(LdapURLUtils.getEncodedChar(curChar));
            encoded = true;
        }
        if (encoded) {
            LOG.warn("The obtained ldap url [{}] contains illegal characters. Use encoded address instead : [{}]", (Object)str, (Object)url);
        }
        return url.toString();
    }

    private static boolean contains(char[] chars, char c) {
        for (char ch : chars) {
            if (ch != c) continue;
            return true;
        }
        return false;
    }

    private static String getEncodedChar(char c) {
        String enc = Integer.toHexString(c);
        return enc.length() == 1 ? "%0" + enc : "%" + enc;
    }

    private static boolean charIsEncoded(String str, int i) {
        try {
            if (str.charAt(i) != '%') {
                return false;
            }
            String subString = str.substring(i, i + 3);
            if (!subString.equals(URLDecoder.decode(subString, "UTF-8"))) {
                return true;
            }
        }
        catch (Exception e) {
            LOG.trace("Cannot decode a part of string [{}] starting from position with index [{}]", (Object)str, (Object)i);
            return false;
        }
        return false;
    }
}

