/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.service.crl;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.crl.CRLValidity;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.client.jdbc.JdbcCacheConnector;
import eu.europa.esig.dss.spi.exception.DSSExternalResourceException;
import eu.europa.esig.dss.spi.x509.revocation.JdbcRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLSource;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JdbcCacheCRLSource
extends JdbcRevocationSource<CRL>
implements CRLSource {
    private static final long serialVersionUID = 3007740140330998336L;
    private static final String SQL_INIT_CHECK_EXISTENCE = "SELECT COUNT(*) FROM CACHED_CRL";
    private static final String SQL_INIT_CREATE_TABLE = "CREATE TABLE CACHED_CRL (ID CHAR(40), DATA BLOB, ISSUER LONGVARBINARY)";
    private static final String SQL_FIND_QUERY = "SELECT * FROM CACHED_CRL WHERE ID = ?";
    private static final String SQL_FIND_QUERY_ID = "ID";
    private static final String SQL_FIND_QUERY_DATA = "DATA";
    private static final String SQL_FIND_QUERY_ISSUER = "ISSUER";
    private static final String SQL_FIND_INSERT = "INSERT INTO CACHED_CRL (ID, DATA, ISSUER) VALUES (?, ?, ?)";
    private static final String SQL_FIND_UPDATE = "UPDATE CACHED_CRL SET DATA = ?, ISSUER = ?  WHERE ID = ?";
    private static final String SQL_FIND_REMOVE = "DELETE FROM CACHED_CRL WHERE ID = ?";
    private static final String SQL_DROP_TABLE = "DROP TABLE CACHED_CRL";
    private static List<JdbcCacheConnector.JdbcResultRequest> findCRLRequests = new ArrayList<JdbcCacheConnector.JdbcResultRequest>();

    protected String getCreateTableQuery() {
        return SQL_INIT_CREATE_TABLE;
    }

    protected String getTableExistenceQuery() {
        return SQL_INIT_CHECK_EXISTENCE;
    }

    protected String getFindRevocationQuery() {
        return SQL_FIND_QUERY;
    }

    protected String getRemoveRevocationTokenEntryQuery() {
        return SQL_FIND_REMOVE;
    }

    protected String getDeleteTableQuery() {
        return SQL_DROP_TABLE;
    }

    protected Collection<JdbcCacheConnector.JdbcResultRequest> getRevocationDataExtractRequests() {
        return findCRLRequests;
    }

    protected List<String> initRevocationTokenKeys(CertificateToken certificateToken) {
        return DSSRevocationUtils.getCRLRevocationTokenKeys((CertificateToken)certificateToken);
    }

    protected RevocationToken<CRL> buildRevocationTokenFromResult(JdbcCacheConnector.JdbcResultRecord resultRecord, CertificateToken certificateToken, CertificateToken issuerCertificateToken) throws DSSExternalResourceException {
        try {
            CRLBinary crlBinary = CRLUtils.buildCRLBinary((byte[])((byte[])resultRecord.get(SQL_FIND_QUERY_DATA)));
            CertificateToken cachedIssuerCertificate = DSSUtils.loadCertificate((byte[])((byte[])resultRecord.get(SQL_FIND_QUERY_ISSUER)));
            CRLValidity cached = CRLUtils.buildCRLValidity((CRLBinary)crlBinary, (CertificateToken)cachedIssuerCertificate);
            cached.setIssuerToken(cachedIssuerCertificate);
            CRLToken crlToken = new CRLToken(certificateToken, cached);
            crlToken.setExternalOrigin(RevocationOrigin.CACHED);
            return crlToken;
        }
        catch (Exception e) {
            throw new DSSExternalResourceException(String.format("An error occurred during an attempt to get a revocation token. Reason : %s", e.getMessage()), (Throwable)e);
        }
    }

    protected void insertRevocation(String revocationKey, RevocationToken<CRL> token) {
        CRLToken crlToken = (CRLToken)token;
        CRLValidity crlValidity = crlToken.getCrlValidity();
        this.jdbcCacheConnector.execute(SQL_FIND_INSERT, new Object[]{revocationKey, crlValidity.getDerEncoded(), crlValidity.getIssuerToken().getEncoded()});
    }

    protected void updateRevocation(String revocationKey, RevocationToken<CRL> token) {
        CRLToken crlToken = (CRLToken)token;
        CRLValidity crlValidity = crlToken.getCrlValidity();
        this.jdbcCacheConnector.execute(SQL_FIND_UPDATE, new Object[]{crlValidity.getDerEncoded(), crlValidity.getIssuerToken().getEncoded(), revocationKey});
    }

    public CRLToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        return (CRLToken)super.getRevocationToken(certificateToken, issuerCertificateToken);
    }

    public CRLToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken, boolean forceRefresh) {
        return (CRLToken)super.getRevocationToken(certificateToken, issuerCertificateToken, forceRefresh);
    }

    protected String getRevocationTokenKey(CertificateToken certificateToken, String urlString) {
        return DSSRevocationUtils.getCRLRevocationTokenKey((String)urlString);
    }

    static {
        findCRLRequests.add(new JdbcCacheConnector.JdbcResultRequest(SQL_FIND_QUERY_ID, String.class));
        findCRLRequests.add(new JdbcCacheConnector.JdbcResultRequest(SQL_FIND_QUERY_DATA, byte[].class));
        findCRLRequests.add(new JdbcCacheConnector.JdbcResultRequest(SQL_FIND_QUERY_ISSUER, byte[].class));
    }
}

